## Usage

```js
var defaultCompare = require('{%= name %}');
```

**basic array**

```js
var arr = ['c', 'a', undefined, 'b', 'd', null, 'e'];
console.log(arr.sort(defaultCompare));
//=> ['a', 'b', 'c', 'd', 'e', null, undefined]
```

**objects sorted by their "name" property**

```js
var arr = [
  {name: 'c', title: 'C'},
  {name: 'a', title: 'A'},
  {title: 'G'},
  {name: 'b', title: 'B'},
  {name: 'd', title: 'D'},
  {name: null, title: 'F'},
  {name: 'e', title: 'E'}
];

arr.sort(function(a, b) {
  return defaultCompare(a, b, 'name');
});

console.log(arr);
//=> [
//=>   {name: 'a', title: 'A'},
//=>   {name: 'b', title: 'B'},
//=>   {name: 'c', title: 'C'},
//=>   {name: 'd', title: 'D'},
//=>   {name: 'e', title: 'E'},
//=>   {name: null, title: 'F'},
//=>   {title: 'G'}
//=> ];
```

## API

{%= apidocs('index.js') %}