'use strict'

module.exports = function(list) {
  if (list.constructor !== Array) {
    throw new Error('Item passed to .options is not an array')
  }

  for (const item of list) {
    const preset = item.defaultValue
    const init = item.init || false

    this.option(item.name, item.description, preset, init)
  }

  return this
}
