/* menu.c */

/*
    NUT nutrition software 
    Copyright (C) 1996-2010 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "menu.h"
#include "db.h"
#include "util.h"
#include "recmeal.h"
#include "anameal.h"
#include "remmeal.h"
#include "viewfood.h"
#include "addfood.h"
#include "ranking.h"
#include "options.h"
#include "prtmenu.h"
#include "theusual.h"
#include "trendy.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

void menu()
{
int menu_choice;
for ( ; ; )
 {
 header("NUT:  Main Menu");
 printf("                  1  --  Record Meals\n\n");
 printf("                  2  --  Analyze Meals and Food Suggestions\n\n");
 printf("                  3  --  Delete Meals and Set Meals Per Day\n\n");
 printf("                  4  --  View Foods\n\n");
 printf("                  5  --  Add Foods and Modify Serving Sizes\n\n");
 printf("                  6  --  View Nutrients and Rank Foods\n\n");
 printf("                  7  --  Set Personal Options and Log Weight\n\n");
 printf("                  8  --  Plot Daily and Monthly Trends\n\n");
 printf("                  9  --  Record \"The Usual\"--Customary Meals\n\n");
 printf("                  P  --  Print Menus from Meal Database\n\n");
 spacer(19);
 printf("Enter your choice (\"Q\" to quit):  ");
 menu_choice = get_char();
 switch (menu_choice)
  {
  case 'Q' :
#ifndef DOS
  case 'q' : printf("\033[2JNUT has ended.\n\n"); 
#else
  case 'q' : printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nNUT has ended.\n");
#endif
             return;
             break;
  case '1' : record_meals();
             break; 
  case '2' : analyze_meals(&meal_root,0);
             break; 
  case '3' : remove_meals();
             break; 
  case '4' : view_foods();
             break; 
  case '5' : add_foods_menu();
             break; 
  case '6' : view_nuts_menu();
             break; 
  case '7' : personal_menu();
             break; 
  case '8' : screen_subvert_trendy();
             break; 
  case '9' : theusual();
             break; 
  case 'P' : 
  case 'p' : print_menus();
             break; 
  default  : break;
  }
 }
}

void view_nuts_menu()
{
int menu_choice;
for ( ; ; )
 {
 header("NUT:  View Nutrients and Rank Foods");
 printf("\n\n                          1  --  Per 100 Grams\n\n");
 printf("                          2  --  Per 100 Grams Dry Weight\n\n");
 printf("                          3  --  Per 100 Grams within Food Group ?\n\n");
 printf("                          4  --  Per 100 Calories\n\n");
 printf("                          5  --  Per Serving\n\n");
 printf("                          6  --  Per Serving, Minimize ?\n\n");
 printf("                          7  --  Per Daily Recorded Meals\n\n");
 spacer(16);
 printf("\nEnter your choice (just <enter> to quit):  ");
 menu_choice = get_char();
 Minut = -1;
 Fdgrp = -1;
 switch (menu_choice)
  {
  case '1' : screen_subvert_rank(1);
             break; 
  case '2' : screen_subvert_rank(3);
             break; 
  case '3' : screen_subvert_rank(6);
             break; 
  case '4' : screen_subvert_rank(0);
             break; 
  case '5' : screen_subvert_rank(4);
             break; 
  case '6' : screen_subvert_rank(5);
             break; 
  case '7' : screen_subvert_rank(2);
             break; 
  default  : return;
  }
 }
}

void add_foods_menu()
{
int menu_choice;
header("NUT:  Add Foods and Modify Serving Sizes");
printf("\n\n                           1  --  Add a Recipe\n\n");
printf("                           2  --  Add a Labeled Food\n\n");
printf("                           3  --  Modify Serving Sizes\n\n");
spacer(8);
printf("\nEnter your choice (just <enter> to quit):  ");
menu_choice = get_char();
switch (menu_choice)
 {
 case '1' : add_foods(0);
            break; 
 case '2' : add_foods(1);
            break; 
 case '3' : modify_servings();
            break; 
 default  : return;
 }
}

void screen_subvert_rank(int choice)
{
int screen_choice, i;
view_nuts(choice);
for ( ; ; )
 {
 header("NUT:  View Nutrients and Rank Foods");
 printf("\n      Change group of nutrients to view?\n\n\n");
 for (i = 0; i < MaxScreen; i++) printf("                    %d  --  %s\n\n",i+1,ScreenTitle[i]);
 spacer(MaxScreen*2+4);
 printf("\nEnter your choice (just <enter> to quit):  ");
 screen_choice = get_int();
 if (screen_choice < 1 || screen_choice > MaxScreen) return;
 options.screen = screen_choice - 1;
 write_OPTIONS();
 view_nuts(choice);
 }
}

void screen_subvert_trendy()
{
int screen_choice, i;
char mode = 'd';
mode = trendy(mode);
if (mode == 'X') return;
for ( ; ; )
 {
 if (mode == 'd') header("NUT:  Plot Daily Trends");
 if (mode != 'd') header("NUT:  Plot Monthly Trends");
 printf("\n      Change group of nutrients to view?\n\n\n");
 for (i = 0; i < MaxScreen; i++) printf("                    %d  --  %s\n\n",i+1,ScreenTitle[i]);
 spacer(MaxScreen*2+4);
 printf("\nEnter your choice (just <enter> to quit):  ");
 screen_choice = get_int();
 if (screen_choice < 1 || screen_choice > MaxScreen) return;
 options.screen = screen_choice - 1;
 write_OPTIONS();
 mode = trendy(mode);
 }
}

void personal_menu()
{
int menu_choice;
char calflag[40];
char pcproteinflag[40];
char pccarbflag[40];
char pcsatfatflag[40];
char abproteinflag[40];
char abcarbflag[40];
char abfiberflag[40];
for ( ; ; )
 {
 sprintf(calflag,"%s  %5.1f %s",(options.locknuts[ENERC_KCAL] && options.autocal == 0 ? "(LOCKED:" : options.autocal > 0 ? "(AUTO-SET:"  : "(SET:"),options.abnuts[ENERC_KCAL],"kc)");
 sprintf(pcproteinflag,"%s %5.1f%s",options.locknuts[PROCNT] && options.pcprotein > 0 ? "(LOCKED:" : "(SET:",options.pcprotein,"%)");
 sprintf(pccarbflag,"%s %5.1f%s",options.locknuts[CHOCDF] && options.pccarb > 0 ? "(LOCKED:" : "(SET:",options.pccarb,"%)");
 sprintf(pcsatfatflag,"%s %5.1f%s",options.locknuts[FASAT] ? "(LOCKED:" : "(SET:",options.pcsatfat,"%)");
 sprintf(abproteinflag,"%s  %5.1f %s",options.locknuts[PROCNT] && options.abnuts[PROCNT] > 0 ? "(LOCKED:" : "(SET:",options.abnuts[PROCNT],"g)");
 if (options.abnuts[CHOCDF] >= 0) sprintf(abcarbflag,"%s  %5.1f %s",options.locknuts[CHOCDF] && options.abnuts[CHOCDF] > 0 ? "(LOCKED:" : "(SET:",options.abnuts[CHOCDF],"g)");
 else sprintf(abcarbflag,"%s %5.1f %s","(LOCKED:  Fiber +",-1 * options.abnuts[CHOCDF],"g)");
 sprintf(abfiberflag,"%s %5.1f %s",options.locknuts[FIBTG] ? "(LOCKED:" : "(SET:",options.abnuts[FIBTG],"g)");
 header("NUT:  Personal Options");
 printf("                1  --  Change Calorie Level %s\n\n",options.abnuts[ENERC_KCAL] != 2000 || options.locknuts[ENERC_KCAL] || options.autocal > 0 ? calflag : "(default)");
 if (options.n6hufa == 0 && options.abnuts[FAPU] == 0) printf("                2  --  Essential Fatty Acid Options (default)\n\n");
 else if (options.locknuts[FAPU] == 1) printf("                2  --  Essential Fatty Acid Options (LOCKED:  %3.1f g)\n\n",options.abnuts[FAPU]);
 else if (options.n6hufa == 90 && options.abnuts[FAPU] == 0) printf("                2  --  Essential Fatty Acid Options (SET:  off)\n\n");
 else if (options.n6hufa > 0 && options.abnuts[FAPU] == 0) printf("                2  --  Essential Fatty Acid Options (SET:  %2.0f/%2.0f)\n\n",options.n6hufa,100-options.n6hufa);
 else if (options.abnuts[FAPU] > 0) printf("                2  --  Essential Fatty Acid Options (SET:  %3.1f g)\n\n",options.abnuts[FAPU]);
 printf("                3  --  Saturated Fat Percentage %s\n\n",options.pcsatfat ? pcsatfatflag : "(default)");
 printf("                4  --  Fiber Absolute Amount %s\n\n",options.abnuts[FIBTG] ? abfiberflag : "(default)");
 printf("                5  --  Carbohydrate Percentage %s\n\n",options.pccarb ? pccarbflag : "(default)");
 printf("                6  --  Protein Percentage %s\n\n",options.pcprotein ? pcproteinflag : "(default)");
 printf("                7  --  Carbohydrate Absolute Amount %s\n\n",options.abnuts[CHOCDF] ? abcarbflag : "(default)");
 printf("                8  --  Protein Absolute Amount %s\n\n",options.abnuts[PROCNT] ? abproteinflag : "(default)");
 printf("                0  --  Restore All Defaults\n\n");
 printf("                W  --  Weight Log Regression\n");
 spacer(19);
 printf("\nEnter your choice (just <enter> to quit):  ");
 menu_choice = get_char();
 switch (menu_choice)
  {
  case '1' : personal_cal();
             break; 
  case '2' : efa_options();
             break; 
  case '3' : satfat_percent();
             break; 
  case '4' : fiber_absolute();
             break; 
  case '5' : carb_percent();
             break; 
  case '6' : protein_percent();
             break; 
  case '7' : carb_absolute();
             break; 
  case '8' : protein_absolute();
             break; 
  case '0' : restore_defaults(1);
             break; 
  case 'w' :
  case 'W' : weight_log();
             break;
  default  : return;
  }
 }
}
