// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _FilletSurf_Builder_HeaderFile
#define _FilletSurf_Builder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _FilletSurf_InternalBuilder_HeaderFile
#include <FilletSurf_InternalBuilder.hxx>
#endif
#ifndef _FilletSurf_StatusDone_HeaderFile
#include <FilletSurf_StatusDone.hxx>
#endif
#ifndef _FilletSurf_ErrorTypeStatus_HeaderFile
#include <FilletSurf_ErrorTypeStatus.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _FilletSurf_StatusType_HeaderFile
#include <FilletSurf_StatusType.hxx>
#endif
#ifndef _Handle_Geom_TrimmedCurve_HeaderFile
#include <Handle_Geom_TrimmedCurve.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class TopoDS_Shape;
class TopTools_ListOfShape;
class Geom_Surface;
class TopoDS_Face;
class Geom_Curve;
class Geom2d_Curve;
class Geom_TrimmedCurve;


//!  API giving the  following  geometric information about fillets <br>
//!            list of corresponding NUBS surfaces <br>
//!            for each surface: <br>
//!               the 2  support faces <br>
//!               on each face: the 3d curve and the corresponding 2d curve <br>
//!               the 2d curves on the fillet <br>
//!            status of start and end section of the fillet <br>
//!            first and last parameter on edge of the fillet. <br>
class FilletSurf_Builder  {
public:

  DEFINE_STANDARD_ALLOC

  //! initialize  of the informations necessary for  the <br>
//!          computation of  the fillet on the <br>
//!          Shape S from a list of edges E and a radius R. <br>
//! <br>
//!           Ta is the angular tolerance <br>
//!		 Tapp3d is the 3d approximation tolerance <br>
//!		 Tapp2d is the 2d approximation tolerance <br>
//! <br>
//! <br>
//! <br>
  Standard_EXPORT   FilletSurf_Builder(const TopoDS_Shape& S,const TopTools_ListOfShape& E,const Standard_Real R,const Standard_Real Ta = 1.0e-2,const Standard_Real Tapp3d = 1.0e-4,const Standard_Real Tapp2d = 1.0e-5);
  //!---Purpose computation  of the fillet (list of NUBS) <br>
  Standard_EXPORT     void Perform() ;
  
  Standard_EXPORT     void Simulate() ;
  //! gives the status about the computation of the fillet <br>
//!          returns: <br>
//!          IsOK :no problem during the computation <br>
//!          IsNotOk: no result is produced <br>
//!          IsPartial: the result is partial <br>
  Standard_EXPORT     FilletSurf_StatusDone IsDone() const;
  //! gives    informations     about  error   status     if <br>
//!          IsDone=IsNotOk <br>
//!          returns <br>
//!          EdgeNotG1: the edges are not G1 <br>
//!          FacesNotG1 : two connected faces on a same support are <br>
//!          not  G1 <br>
//!          EdgeNotOnShape: the  edge   is  not on  shape <br>
//!          NotSharpEdge: the  edge is not sharp <br>
//!          PbFilletCompute: problem during the computation of the fillet <br>
  Standard_EXPORT     FilletSurf_ErrorTypeStatus StatusError() const;
  //! gives the number of NUBS surfaces  of the Fillet. <br>
  Standard_EXPORT     Standard_Integer NbSurface() const;
  //! gives the NUBS surface of index Index. <br>
  Standard_EXPORT    const Handle_Geom_Surface& SurfaceFillet(const Standard_Integer Index) const;
  //! gives  the  3d  tolerance reached during approximation <br>
//!          of surface of index Index <br>
  Standard_EXPORT     Standard_Real TolApp3d(const Standard_Integer Index) const;
  //!gives the first support  face relative to SurfaceFillet(Index); <br>
  Standard_EXPORT    const TopoDS_Face& SupportFace1(const Standard_Integer Index) const;
  //!gives the second support  face relative to SurfaceFillet(Index); <br>
  Standard_EXPORT    const TopoDS_Face& SupportFace2(const Standard_Integer Index) const;
  //!    gives  the 3d curve  of SurfaceFillet(Index)  on SupportFace1(Index) <br>
  Standard_EXPORT    const Handle_Geom_Curve& CurveOnFace1(const Standard_Integer Index) const;
  //! gives the     3d  curve of  SurfaceFillet(Index) on SupportFace2(Index) <br>
  Standard_EXPORT    const Handle_Geom_Curve& CurveOnFace2(const Standard_Integer Index) const;
  //!gives the  PCurve associated to CurvOnSup1(Index)  on the support face <br>
  Standard_EXPORT    const Handle_Geom2d_Curve& PCurveOnFace1(const Standard_Integer Index) const;
  //! gives the PCurve associated to CurveOnFace1(Index) on the Fillet <br>
  Standard_EXPORT    const Handle_Geom2d_Curve& PCurve1OnFillet(const Standard_Integer Index) const;
  //! gives the PCurve  associated to CurveOnSup2(Index) on  the  support face <br>
  Standard_EXPORT    const Handle_Geom2d_Curve& PCurveOnFace2(const Standard_Integer Index) const;
  //! gives the PCurve  associated to CurveOnSup2(Index) on  the  fillet <br>
  Standard_EXPORT    const Handle_Geom2d_Curve& PCurve2OnFillet(const Standard_Integer Index) const;
  //!gives the parameter of the fillet  on the first edge. <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  //! gives the  parameter of the fillet  on the last edge <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  
  Standard_EXPORT     FilletSurf_StatusType StartSectionStatus() const;
  
  Standard_EXPORT     FilletSurf_StatusType EndSectionStatus() const;
  
  Standard_EXPORT     Standard_Integer NbSection(const Standard_Integer IndexSurf) const;
  
  Standard_EXPORT     void Section(const Standard_Integer IndexSurf,const Standard_Integer IndexSec,Handle(Geom_TrimmedCurve)& Circ) const;





protected:





private:



FilletSurf_InternalBuilder myIntBuild;
FilletSurf_StatusDone myisdone;
FilletSurf_ErrorTypeStatus myerrorstatus;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
