// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepClass3d_SClassifier_HeaderFile
#define _BRepClass3d_SClassifier_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Face.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <TopAbs_State.hxx>
class Standard_DomainError;
class BRepClass3d_SolidExplorer;
class gp_Pnt;
class TopoDS_Face;


//! Provides an algorithm to classify a point in a solid.
class BRepClass3d_SClassifier 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Empty constructor.
  Standard_EXPORT BRepClass3d_SClassifier();
  
  //! Constructor to classify the point P with the
  //! tolerance Tol on the solid S.
  Standard_EXPORT BRepClass3d_SClassifier(BRepClass3d_SolidExplorer& S, const gp_Pnt& P, const Standard_Real Tol);
  
  //! Classify the point P with the
  //! tolerance Tol on the solid S.
  Standard_EXPORT   void Perform (BRepClass3d_SolidExplorer& S, const gp_Pnt& P, const Standard_Real Tol) ;
  
  //! Classify an infinite point with the
  //! tolerance Tol on the solid S.
  Standard_EXPORT   void PerformInfinitePoint (BRepClass3d_SolidExplorer& S, const Standard_Real Tol) ;
  
  //! Returns True if the classification has been
  //! computed by rejection.
  //! The State is then OUT.
  Standard_EXPORT   Standard_Boolean Rejected()  const;
  
  //! Returns the result of the classification.
  Standard_EXPORT   TopAbs_State State()  const;
  
  //! Returns True when the point is a point of a face.
  Standard_EXPORT   Standard_Boolean IsOnAFace()  const;
  
  //! Returns the face used to determine the
  //! classification. When the state is ON, this is the
  //! face containing the point.
  //!
  //! When Rejected() returns True, Face() has no signification.
  Standard_EXPORT   TopoDS_Face Face()  const;




protected:

  
  Standard_EXPORT   void ForceIn() ;
  
  Standard_EXPORT   void ForceOut() ;




private:



  TopoDS_Face myFace;
  Standard_Integer myState;


};







#endif // _BRepClass3d_SClassifier_HeaderFile
