/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMPCIDEVICEACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMPCIDEVICEACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_ComputerSystemPCIDevice.h"
#include "assocOpenDRIM_ComputerSystemPCIDevice.h"

int PCI_OpenDRIM_ComputerSystemPCIDevice_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_unload(string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemPCIDevice>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ComputerSystemPCIDevice_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemPCIDevice& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemPCIDevice& newInstance, const OpenDRIM_ComputerSystemPCIDevice& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemPCIDevice& instance, string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemPCIDevice& instance, string& errorMessage);

int PCI_OpenDRIM_ComputerSystemPCIDevice_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ComputerSystemPCIDevice_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ComputerSystemPCIDevice_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ComputerSystemPCIDevice>& OpenDRIM_ComputerSystemPCIDevice_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ComputerSystemPCIDevice_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ComputerSystemPCIDevice>& OpenDRIM_ComputerSystemPCIDevice_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ComputerSystemPCIDevice_populate(OpenDRIM_ComputerSystemPCIDevice& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMPCIDEVICEACCESS_H_*/
