#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

namespace OpenTK.Graphics.ES20
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
    #pragma warning disable 3019
    #pragma warning disable 1591
    #pragma warning disable 1572
    #pragma warning disable 1573

    partial class GL
    {

        public static partial class Amd
        {
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBeginPerfMonitorAMD")]
            public static 
            void BeginPerfMonitor(Int32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBeginPerfMonitorAMD")]
            public static 
            void BeginPerfMonitor(UInt32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, Int32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, ref Int32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = &monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            unsafe void DeletePerfMonitors(Int32 n, Int32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, UInt32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, ref UInt32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = &monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            unsafe void DeletePerfMonitors(Int32 n, UInt32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEndPerfMonitorAMD")]
            public static 
            void EndPerfMonitor(Int32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEndPerfMonitorAMD")]
            public static 
            void EndPerfMonitor(UInt32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] Int32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] out Int32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = &monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            unsafe void GenPerfMonitors(Int32 n, [OutAttribute] Int32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] UInt32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] out UInt32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = &monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            unsafe void GenPerfMonitors(Int32 n, [OutAttribute] UInt32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] Int32[] data, [OutAttribute] Int32[] bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* data_ptr = data)
                    fixed (Int32* bytesWritten_ptr = bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] out Int32 data, [OutAttribute] out Int32 bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* data_ptr = &data)
                    fixed (Int32* bytesWritten_ptr = &bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                        data = *data_ptr;
                        bytesWritten = *bytesWritten_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] Int32* data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data, (Int32*)bytesWritten);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] UInt32[] data, [OutAttribute] Int32[] bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* data_ptr = data)
                    fixed (Int32* bytesWritten_ptr = bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] out UInt32 data, [OutAttribute] out Int32 bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* data_ptr = &data)
                    fixed (Int32* bytesWritten_ptr = &bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                        data = *data_ptr;
                        bytesWritten = *bytesWritten_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.ES20.All pname, Int32 dataSize, [OutAttribute] UInt32* data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.ES20.All)pname, (Int32)dataSize, (UInt32*)data, (Int32*)bytesWritten);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo(Int32 group, Int32 counter, OpenTK.Graphics.ES20.All pname, [OutAttribute] IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo(UInt32 group, UInt32 counter, OpenTK.Graphics.ES20.All pname, [OutAttribute] IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.ES20.All)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(Int32 group, [OutAttribute] Int32[] numCounters, [OutAttribute] Int32[] maxActiveCounters, Int32 counterSize, [OutAttribute] Int32[] counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = numCounters)
                    fixed (Int32* maxActiveCounters_ptr = maxActiveCounters)
                    fixed (Int32* counters_ptr = counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(Int32 group, [OutAttribute] out Int32 numCounters, [OutAttribute] out Int32 maxActiveCounters, Int32 counterSize, [OutAttribute] out Int32 counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = &numCounters)
                    fixed (Int32* maxActiveCounters_ptr = &maxActiveCounters)
                    fixed (Int32* counters_ptr = &counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                        numCounters = *numCounters_ptr;
                        maxActiveCounters = *maxActiveCounters_ptr;
                        counters = *counters_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(Int32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] Int32* counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(UInt32 group, [OutAttribute] Int32[] numCounters, [OutAttribute] Int32[] maxActiveCounters, Int32 counterSize, [OutAttribute] UInt32[] counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = numCounters)
                    fixed (Int32* maxActiveCounters_ptr = maxActiveCounters)
                    fixed (UInt32* counters_ptr = counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(UInt32 group, [OutAttribute] out Int32 numCounters, [OutAttribute] out Int32 maxActiveCounters, Int32 counterSize, [OutAttribute] out UInt32 counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = &numCounters)
                    fixed (Int32* maxActiveCounters_ptr = &maxActiveCounters)
                    fixed (UInt32* counters_ptr = &counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                        numCounters = *numCounters_ptr;
                        maxActiveCounters = *maxActiveCounters_ptr;
                        counters = *counters_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(UInt32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] UInt32* counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(Int32 group, Int32 counter, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(Int32 group, Int32 counter, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            unsafe void GetPerfMonitorCounterString(Int32 group, Int32 counter, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length, (StringBuilder)counterString);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(UInt32 group, UInt32 counter, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(UInt32 group, UInt32 counter, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            unsafe void GetPerfMonitorCounterString(UInt32 group, UInt32 counter, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length, (StringBuilder)counterString);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] Int32[] numGroups, Int32 groupsSize, [OutAttribute] Int32[] groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = numGroups)
                    fixed (Int32* groups_ptr = groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] Int32[] numGroups, Int32 groupsSize, [OutAttribute] UInt32[] groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = numGroups)
                    fixed (UInt32* groups_ptr = groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out Int32 groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = &numGroups)
                    fixed (Int32* groups_ptr = &groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                        numGroups = *numGroups_ptr;
                        groups = *groups_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out UInt32 groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = &numGroups)
                    fixed (UInt32* groups_ptr = &groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                        numGroups = *numGroups_ptr;
                        groups = *groups_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] Int32* groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] UInt32* groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(Int32 group, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(Int32 group, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            unsafe void GetPerfMonitorGroupString(Int32 group, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length, (StringBuilder)groupString);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(UInt32 group, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(UInt32 group, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            unsafe void GetPerfMonitorGroupString(UInt32 group, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length, (StringBuilder)groupString);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, Int32[] countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* countersList_ptr = countersList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, ref Int32 countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* countersList_ptr = &countersList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            unsafe void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, Int32* countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, UInt32[] countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* countersList_ptr = countersList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, ref UInt32 countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* countersList_ptr = &countersList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            unsafe void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, UInt32* countersList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)countersList);
                #if DEBUG
                }
                #endif
            }

        }

        
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the larger of (GL_MAX_TEXTURE_COORDS - 1) and (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glActiveTexture")]
        public static 
        void ActiveTexture(OpenTK.Graphics.ES20.TextureUnit texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glActiveTexture((OpenTK.Graphics.ES20.TextureUnit)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Attaches a shader object to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to which a shader object will be attached.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object that is to be attached.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glAttachShader")]
        public static 
        void AttachShader(Int32 program, Int32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAttachShader((UInt32)program, (UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Attaches a shader object to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to which a shader object will be attached.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object that is to be attached.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glAttachShader")]
        public static 
        void AttachShader(UInt32 program, UInt32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAttachShader((UInt32)program, (UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindAttribLocation")]
        public static 
        void BindAttribLocation(Int32 program, Int32 index, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindAttribLocation((UInt32)program, (UInt32)index, (String)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindAttribLocation")]
        public static 
        void BindAttribLocation(UInt32 program, UInt32 index, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindAttribLocation((UInt32)program, (UInt32)index, (String)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindBuffer")]
        public static 
        void BindBuffer(OpenTK.Graphics.ES20.BufferTarget target, Int32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindBuffer((OpenTK.Graphics.ES20.BufferTarget)target, (UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindBuffer")]
        public static 
        void BindBuffer(OpenTK.Graphics.ES20.BufferTarget target, UInt32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindBuffer((OpenTK.Graphics.ES20.BufferTarget)target, (UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindFramebuffer")]
        public static 
        void BindFramebuffer(OpenTK.Graphics.ES20.FramebufferTarget target, Int32 framebuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindFramebuffer((OpenTK.Graphics.ES20.FramebufferTarget)target, (UInt32)framebuffer);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindFramebuffer")]
        public static 
        void BindFramebuffer(OpenTK.Graphics.ES20.FramebufferTarget target, UInt32 framebuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindFramebuffer((OpenTK.Graphics.ES20.FramebufferTarget)target, (UInt32)framebuffer);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindRenderbuffer")]
        public static 
        void BindRenderbuffer(OpenTK.Graphics.ES20.RenderbufferTarget target, Int32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindRenderbuffer((OpenTK.Graphics.ES20.RenderbufferTarget)target, (UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindRenderbuffer")]
        public static 
        void BindRenderbuffer(OpenTK.Graphics.ES20.RenderbufferTarget target, UInt32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindRenderbuffer((OpenTK.Graphics.ES20.RenderbufferTarget)target, (UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES20.TextureTarget target, Int32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES20.TextureTarget)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES20.TextureTarget target, UInt32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES20.TextureTarget)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the blend color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// specify the components of GL_BLEND_COLOR
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBlendColor")]
        public static 
        void BlendColor(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the equation used for both the RGB blend equation and the Alpha blend equation
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// specifies how source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBlendEquation")]
        public static 
        void BlendEquation(OpenTK.Graphics.ES20.BlendEquationMode mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendEquation((OpenTK.Graphics.ES20.BlendEquationMode)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the RGB blend equation and the alpha blend equation separately
        /// </summary>
        /// <param name="modeRGB">
        /// <para>
        /// specifies the RGB blend equation, how the red, green, and blue components of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        /// <param name="modeAlpha">
        /// <para>
        /// specifies the alpha blend equation, how the alpha component of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBlendEquationSeparate")]
        public static 
        void BlendEquationSeparate(OpenTK.Graphics.ES20.BlendEquationMode modeRGB, OpenTK.Graphics.ES20.BlendEquationMode modeAlpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendEquationSeparate((OpenTK.Graphics.ES20.BlendEquationMode)modeRGB, (OpenTK.Graphics.ES20.BlendEquationMode)modeAlpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify pixel arithmetic
        /// </summary>
        /// <param name="sfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA, GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA, and GL_SRC_ALPHA_SATURATE. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBlendFunc")]
        public static 
        void BlendFunc(OpenTK.Graphics.ES20.BlendingFactorSrc sfactor, OpenTK.Graphics.ES20.BlendingFactorDest dfactor)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendFunc((OpenTK.Graphics.ES20.BlendingFactorSrc)sfactor, (OpenTK.Graphics.ES20.BlendingFactorDest)dfactor);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify pixel arithmetic for RGB and alpha components separately
        /// </summary>
        /// <param name="srcRGB">
        /// <para>
        /// Specifies how the red, green, and blue blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA, GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA, and GL_SRC_ALPHA_SATURATE. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstRGB">
        /// <para>
        /// Specifies how the red, green, and blue destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        /// <param name="srcAlpha">
        /// <para>
        /// Specified how the alpha source blending factor is computed. The same symbolic constants are accepted as for srcRGB. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstAlpha">
        /// <para>
        /// Specified how the alpha destination blending factor is computed. The same symbolic constants are accepted as for dstRGB. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBlendFuncSeparate")]
        public static 
        void BlendFuncSeparate(OpenTK.Graphics.ES20.BlendingFactorSrc srcRGB, OpenTK.Graphics.ES20.BlendingFactorDest dstRGB, OpenTK.Graphics.ES20.BlendingFactorSrc srcAlpha, OpenTK.Graphics.ES20.BlendingFactorDest dstAlpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendFuncSeparate((OpenTK.Graphics.ES20.BlendingFactorSrc)srcRGB, (OpenTK.Graphics.ES20.BlendingFactorDest)dstRGB, (OpenTK.Graphics.ES20.BlendingFactorSrc)srcAlpha, (OpenTK.Graphics.ES20.BlendingFactorDest)dstAlpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferData")]
        public static 
        void BufferData(OpenTK.Graphics.ES20.BufferTarget target, IntPtr size, IntPtr data, OpenTK.Graphics.ES20.BufferUsage usage)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBufferData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)size, (IntPtr)data, (OpenTK.Graphics.ES20.BufferUsage)usage);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[] data, OpenTK.Graphics.ES20.BufferUsage usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES20.BufferUsage)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[,] data, OpenTK.Graphics.ES20.BufferUsage usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES20.BufferUsage)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[,,] data, OpenTK.Graphics.ES20.BufferUsage usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES20.BufferUsage)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] ref T2 data, OpenTK.Graphics.ES20.BufferUsage usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES20.BufferUsage)usage);
                data = (T2)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData(OpenTK.Graphics.ES20.BufferTarget target, IntPtr offset, IntPtr size, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBufferSubData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,,] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES20.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES20.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T3)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCheckFramebufferStatus")]
        public static 
        OpenTK.Graphics.ES20.FramebufferErrorCode CheckFramebufferStatus(OpenTK.Graphics.ES20.FramebufferTarget target)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glCheckFramebufferStatus((OpenTK.Graphics.ES20.FramebufferTarget)target);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The four masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, GL_ACCUM_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glClear")]
        public static 
        void Clear(OpenTK.Graphics.ES20.ClearBufferMask mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClear((OpenTK.Graphics.ES20.ClearBufferMask)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify clear values for the color buffers
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify the red, green, blue, and alpha values used when the color buffers are cleared. The initial values are all 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glClearColor")]
        public static 
        void ClearColor(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the depth buffer
        /// </summary>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glClearDepthf")]
        public static 
        void ClearDepth(Single depth)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearDepthf((Single)depth);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the stencil buffer
        /// </summary>
        /// <param name="s">
        /// <para>
        /// Specifies the index used when the stencil buffer is cleared. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glClearStencil")]
        public static 
        void ClearStencil(Int32 s)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearStencil((Int32)s);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable and disable writing of frame buffer color components
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glColorMask")]
        public static 
        void ColorMask(bool red, bool green, bool blue, bool alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColorMask((bool)red, (bool)green, (bool)blue, (bool)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompileShader")]
        public static 
        void CompileShader(Int32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompileShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompileShader")]
        public static 
        void CompileShader(UInt32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompileShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T7 data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T7)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T8)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy pixels into a 2D texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the internal format of the texture. Must be one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_RGB, GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. Must be 0 or 2 sup n + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. Must be 0 or 2 sup m + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCopyTexImage2D")]
        public static 
        void CopyTexImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCopyTexSubImage2D")]
        public static 
        void CopyTexSubImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates a program object
        /// </summary>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCreateProgram")]
        public static 
        Int32 CreateProgram()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glCreateProgram();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates a shader object
        /// </summary>
        /// <param name="shaderType">
        /// <para>
        /// Specifies the type of shader to be created. Must be either GL_VERTEX_SHADER or GL_FRAGMENT_SHADER.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCreateShader")]
        public static 
        Int32 CreateShader(OpenTK.Graphics.ES20.ShaderType type)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glCreateShader((OpenTK.Graphics.ES20.ShaderType)type);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify whether front- or back-facing facets can be culled
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies whether front- or back-facing facets are candidates for culling. Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value is GL_BACK.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCullFace")]
        public static 
        void CullFace(OpenTK.Graphics.ES20.CullFaceMode mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCullFace((OpenTK.Graphics.ES20.CullFaceMode)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, Int32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, ref Int32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        unsafe void DeleteBuffers(Int32 n, Int32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, UInt32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, ref UInt32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteBuffers")]
        public static 
        unsafe void DeleteBuffers(Int32 n, UInt32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        void DeleteFramebuffers(Int32 n, Int32[] framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        void DeleteFramebuffers(Int32 n, ref Int32 framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        unsafe void DeleteFramebuffers(Int32 n, Int32* framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        void DeleteFramebuffers(Int32 n, UInt32[] framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        void DeleteFramebuffers(Int32 n, ref UInt32 framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFramebuffers")]
        public static 
        unsafe void DeleteFramebuffers(Int32 n, UInt32* framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteFramebuffers((Int32)n, (UInt32*)framebuffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteProgram")]
        public static 
        void DeleteProgram(Int32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteProgram")]
        public static 
        void DeleteProgram(UInt32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        void DeleteRenderbuffers(Int32 n, Int32[] renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        void DeleteRenderbuffers(Int32 n, ref Int32 renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        unsafe void DeleteRenderbuffers(Int32 n, Int32* renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        void DeleteRenderbuffers(Int32 n, UInt32[] renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        void DeleteRenderbuffers(Int32 n, ref UInt32 renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteRenderbuffers")]
        public static 
        unsafe void DeleteRenderbuffers(Int32 n, UInt32* renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Deletes a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteShader")]
        public static 
        void DeleteShader(Int32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Deletes a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteShader")]
        public static 
        void DeleteShader(UInt32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value used for depth buffer comparisons
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_LESS.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDepthFunc")]
        public static 
        void DepthFunc(OpenTK.Graphics.ES20.DepthFunction func)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthFunc((OpenTK.Graphics.ES20.DepthFunction)func);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable writing into the depth buffer
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE, depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing is enabled.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDepthMask")]
        public static 
        void DepthMask(bool flag)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthMask((bool)flag);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify mapping of depth values from normalized device coordinates to window coordinates
        /// </summary>
        /// <param name="nearVal">
        /// <para>
        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="farVal">
        /// <para>
        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDepthRangef")]
        public static 
        void DepthRange(Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthRangef((Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Detaches a shader object from a program object to which it is attached
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object from which to detach the shader object.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be detached.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDetachShader")]
        public static 
        void DetachShader(Int32 program, Int32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDetachShader((UInt32)program, (UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Detaches a shader object from a program object to which it is attached
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object from which to detach the shader object.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be detached.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDetachShader")]
        public static 
        void DetachShader(UInt32 program, UInt32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDetachShader((UInt32)program, (UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDisable")]
        public static 
        void Disable(OpenTK.Graphics.ES20.EnableCap cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisable((OpenTK.Graphics.ES20.EnableCap)cap);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDisableDriverControlQCOM")]
        public static 
        void DisableDriverControlQCOM(Int32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDisableDriverControlQCOM")]
        public static 
        void DisableDriverControlQCOM(UInt32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDisableVertexAttribArray")]
        public static 
        void DisableVertexAttribArray(Int32 index)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableVertexAttribArray((UInt32)index);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDisableVertexAttribArray")]
        public static 
        void DisableVertexAttribArray(UInt32 index)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableVertexAttribArray((UInt32)index);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="first">
        /// <para>
        /// Specifies the starting index in the enabled arrays.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of indices to be rendered.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawArrays")]
        public static 
        void DrawArrays(OpenTK.Graphics.ES20.BeginMode mode, Int32 first, Int32 count)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawArrays((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)first, (Int32)count);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements(OpenTK.Graphics.ES20.BeginMode mode, Int32 count, OpenTK.Graphics.ES20.DrawElementsType type, IntPtr indices)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawElements((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)count, (OpenTK.Graphics.ES20.DrawElementsType)type, (IntPtr)indices);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES20.BeginMode mode, Int32 count, OpenTK.Graphics.ES20.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)count, (OpenTK.Graphics.ES20.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES20.BeginMode mode, Int32 count, OpenTK.Graphics.ES20.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)count, (OpenTK.Graphics.ES20.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES20.BeginMode mode, Int32 count, OpenTK.Graphics.ES20.DrawElementsType type, [InAttribute, OutAttribute] T3[,,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)count, (OpenTK.Graphics.ES20.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES20.BeginMode mode, Int32 count, OpenTK.Graphics.ES20.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES20.BeginMode)mode, (Int32)count, (OpenTK.Graphics.ES20.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T3)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEnable")]
        public static 
        void Enable(OpenTK.Graphics.ES20.EnableCap cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnable((OpenTK.Graphics.ES20.EnableCap)cap);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEnableDriverControlQCOM")]
        public static 
        void EnableDriverControlQCOM(Int32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEnableDriverControlQCOM")]
        public static 
        void EnableDriverControlQCOM(UInt32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEnableVertexAttribArray")]
        public static 
        void EnableVertexAttribArray(Int32 index)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableVertexAttribArray((UInt32)index);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEnableVertexAttribArray")]
        public static 
        void EnableVertexAttribArray(UInt32 index)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableVertexAttribArray((UInt32)index);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Block until all GL execution is complete
        /// </summary>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFinish")]
        public static 
        void Finish()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFinish();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Force execution of GL commands in finite time
        /// </summary>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFlush")]
        public static 
        void Flush()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFlush();
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferRenderbuffer")]
        public static 
        void FramebufferRenderbuffer(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.RenderbufferTarget renderbuffertarget, Int32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFramebufferRenderbuffer((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.RenderbufferTarget)renderbuffertarget, (UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferRenderbuffer")]
        public static 
        void FramebufferRenderbuffer(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.RenderbufferTarget renderbuffertarget, UInt32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFramebufferRenderbuffer((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.RenderbufferTarget)renderbuffertarget, (UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferTexture2D")]
        public static 
        void FramebufferTexture2D(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.TextureTarget textarget, Int32 texture, Int32 level)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFramebufferTexture2D((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.TextureTarget)textarget, (UInt32)texture, (Int32)level);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferTexture2D")]
        public static 
        void FramebufferTexture2D(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.TextureTarget textarget, UInt32 texture, Int32 level)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFramebufferTexture2D((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.TextureTarget)textarget, (UInt32)texture, (Int32)level);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define front- and back-facing polygons
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are accepted. The initial value is GL_CCW.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFrontFace")]
        public static 
        void FrontFace(OpenTK.Graphics.ES20.FrontFaceDirection mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrontFace((OpenTK.Graphics.ES20.FrontFaceDirection)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, [OutAttribute] Int32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, [OutAttribute] out Int32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        unsafe void GenBuffers(Int32 n, [OutAttribute] Int32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, [OutAttribute] UInt32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, [OutAttribute] out UInt32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenBuffers")]
        public static 
        unsafe void GenBuffers(Int32 n, [OutAttribute] UInt32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenerateMipmap")]
        public static 
        void GenerateMipmap(OpenTK.Graphics.ES20.TextureTarget target)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenerateMipmap((OpenTK.Graphics.ES20.TextureTarget)target);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        void GenFramebuffers(Int32 n, [OutAttribute] Int32[] framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        void GenFramebuffers(Int32 n, [OutAttribute] out Int32 framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                    framebuffers = *framebuffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        unsafe void GenFramebuffers(Int32 n, [OutAttribute] Int32* framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        void GenFramebuffers(Int32 n, [OutAttribute] UInt32[] framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        void GenFramebuffers(Int32 n, [OutAttribute] out UInt32 framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
                    framebuffers = *framebuffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFramebuffers")]
        public static 
        unsafe void GenFramebuffers(Int32 n, [OutAttribute] UInt32* framebuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenFramebuffers((Int32)n, (UInt32*)framebuffers);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        void GenRenderbuffers(Int32 n, [OutAttribute] Int32[] renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        void GenRenderbuffers(Int32 n, [OutAttribute] out Int32 renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                    renderbuffers = *renderbuffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        unsafe void GenRenderbuffers(Int32 n, [OutAttribute] Int32* renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        void GenRenderbuffers(Int32 n, [OutAttribute] UInt32[] renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        void GenRenderbuffers(Int32 n, [OutAttribute] out UInt32 renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
                    renderbuffers = *renderbuffers_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenRenderbuffers")]
        public static 
        unsafe void GenRenderbuffers(Int32 n, [OutAttribute] UInt32* renderbuffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenRenderbuffers((Int32)n, (UInt32*)renderbuffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, [OutAttribute] Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, [OutAttribute] out Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, [OutAttribute] Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, [OutAttribute] UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, [OutAttribute] out UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, [OutAttribute] UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        void GetActiveAttrib(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] Int32[] size, [OutAttribute] OpenTK.Graphics.ES20.ActiveAttribType[] type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (OpenTK.Graphics.ES20.ActiveAttribType* type_ptr = type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveAttribType*)type_ptr, (StringBuilder)name);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        void GetActiveAttrib(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.ES20.ActiveAttribType type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (OpenTK.Graphics.ES20.ActiveAttribType* type_ptr = &type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveAttribType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        unsafe void GetActiveAttrib(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.ES20.ActiveAttribType* type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length, (Int32*)size, (OpenTK.Graphics.ES20.ActiveAttribType*)type, (StringBuilder)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        void GetActiveAttrib(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] Int32[] size, [OutAttribute] OpenTK.Graphics.ES20.ActiveAttribType[] type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (OpenTK.Graphics.ES20.ActiveAttribType* type_ptr = type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveAttribType*)type_ptr, (StringBuilder)name);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        void GetActiveAttrib(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.ES20.ActiveAttribType type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (OpenTK.Graphics.ES20.ActiveAttribType* type_ptr = &type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveAttribType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveAttrib")]
        public static 
        unsafe void GetActiveAttrib(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.ES20.ActiveAttribType* type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length, (Int32*)size, (OpenTK.Graphics.ES20.ActiveAttribType*)type, (StringBuilder)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        void GetActiveUniform(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] Int32[] size, [OutAttribute] OpenTK.Graphics.ES20.ActiveUniformType[] type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (OpenTK.Graphics.ES20.ActiveUniformType* type_ptr = type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveUniformType*)type_ptr, (StringBuilder)name);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        void GetActiveUniform(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.ES20.ActiveUniformType type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (OpenTK.Graphics.ES20.ActiveUniformType* type_ptr = &type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveUniformType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        unsafe void GetActiveUniform(Int32 program, Int32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.ES20.ActiveUniformType* type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length, (Int32*)size, (OpenTK.Graphics.ES20.ActiveUniformType*)type, (StringBuilder)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        void GetActiveUniform(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] Int32[] size, [OutAttribute] OpenTK.Graphics.ES20.ActiveUniformType[] type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (OpenTK.Graphics.ES20.ActiveUniformType* type_ptr = type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveUniformType*)type_ptr, (StringBuilder)name);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        void GetActiveUniform(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.ES20.ActiveUniformType type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (OpenTK.Graphics.ES20.ActiveUniformType* type_ptr = &type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.ES20.ActiveUniformType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetActiveUniform")]
        public static 
        unsafe void GetActiveUniform(UInt32 program, UInt32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.ES20.ActiveUniformType* type, [OutAttribute] StringBuilder name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufsize, (Int32*)length, (Int32*)size, (OpenTK.Graphics.ES20.ActiveUniformType*)type, (StringBuilder)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        void GetAttachedShaders(Int32 program, Int32 maxcount, [OutAttribute] Int32[] count, [OutAttribute] Int32[] shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (Int32* shaders_ptr = shaders)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count_ptr, (UInt32*)shaders_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        void GetAttachedShaders(Int32 program, Int32 maxcount, [OutAttribute] out Int32 count, [OutAttribute] out Int32 shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (Int32* shaders_ptr = &shaders)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count_ptr, (UInt32*)shaders_ptr);
                    count = *count_ptr;
                    shaders = *shaders_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        unsafe void GetAttachedShaders(Int32 program, Int32 maxcount, [OutAttribute] Int32* count, [OutAttribute] Int32* shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count, (UInt32*)shaders);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        void GetAttachedShaders(UInt32 program, Int32 maxcount, [OutAttribute] Int32[] count, [OutAttribute] UInt32[] shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (UInt32* shaders_ptr = shaders)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count_ptr, (UInt32*)shaders_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        void GetAttachedShaders(UInt32 program, Int32 maxcount, [OutAttribute] out Int32 count, [OutAttribute] out UInt32 shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count_ptr, (UInt32*)shaders_ptr);
                    count = *count_ptr;
                    shaders = *shaders_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        public static 
        unsafe void GetAttachedShaders(UInt32 program, Int32 maxcount, [OutAttribute] Int32* count, [OutAttribute] UInt32* shaders)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxcount, (Int32*)count, (UInt32*)shaders);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttribLocation")]
        public static 
        int GetAttribLocation(Int32 program, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glGetAttribLocation((UInt32)program, (String)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetAttribLocation")]
        public static 
        int GetAttribLocation(UInt32 program, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glGetAttribLocation((UInt32)program, (String)name);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBooleanv")]
        public static 
        void GetBoolean(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] bool[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (bool* @params_ptr = @params)
                {
                    Delegates.glGetBooleanv((OpenTK.Graphics.ES20.GetPName)pname, (bool*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBooleanv")]
        public static 
        void GetBoolean(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] out bool @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (bool* @params_ptr = &@params)
                {
                    Delegates.glGetBooleanv((OpenTK.Graphics.ES20.GetPName)pname, (bool*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBooleanv")]
        public static 
        unsafe void GetBoolean(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] bool* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetBooleanv((OpenTK.Graphics.ES20.GetPName)pname, (bool*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferParameteriv")]
        public static 
        void GetBufferParameter(OpenTK.Graphics.ES20.BufferTarget target, OpenTK.Graphics.ES20.BufferParameterName pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES20.BufferTarget)target, (OpenTK.Graphics.ES20.BufferParameterName)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferParameteriv")]
        public static 
        void GetBufferParameter(OpenTK.Graphics.ES20.BufferTarget target, OpenTK.Graphics.ES20.BufferParameterName pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES20.BufferTarget)target, (OpenTK.Graphics.ES20.BufferParameterName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferParameteriv")]
        public static 
        unsafe void GetBufferParameter(OpenTK.Graphics.ES20.BufferTarget target, OpenTK.Graphics.ES20.BufferParameterName pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES20.BufferTarget)target, (OpenTK.Graphics.ES20.BufferParameterName)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM([OutAttribute] Int32[] num, Int32 size, [OutAttribute] Int32[] driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = num)
                fixed (Int32* driverControls_ptr = driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM([OutAttribute] Int32[] num, Int32 size, [OutAttribute] UInt32[] driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = num)
                fixed (UInt32* driverControls_ptr = driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM([OutAttribute] out Int32 num, Int32 size, [OutAttribute] out Int32 driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = &num)
                fixed (Int32* driverControls_ptr = &driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                    num = *num_ptr;
                    driverControls = *driverControls_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM([OutAttribute] out Int32 num, Int32 size, [OutAttribute] out UInt32 driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = &num)
                fixed (UInt32* driverControls_ptr = &driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                    num = *num_ptr;
                    driverControls = *driverControls_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        unsafe void GetDriverControlsQCOM([OutAttribute] Int32* num, Int32 size, [OutAttribute] Int32* driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlsQCOM((Int32*)num, (Int32)size, (UInt32*)driverControls);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        unsafe void GetDriverControlsQCOM([OutAttribute] Int32* num, Int32 size, [OutAttribute] UInt32* driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlsQCOM((Int32*)num, (Int32)size, (UInt32*)driverControls);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)driverControlString);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        unsafe void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length, (StringBuilder)driverControlString);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)driverControlString);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        unsafe void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length, (StringBuilder)driverControlString);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return error information
        /// </summary>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetError")]
        public static 
        OpenTK.Graphics.ES20.ErrorCode GetError()
        {
            return Delegates.glGetError();
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFloatv")]
        public static 
        void GetFloat(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFloatv((OpenTK.Graphics.ES20.GetPName)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFloatv")]
        public static 
        void GetFloat(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFloatv((OpenTK.Graphics.ES20.GetPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFloatv")]
        public static 
        unsafe void GetFloat(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetFloatv((OpenTK.Graphics.ES20.GetPName)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFramebufferAttachmentParameteriv")]
        public static 
        void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.FramebufferParameterName pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFramebufferAttachmentParameteriv((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.FramebufferParameterName)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFramebufferAttachmentParameteriv")]
        public static 
        void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.FramebufferParameterName pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFramebufferAttachmentParameteriv((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.FramebufferParameterName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFramebufferAttachmentParameteriv")]
        public static 
        unsafe void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES20.FramebufferTarget target, OpenTK.Graphics.ES20.FramebufferSlot attachment, OpenTK.Graphics.ES20.FramebufferParameterName pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetFramebufferAttachmentParameteriv((OpenTK.Graphics.ES20.FramebufferTarget)target, (OpenTK.Graphics.ES20.FramebufferSlot)attachment, (OpenTK.Graphics.ES20.FramebufferParameterName)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES20.GetPName)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES20.GetPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetIntegerv")]
        public static 
        unsafe void GetInteger(OpenTK.Graphics.ES20.GetPName pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetIntegerv((OpenTK.Graphics.ES20.GetPName)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        void GetProgramInfoLog(Int32 program, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        void GetProgramInfoLog(Int32 program, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        unsafe void GetProgramInfoLog(Int32 program, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length, (StringBuilder)infolog);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        void GetProgramInfoLog(UInt32 program, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        void GetProgramInfoLog(UInt32 program, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramInfoLog")]
        public static 
        unsafe void GetProgramInfoLog(UInt32 program, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufsize, (Int32*)length, (StringBuilder)infolog);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        void GetProgram(Int32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        void GetProgram(Int32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        unsafe void GetProgram(Int32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        void GetProgram(UInt32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        void GetProgram(UInt32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramiv")]
        public static 
        unsafe void GetProgram(UInt32 program, OpenTK.Graphics.ES20.ProgramParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetProgramiv((UInt32)program, (OpenTK.Graphics.ES20.ProgramParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetRenderbufferParameteriv")]
        public static 
        void GetRenderbufferParameter(OpenTK.Graphics.ES20.RenderbufferTarget target, OpenTK.Graphics.ES20.RenderbufferParameterName pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetRenderbufferParameteriv((OpenTK.Graphics.ES20.RenderbufferTarget)target, (OpenTK.Graphics.ES20.RenderbufferParameterName)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetRenderbufferParameteriv")]
        public static 
        void GetRenderbufferParameter(OpenTK.Graphics.ES20.RenderbufferTarget target, OpenTK.Graphics.ES20.RenderbufferParameterName pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetRenderbufferParameteriv((OpenTK.Graphics.ES20.RenderbufferTarget)target, (OpenTK.Graphics.ES20.RenderbufferParameterName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetRenderbufferParameteriv")]
        public static 
        unsafe void GetRenderbufferParameter(OpenTK.Graphics.ES20.RenderbufferTarget target, OpenTK.Graphics.ES20.RenderbufferParameterName pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetRenderbufferParameteriv((OpenTK.Graphics.ES20.RenderbufferTarget)target, (OpenTK.Graphics.ES20.RenderbufferParameterName)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        void GetShaderInfoLog(Int32 shader, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        void GetShaderInfoLog(Int32 shader, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        unsafe void GetShaderInfoLog(Int32 shader, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length, (StringBuilder)infolog);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        void GetShaderInfoLog(UInt32 shader, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        void GetShaderInfoLog(UInt32 shader, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)infolog);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the information log for a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderInfoLog")]
        public static 
        unsafe void GetShaderInfoLog(UInt32 shader, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infolog)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufsize, (Int32*)length, (StringBuilder)infolog);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        void GetShader(Int32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        void GetShader(Int32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        unsafe void GetShader(Int32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        void GetShader(UInt32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        void GetShader(UInt32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns a parameter from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE, GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderiv")]
        public static 
        unsafe void GetShader(UInt32 shader, OpenTK.Graphics.ES20.ShaderParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderiv((UInt32)shader, (OpenTK.Graphics.ES20.ShaderParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderPrecisionFormat")]
        public static 
        void GetShaderPrecisionFormat(OpenTK.Graphics.ES20.ShaderType shadertype, OpenTK.Graphics.ES20.ShaderPrecision precisiontype, [OutAttribute] Int32[] range, [OutAttribute] Int32[] precision)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* range_ptr = range)
                fixed (Int32* precision_ptr = precision)
                {
                    Delegates.glGetShaderPrecisionFormat((OpenTK.Graphics.ES20.ShaderType)shadertype, (OpenTK.Graphics.ES20.ShaderPrecision)precisiontype, (Int32*)range_ptr, (Int32*)precision_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderPrecisionFormat")]
        public static 
        void GetShaderPrecisionFormat(OpenTK.Graphics.ES20.ShaderType shadertype, OpenTK.Graphics.ES20.ShaderPrecision precisiontype, [OutAttribute] out Int32 range, [OutAttribute] out Int32 precision)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* range_ptr = &range)
                fixed (Int32* precision_ptr = &precision)
                {
                    Delegates.glGetShaderPrecisionFormat((OpenTK.Graphics.ES20.ShaderType)shadertype, (OpenTK.Graphics.ES20.ShaderPrecision)precisiontype, (Int32*)range_ptr, (Int32*)precision_ptr);
                    range = *range_ptr;
                    precision = *precision_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderPrecisionFormat")]
        public static 
        unsafe void GetShaderPrecisionFormat(OpenTK.Graphics.ES20.ShaderType shadertype, OpenTK.Graphics.ES20.ShaderPrecision precisiontype, [OutAttribute] Int32* range, [OutAttribute] Int32* precision)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderPrecisionFormat((OpenTK.Graphics.ES20.ShaderType)shadertype, (OpenTK.Graphics.ES20.ShaderPrecision)precisiontype, (Int32*)range, (Int32*)precision);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        void GetShaderSource(Int32 shader, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)source);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        void GetShaderSource(Int32 shader, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)source);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        unsafe void GetShaderSource(Int32 shader, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length, (StringBuilder)source);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        void GetShaderSource(UInt32 shader, Int32 bufsize, [OutAttribute] Int32[] length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)source);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        void GetShaderSource(UInt32 shader, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)source);
                    length = *length_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetShaderSource")]
        public static 
        unsafe void GetShaderSource(UInt32 shader, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder source)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetShaderSource((UInt32)shader, (Int32)bufsize, (Int32*)length, (StringBuilder)source);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a string describing the current GL connection
        /// </summary>
        /// <param name="name">
        /// <para>
        /// Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, GL_SHADING_LANGUAGE_VERSION, or GL_EXTENSIONS.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetString")]
        public static 
        unsafe System.String GetString(OpenTK.Graphics.ES20.StringName name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe { return new string((sbyte*)Delegates.glGetString((OpenTK.Graphics.ES20.StringName)name)); }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameterfv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterfv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameterfv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterfv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameterfv")]
        public static 
        unsafe void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexParameterfv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameteriv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameteriv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameteriv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameteriv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetTexParameteriv")]
        public static 
        unsafe void GetTexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.GetTextureParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexParameteriv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.GetTextureParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        void GetUniform(Int32 program, Int32 location, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        void GetUniform(Int32 program, Int32 location, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        unsafe void GetUniform(Int32 program, Int32 location, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        void GetUniform(UInt32 program, Int32 location, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        void GetUniform(UInt32 program, Int32 location, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformfv")]
        public static 
        unsafe void GetUniform(UInt32 program, Int32 location, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        void GetUniform(Int32 program, Int32 location, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        void GetUniform(Int32 program, Int32 location, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        unsafe void GetUniform(Int32 program, Int32 location, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        void GetUniform(UInt32 program, Int32 location, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        void GetUniform(UInt32 program, Int32 location, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformiv")]
        public static 
        unsafe void GetUniform(UInt32 program, Int32 location, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the location of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the uniform variable whose location is to be queried.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformLocation")]
        public static 
        int GetUniformLocation(Int32 program, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glGetUniformLocation((UInt32)program, (String)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Returns the location of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the uniform variable whose location is to be queried.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetUniformLocation")]
        public static 
        int GetUniformLocation(UInt32 program, String name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glGetUniformLocation((UInt32)program, (String)name);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        unsafe void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] out Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribfv")]
        public static 
        unsafe void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribfv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        unsafe void GetVertexAttrib(Int32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] out Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribiv")]
        public static 
        unsafe void GetVertexAttrib(UInt32 index, OpenTK.Graphics.ES20.VertexAttribParameter pname, [OutAttribute] Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribiv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribParameter)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer(Int32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [OutAttribute] IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[,,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] ref T2 pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T2)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer(UInt32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [OutAttribute] IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] T2[,,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified generic vertex attribute pointer
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be returned.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the generic vertex attribute parameter to be returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Returns the pointer value.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetVertexAttribPointerv")]
        public static 
        void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.ES20.VertexAttribPointerParameter pname, [InAttribute, OutAttribute] ref T2 pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (OpenTK.Graphics.ES20.VertexAttribPointerParameter)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T2)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify implementation-specific hints
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a symbolic constant indicating the behavior to be controlled. GL_FOG_HINT, GL_GENERATE_MIPMAP_HINT, GL_LINE_SMOOTH_HINT, GL_PERSPECTIVE_CORRECTION_HINT, GL_POINT_SMOOTH_HINT, GL_POLYGON_SMOOTH_HINT, GL_TEXTURE_COMPRESSION_HINT, and GL_FRAGMENT_SHADER_DERIVATIVE_HINT are accepted.
        /// </para>
        /// </param>
        /// <param name="mode">
        /// <para>
        /// Specifies a symbolic constant indicating the desired behavior. GL_FASTEST, GL_NICEST, and GL_DONT_CARE are accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glHint")]
        public static 
        void Hint(OpenTK.Graphics.ES20.HintTarget target, OpenTK.Graphics.ES20.HintMode mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glHint((OpenTK.Graphics.ES20.HintTarget)target, (OpenTK.Graphics.ES20.HintMode)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsBuffer")]
        public static 
        bool IsBuffer(Int32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsBuffer((UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsBuffer")]
        public static 
        bool IsBuffer(UInt32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsBuffer((UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Test whether a capability is enabled
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsEnabled")]
        public static 
        bool IsEnabled(OpenTK.Graphics.ES20.EnableCap cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsEnabled((OpenTK.Graphics.ES20.EnableCap)cap);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsFramebuffer")]
        public static 
        bool IsFramebuffer(Int32 framebuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsFramebuffer((UInt32)framebuffer);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsFramebuffer")]
        public static 
        bool IsFramebuffer(UInt32 framebuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsFramebuffer((UInt32)framebuffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determines if a name corresponds to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies a potential program object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsProgram")]
        public static 
        bool IsProgram(Int32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determines if a name corresponds to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies a potential program object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsProgram")]
        public static 
        bool IsProgram(UInt32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsRenderbuffer")]
        public static 
        bool IsRenderbuffer(Int32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsRenderbuffer((UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsRenderbuffer")]
        public static 
        bool IsRenderbuffer(UInt32 renderbuffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsRenderbuffer((UInt32)renderbuffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determines if a name corresponds to a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies a potential shader object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsShader")]
        public static 
        bool IsShader(Int32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determines if a name corresponds to a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies a potential shader object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsShader")]
        public static 
        bool IsShader(UInt32 shader)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsShader((UInt32)shader);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a texture
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies a value that may be the name of a texture.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsTexture")]
        public static 
        bool IsTexture(Int32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsTexture((UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a texture
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies a value that may be the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsTexture")]
        public static 
        bool IsTexture(UInt32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsTexture((UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the width of rasterized lines
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specifies the width of rasterized lines. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glLineWidth")]
        public static 
        void LineWidth(Single width)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLineWidth((Single)width);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Links a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be linked.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glLinkProgram")]
        public static 
        void LinkProgram(Int32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLinkProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Links a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be linked.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glLinkProgram")]
        public static 
        void LinkProgram(UInt32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLinkProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set pixel storage modes
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the parameter to be set. Six values affect the packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST, GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS, GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH, GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES, and GL_UNPACK_ALIGNMENT.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname is set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glPixelStorei")]
        public static 
        void PixelStore(OpenTK.Graphics.ES20.PixelStoreParameter pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPixelStorei((OpenTK.Graphics.ES20.PixelStoreParameter)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the scale and units used to calculate depth values
        /// </summary>
        /// <param name="factor">
        /// <para>
        /// Specifies a scale factor that is used to create a variable depth offset for each polygon. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="units">
        /// <para>
        /// Is multiplied by an implementation-specific value to create a constant depth offset. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glPolygonOffset")]
        public static 
        void PolygonOffset(Single factor, Single units)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPolygonOffset((Single)factor, (Single)units);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T6[] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T6[,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T6[,,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] ref T6 pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T6)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glReleaseShaderCompiler")]
        public static 
        void ReleaseShaderCompiler()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glReleaseShaderCompiler();
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glRenderbufferStorage")]
        public static 
        void RenderbufferStorage(OpenTK.Graphics.ES20.RenderbufferTarget target, OpenTK.Graphics.ES20.RenderbufferInternalFormat internalformat, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glRenderbufferStorage((OpenTK.Graphics.ES20.RenderbufferTarget)target, (OpenTK.Graphics.ES20.RenderbufferInternalFormat)internalformat, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify multisample coverage parameters
        /// </summary>
        /// <param name="value">
        /// <para>
        /// Specify a single floating-point sample coverage value. The value is clamped to the range [0 ,1]. The initial value is 1.0.
        /// </para>
        /// </param>
        /// <param name="invert">
        /// <para>
        /// Specify a single boolean value representing if the coverage masks should be inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSampleCoverage")]
        public static 
        void SampleCoverage(Single value, bool invert)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glSampleCoverage((Single)value, (bool)invert);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define the scissor box
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the scissor box. Initially (0, 0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the scissor box. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glScissor")]
        public static 
        void Scissor(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScissor((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary(Int32 n, Int32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = shaders)
                {
                    Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, Int32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, Int32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, Int32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, Int32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                        binary = (T3)binary_ptr.Target;
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary(Int32 n, ref Int32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = &shaders)
                {
                    Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref Int32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref Int32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref Int32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref Int32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                        binary = (T3)binary_ptr.Target;
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary(Int32 n, Int32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, Int32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, Int32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, Int32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, Int32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                binary = (T3)binary_ptr.Target;
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary(Int32 n, UInt32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = shaders)
                {
                    Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, UInt32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, UInt32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, UInt32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, UInt32[] shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                        binary = (T3)binary_ptr.Target;
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary(Int32 n, ref UInt32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref UInt32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref UInt32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref UInt32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        void ShaderBinary<T3>(Int32 n, ref UInt32 shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* shaders_ptr = &shaders)
                {
                    GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                    try
                    {
                        Delegates.glShaderBinary((Int32)n, (UInt32*)shaders_ptr, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                        binary = (T3)binary_ptr.Target;
                    }
                    finally
                    {
                        binary_ptr.Free();
                    }
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary(Int32 n, UInt32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, IntPtr binary, Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary, (Int32)length);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, UInt32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, UInt32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, UInt32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] T3[,,] binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderBinary")]
        public static 
        unsafe void ShaderBinary<T3>(Int32 n, UInt32* shaders, OpenTK.Graphics.ES20.ShaderBinaryFormat binaryformat, [InAttribute, OutAttribute] ref T3 binary, Int32 length)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
            try
            {
                Delegates.glShaderBinary((Int32)n, (UInt32*)shaders, (OpenTK.Graphics.ES20.ShaderBinaryFormat)binaryformat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                binary = (T3)binary_ptr.Target;
            }
            finally
            {
                binary_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        void ShaderSource(Int32 shader, Int32 count, String[] @string, Int32[] length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        void ShaderSource(Int32 shader, Int32 count, String[] @string, ref Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        unsafe void ShaderSource(Int32 shader, Int32 count, String[] @string, Int32* length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        void ShaderSource(UInt32 shader, Int32 count, String[] @string, Int32[] length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        void ShaderSource(UInt32 shader, Int32 count, String[] @string, ref Int32 length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glShaderSource")]
        public static 
        unsafe void ShaderSource(UInt32 shader, Int32 count, String[] @string, Int32* length)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShaderSource((UInt32)shader, (Int32)count, (String[])@string, (Int32*)length);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES20.StencilFunction func, Int32 @ref, Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES20.StencilFunction)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES20.StencilFunction func, Int32 @ref, UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES20.StencilFunction)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and/or back function and reference value for stencil testing
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether front and/or back stencil state is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilFuncSeparate")]
        public static 
        void StencilFuncSeparate(OpenTK.Graphics.ES20.CullFaceMode face, OpenTK.Graphics.ES20.StencilFunction func, Int32 @ref, Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFuncSeparate((OpenTK.Graphics.ES20.CullFaceMode)face, (OpenTK.Graphics.ES20.StencilFunction)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and/or back function and reference value for stencil testing
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether front and/or back stencil state is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilFuncSeparate")]
        public static 
        void StencilFuncSeparate(OpenTK.Graphics.ES20.CullFaceMode face, OpenTK.Graphics.ES20.StencilFunction func, Int32 @ref, UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFuncSeparate((OpenTK.Graphics.ES20.CullFaceMode)face, (OpenTK.Graphics.ES20.StencilFunction)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and/or back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether the front and/or back stencil writemask is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilMaskSeparate")]
        public static 
        void StencilMaskSeparate(OpenTK.Graphics.ES20.CullFaceMode face, Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMaskSeparate((OpenTK.Graphics.ES20.CullFaceMode)face, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and/or back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether the front and/or back stencil writemask is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilMaskSeparate")]
        public static 
        void StencilMaskSeparate(OpenTK.Graphics.ES20.CullFaceMode face, UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMaskSeparate((OpenTK.Graphics.ES20.CullFaceMode)face, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back stencil test actions
        /// </summary>
        /// <param name="sfail">
        /// <para>
        /// Specifies the action to take when the stencil test fails. Eight symbolic constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR, GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dpfail">
        /// <para>
        /// Specifies the stencil action when the stencil test passes, but the depth test fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dppass">
        /// <para>
        /// Specifies the stencil action when both the stencil test and the depth test pass, or when the stencil test passes and either there is no depth buffer or depth testing is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilOp")]
        public static 
        void StencilOp(OpenTK.Graphics.ES20.StencilOp fail, OpenTK.Graphics.ES20.StencilOp zfail, OpenTK.Graphics.ES20.StencilOp zpass)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilOp((OpenTK.Graphics.ES20.StencilOp)fail, (OpenTK.Graphics.ES20.StencilOp)zfail, (OpenTK.Graphics.ES20.StencilOp)zpass);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and/or back stencil test actions
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether front and/or back stencil state is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="sfail">
        /// <para>
        /// Specifies the action to take when the stencil test fails. Eight symbolic constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR, GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dpfail">
        /// <para>
        /// Specifies the stencil action when the stencil test passes, but the depth test fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dppass">
        /// <para>
        /// Specifies the stencil action when both the stencil test and the depth test pass, or when the stencil test passes and either there is no depth buffer or depth testing is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glStencilOpSeparate")]
        public static 
        void StencilOpSeparate(OpenTK.Graphics.ES20.CullFaceMode face, OpenTK.Graphics.ES20.StencilOp fail, OpenTK.Graphics.ES20.StencilOp zfail, OpenTK.Graphics.ES20.StencilOp zpass)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilOpSeparate((OpenTK.Graphics.ES20.CullFaceMode)face, (OpenTK.Graphics.ES20.StencilOp)fail, (OpenTK.Graphics.ES20.StencilOp)zfail, (OpenTK.Graphics.ES20.StencilOp)zpass);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, OpenTK.Graphics.ES20.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (OpenTK.Graphics.ES20.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameterf")]
        public static 
        void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterf((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameterfv")]
        public static 
        void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexParameterfv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameterfv")]
        public static 
        unsafe void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterfv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameteri")]
        public static 
        void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameteri((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameteriv")]
        public static 
        void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexParameteriv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexParameteriv")]
        public static 
        unsafe void TexParameter(OpenTK.Graphics.ES20.TextureTarget target, OpenTK.Graphics.ES20.TextureParameterName pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameteriv((OpenTK.Graphics.ES20.TextureTarget)target, (OpenTK.Graphics.ES20.TextureParameterName)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES20.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES20.PixelFormat format, OpenTK.Graphics.ES20.PixelType type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES20.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES20.PixelFormat)format, (OpenTK.Graphics.ES20.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1f")]
        public static 
        void Uniform1(Int32 location, Single x)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform1f((Int32)location, (Single)x);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1fv")]
        public static 
        void Uniform1(Int32 location, Int32 count, Single[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1fv")]
        public static 
        void Uniform1(Int32 location, Int32 count, ref Single v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1fv")]
        public static 
        unsafe void Uniform1(Int32 location, Int32 count, Single* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1i")]
        public static 
        void Uniform1(Int32 location, Int32 x)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform1i((Int32)location, (Int32)x);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1iv")]
        public static 
        void Uniform1(Int32 location, Int32 count, Int32[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1iv")]
        public static 
        void Uniform1(Int32 location, Int32 count, ref Int32 v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform1iv")]
        public static 
        unsafe void Uniform1(Int32 location, Int32 count, Int32* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2f")]
        public static 
        void Uniform2(Int32 location, Single x, Single y)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform2f((Int32)location, (Single)x, (Single)y);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2fv")]
        public static 
        void Uniform2(Int32 location, Int32 count, Single[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2fv")]
        public static 
        void Uniform2(Int32 location, Int32 count, ref Single v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2fv")]
        public static 
        unsafe void Uniform2(Int32 location, Int32 count, Single* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2i")]
        public static 
        void Uniform2(Int32 location, Int32 x, Int32 y)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform2i((Int32)location, (Int32)x, (Int32)y);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2iv")]
        public static 
        void Uniform2(Int32 location, Int32 count, Int32[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glUniform2iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform2iv")]
        public static 
        unsafe void Uniform2(Int32 location, Int32 count, Int32* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform2iv((Int32)location, (Int32)count, (Int32*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3f")]
        public static 
        void Uniform3(Int32 location, Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform3f((Int32)location, (Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3fv")]
        public static 
        void Uniform3(Int32 location, Int32 count, Single[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3fv")]
        public static 
        void Uniform3(Int32 location, Int32 count, ref Single v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3fv")]
        public static 
        unsafe void Uniform3(Int32 location, Int32 count, Single* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3i")]
        public static 
        void Uniform3(Int32 location, Int32 x, Int32 y, Int32 z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform3i((Int32)location, (Int32)x, (Int32)y, (Int32)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3iv")]
        public static 
        void Uniform3(Int32 location, Int32 count, Int32[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3iv")]
        public static 
        void Uniform3(Int32 location, Int32 count, ref Int32 v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform3iv")]
        public static 
        unsafe void Uniform3(Int32 location, Int32 count, Int32* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4f")]
        public static 
        void Uniform4(Int32 location, Single x, Single y, Single z, Single w)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform4f((Int32)location, (Single)x, (Single)y, (Single)z, (Single)w);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4fv")]
        public static 
        void Uniform4(Int32 location, Int32 count, Single[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4fv")]
        public static 
        void Uniform4(Int32 location, Int32 count, ref Single v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4fv")]
        public static 
        unsafe void Uniform4(Int32 location, Int32 count, Single* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)v);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4i")]
        public static 
        void Uniform4(Int32 location, Int32 x, Int32 y, Int32 z, Int32 w)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform4i((Int32)location, (Int32)x, (Int32)y, (Int32)z, (Int32)w);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4iv")]
        public static 
        void Uniform4(Int32 location, Int32 count, Int32[] v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4iv")]
        public static 
        void Uniform4(Int32 location, Int32 count, ref Int32 v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)v_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniform4iv")]
        public static 
        unsafe void Uniform4(Int32 location, Int32 count, Int32* v)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)v);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix2fv")]
        public static 
        void UniformMatrix2(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix2fv")]
        public static 
        void UniformMatrix2(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix2fv")]
        public static 
        unsafe void UniformMatrix2(Int32 location, Int32 count, bool transpose, Single* value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix3fv")]
        public static 
        void UniformMatrix3(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix3fv")]
        public static 
        void UniformMatrix3(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix3fv")]
        public static 
        unsafe void UniformMatrix3(Int32 location, Int32 count, bool transpose, Single* value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix4fv")]
        public static 
        void UniformMatrix4(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix4fv")]
        public static 
        void UniformMatrix4(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUniformMatrix4fv")]
        public static 
        unsafe void UniformMatrix4(Int32 location, Int32 count, bool transpose, Single* value)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Installs a program object as part of current rendering state
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object whose executables are to be used as part of current rendering state.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUseProgram")]
        public static 
        void UseProgram(Int32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUseProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Installs a program object as part of current rendering state
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object whose executables are to be used as part of current rendering state.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUseProgram")]
        public static 
        void UseProgram(UInt32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glUseProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Validates a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be validated.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glValidateProgram")]
        public static 
        void ValidateProgram(Int32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glValidateProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Validates a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be validated.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glValidateProgram")]
        public static 
        void ValidateProgram(UInt32 program)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glValidateProgram((UInt32)program);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1f")]
        public static 
        void VertexAttrib1(Int32 indx, Single x)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib1f((UInt32)indx, (Single)x);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1f")]
        public static 
        void VertexAttrib1(UInt32 indx, Single x)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib1f((UInt32)indx, (Single)x);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1fv")]
        public static 
        void VertexAttrib1(Int32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib1fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1fv")]
        public static 
        unsafe void VertexAttrib1(Int32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib1fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1fv")]
        public static 
        void VertexAttrib1(UInt32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib1fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib1fv")]
        public static 
        unsafe void VertexAttrib1(UInt32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib1fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2f")]
        public static 
        void VertexAttrib2(Int32 indx, Single x, Single y)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib2f((UInt32)indx, (Single)x, (Single)y);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2f")]
        public static 
        void VertexAttrib2(UInt32 indx, Single x, Single y)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib2f((UInt32)indx, (Single)x, (Single)y);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        void VertexAttrib2(Int32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        void VertexAttrib2(Int32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        unsafe void VertexAttrib2(Int32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        void VertexAttrib2(UInt32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        void VertexAttrib2(UInt32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib2fv")]
        public static 
        unsafe void VertexAttrib2(UInt32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib2fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3f")]
        public static 
        void VertexAttrib3(Int32 indx, Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib3f((UInt32)indx, (Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3f")]
        public static 
        void VertexAttrib3(UInt32 indx, Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib3f((UInt32)indx, (Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        void VertexAttrib3(Int32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        void VertexAttrib3(Int32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        unsafe void VertexAttrib3(Int32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        void VertexAttrib3(UInt32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        void VertexAttrib3(UInt32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib3fv")]
        public static 
        unsafe void VertexAttrib3(UInt32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib3fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4f")]
        public static 
        void VertexAttrib4(Int32 indx, Single x, Single y, Single z, Single w)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib4f((UInt32)indx, (Single)x, (Single)y, (Single)z, (Single)w);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4f")]
        public static 
        void VertexAttrib4(UInt32 indx, Single x, Single y, Single z, Single w)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib4f((UInt32)indx, (Single)x, (Single)y, (Single)z, (Single)w);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        void VertexAttrib4(Int32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        void VertexAttrib4(Int32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        unsafe void VertexAttrib4(Int32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        void VertexAttrib4(UInt32 indx, Single[] values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        void VertexAttrib4(UInt32 indx, ref Single values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttrib4fv")]
        public static 
        unsafe void VertexAttrib4(UInt32 indx, Single* values)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttrib4fv((UInt32)indx, (Single*)values);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer(Int32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, IntPtr ptr)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(Int32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(Int32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(Int32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,,] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(Int32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] ref T5 ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
                ptr = (T5)ptr_ptr.Target;
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer(UInt32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, IntPtr ptr)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(UInt32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(UInt32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(UInt32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,,] ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glVertexAttribPointer")]
        public static 
        void VertexAttribPointer<T5>(UInt32 indx, Int32 size, OpenTK.Graphics.ES20.VertexAttribPointerType type, bool normalized, Int32 stride, [InAttribute, OutAttribute] ref T5 ptr)
            where T5 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexAttribPointer((UInt32)indx, (Int32)size, (OpenTK.Graphics.ES20.VertexAttribPointerType)type, (bool)normalized, (Int32)stride, (IntPtr)ptr_ptr.AddrOfPinnedObject());
                ptr = (T5)ptr_ptr.Target;
            }
            finally
            {
                ptr_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the viewport
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the viewport rectangle, in pixels. The initial value is (0,0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the viewport. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glViewport")]
        public static 
        void Viewport(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glViewport((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        public static partial class NV
        {
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, ref Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            unsafe void DeleteFences(Int32 n, Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, ref UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glDeleteFencesNV")]
            public static 
            unsafe void DeleteFences(Int32 n, UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFinishFenceNV")]
            public static 
            void FinishFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFinishFenceNV")]
            public static 
            void FinishFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, [OutAttribute] Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, [OutAttribute] out Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                        fences = *fences_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            unsafe void GenFences(Int32 n, [OutAttribute] Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, [OutAttribute] UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, [OutAttribute] out UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                        fences = *fences_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGenFencesNV")]
            public static 
            unsafe void GenFences(Int32 n, [OutAttribute] UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(Int32 fence, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(Int32 fence, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            unsafe void GetFence(Int32 fence, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(UInt32 fence, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(UInt32 fence, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetFenceivNV")]
            public static 
            unsafe void GetFence(UInt32 fence, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFenceivNV((UInt32)fence, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsFenceNV")]
            public static 
            bool IsFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glIsFenceNV")]
            public static 
            bool IsFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSetFenceNV")]
            public static 
            void SetFence(Int32 fence, OpenTK.Graphics.ES20.All condition)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceNV((UInt32)fence, (OpenTK.Graphics.ES20.All)condition);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glSetFenceNV")]
            public static 
            void SetFence(UInt32 fence, OpenTK.Graphics.ES20.All condition)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceNV((UInt32)fence, (OpenTK.Graphics.ES20.All)condition);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTestFenceNV")]
            public static 
            bool TestFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTestFenceNV")]
            public static 
            bool TestFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Oes
        {
            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage3DOES")]
            public static 
            void CompressedTexImage3D(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage3DOES")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage3DOES")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage3DOES")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexImage3DOES")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T8)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage3DOES")]
            public static 
            void CompressedTexSubImage3D(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage3DOES")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, Int32 imageSize, [InAttribute, OutAttribute] T10[] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage3DOES")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, Int32 imageSize, [InAttribute, OutAttribute] T10[,] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage3DOES")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, Int32 imageSize, [InAttribute, OutAttribute] T10[,,] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCompressedTexSubImage3DOES")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, Int32 imageSize, [InAttribute, OutAttribute] ref T10 data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T10)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Copy a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glCopyTexSubImage3DOES")]
            public static 
            void CopyTexSubImage3D(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 x, Int32 y, Int32 width, Int32 height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCopyTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEGLImageTargetRenderbufferStorageOES")]
            public static 
            void EGLImageTargetRenderbufferStorage(OpenTK.Graphics.ES20.All target, IntPtr image)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEGLImageTargetRenderbufferStorageOES((OpenTK.Graphics.ES20.All)target, (IntPtr)image);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glEGLImageTargetTexture2DOES")]
            public static 
            void EGLImageTargetTexture2D(OpenTK.Graphics.ES20.All target, IntPtr image)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEGLImageTargetTexture2DOES((OpenTK.Graphics.ES20.All)target, (IntPtr)image);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferTexture3DOES")]
            public static 
            void FramebufferTexture3D(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All attachment, OpenTK.Graphics.ES20.All textarget, Int32 texture, Int32 level, Int32 zoffset)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTexture3DOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)attachment, (OpenTK.Graphics.ES20.All)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glFramebufferTexture3DOES")]
            public static 
            void FramebufferTexture3D(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All attachment, OpenTK.Graphics.ES20.All textarget, UInt32 texture, Int32 level, Int32 zoffset)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTexture3DOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)attachment, (OpenTK.Graphics.ES20.All)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All pname, [OutAttribute] IntPtr @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)pname, (IntPtr)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T2[] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T2[,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] T2[,,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All pname, [InAttribute, OutAttribute] ref T2 @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                    @params = (T2)@params_ptr.Target;
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary(Int32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            binary = (T4)binary_ptr.Target;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary);
                        length = *length_ptr;
                        binaryFormat = *binaryFormat_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                            binary = (T4)binary_ptr.Target;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                    binary = (T4)binary_ptr.Target;
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary(UInt32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32[] length, [OutAttribute] OpenTK.Graphics.ES20.All[] binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            binary = (T4)binary_ptr.Target;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary);
                        length = *length_ptr;
                        binaryFormat = *binaryFormat_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (OpenTK.Graphics.ES20.All* binaryFormat_ptr = &binaryFormat)
                    {
                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                        try
                        {
                            Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (OpenTK.Graphics.ES20.All*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
                            length = *length_ptr;
                            binaryFormat = *binaryFormat_ptr;
                            binary = (T4)binary_ptr.Target;
                        }
                        finally
                        {
                            binary_ptr.Free();
                        }
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [OutAttribute] IntPtr binary)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] T4[,,] binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glGetProgramBinaryOES")]
            public static 
            unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] OpenTK.Graphics.ES20.All* binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
                where T4 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramBinaryOES((UInt32)program, (Int32)bufSize, (Int32*)length, (OpenTK.Graphics.ES20.All*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
                    binary = (T4)binary_ptr.Target;
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Map a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object being mapped. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="access">
        /// <para>
        /// Specifies the access policy, indicating whether it will be possible to read from, write to, or both read from and write to the buffer object's mapped data store. The symbolic constant must be GL_READ_ONLY, GL_WRITE_ONLY, or GL_READ_WRITE.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glMapBufferOES")]
            public static 
            unsafe System.IntPtr MapBuffer(OpenTK.Graphics.ES20.All target, OpenTK.Graphics.ES20.All access)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glMapBufferOES((OpenTK.Graphics.ES20.All)target, (OpenTK.Graphics.ES20.All)access);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary(Int32 program, OpenTK.Graphics.ES20.All binaryFormat, IntPtr binary, Int32 length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary, (Int32)length);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(Int32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(Int32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[,] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(Int32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[,,] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(Int32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] ref T2 binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    binary = (T2)binary_ptr.Target;
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary(UInt32 program, OpenTK.Graphics.ES20.All binaryFormat, IntPtr binary, Int32 length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary, (Int32)length);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(UInt32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(UInt32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[,] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(UInt32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] T2[,,] binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glProgramBinaryOES")]
            public static 
            void ProgramBinary<T2>(UInt32 program, OpenTK.Graphics.ES20.All binaryFormat, [InAttribute, OutAttribute] ref T2 binary, Int32 length)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramBinaryOES((UInt32)program, (OpenTK.Graphics.ES20.All)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject(), (Int32)length);
                    binary = (T2)binary_ptr.Target;
                }
                finally
                {
                    binary_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level is the n sup th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup k + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage3DOES")]
            public static 
            void TexImage3D(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, IntPtr pixels)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level is the n sup th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup k + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage3DOES")]
            public static 
            void TexImage3D<T9>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T9[] pixels)
                where T9 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level is the n sup th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup k + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage3DOES")]
            public static 
            void TexImage3D<T9>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T9[,] pixels)
                where T9 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level is the n sup th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup k + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage3DOES")]
            public static 
            void TexImage3D<T9>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T9[,,] pixels)
                where T9 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level is the n sup th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup k + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexImage3DOES")]
            public static 
            void TexImage3D<T9>(OpenTK.Graphics.ES20.All target, Int32 level, OpenTK.Graphics.ES20.All internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] ref T9 pixels)
                where T9 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (OpenTK.Graphics.ES20.All)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                    pixels = (T9)pixels_ptr.Target;
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage3DOES")]
            public static 
            void TexSubImage3D(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, IntPtr pixels)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage3DOES")]
            public static 
            void TexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T10[] pixels)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage3DOES")]
            public static 
            void TexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T10[,] pixels)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage3DOES")]
            public static 
            void TexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] T10[,,] pixels)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glTexSubImage3DOES")]
            public static 
            void TexSubImage3D<T10>(OpenTK.Graphics.ES20.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.ES20.All format, OpenTK.Graphics.ES20.All type, [InAttribute, OutAttribute] ref T10 pixels)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3DOES((OpenTK.Graphics.ES20.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.ES20.All)format, (OpenTK.Graphics.ES20.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                    pixels = (T10)pixels_ptr.Target;
                }
                finally
                {
                    pixels_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "2.0", Version = "2.0", EntryPoint = "glUnmapBufferOES")]
            public static 
            bool UnmapBuffer(OpenTK.Graphics.ES20.All target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glUnmapBufferOES((OpenTK.Graphics.ES20.All)target);
                #if DEBUG
                }
                #endif
            }

        }

    }
}
