/*
  subgroups.hh, copyright (c) 2006 by Vincent Fourmond: 
  The class definitions for the subgroups (parentheses).
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

namespace SCalc {
  class Subgroup : public Expression {
  protected:
    Expression * sub;
  public:
    Subgroup(Session * s, Expression * su) : Expression(s) { sub = su;};
    virtual ~Subgroup() { delete sub;};
    
    virtual double evaluate(const double * d, const double *) { 
      return sub->evaluate(d);
    };
    virtual Expression * copy() {
      return new Subgroup(session(), sub->copy());
    };
    virtual Expression * derive(int id) {
      return new Subgroup(session(), sub->derive(id));
    };
    virtual Expression * simplify();
    virtual std::string pretty_print();

    // Pretty nasty to forget this one !!!
    virtual std::set<int> used_variables() { 
      return sub->used_variables();
    };
  };
};
