/* The following code was generated by JFlex 1.4.3 on 19/03/14 11:42 */

//CHECKSTYLE:OFF

package org.scilab.modules.scinotes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

import org.scilab.modules.commons.ScilabCommonsUtils;

@javax.annotation.Generated("JFlex")
@SuppressWarnings("fallthrough")


/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 19/03/14 11:42 from the specification file
 * <tt>scilab.jflex</tt>
 */
public final class ScilabLexer extends ScilabLexerConstants {

    /** This character denotes the end of file */
    public static final int YYEOF = -1;

    /** initial size of the lookahead buffer */
    private static final int ZZ_BUFFERSIZE = 16384;

    /** lexical states */
    public static final int BREAKSTRING = 12;
    public static final int COMMANDSWHITE = 10;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 4;
    public static final int FIELD = 6;
    public static final int COMMANDS = 8;
    public static final int QSTRING = 2;

    /**
     * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
     * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
     *                  at the beginning of a line
     * l is of the form l = 2*k, k a non negative integer
     */
    private static final int ZZ_LEXSTATE[] = {
        0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6, 6
    };

    /**
     * Translates characters to character classes
     */
    private static final String ZZ_CMAP_PACKED =
        "\11\0\1\110\1\1\1\0\1\120\1\113\22\0\1\72\1\116\1\7" +
        "\1\114\1\112\1\10\1\51\1\6\1\3\1\4\1\40\1\43\1\117" +
        "\1\44\1\37\1\5\12\115\1\111\1\124\1\47\1\45\1\50\1\114" +
        "\1\53\1\100\1\101\1\25\1\35\1\33\1\14\1\103\1\30\1\26" +
        "\1\102\1\107\1\76\1\32\1\73\1\31\1\34\1\106\1\36\1\24" +
        "\1\12\1\77\1\104\1\27\2\122\1\74\1\2\1\41\1\4\1\42" +
        "\1\121\1\0\1\23\1\65\1\55\1\57\1\15\1\13\1\105\1\60" +
        "\1\17\1\122\1\66\1\61\1\70\1\20\1\56\1\16\1\67\1\62" +
        "\1\22\1\11\1\54\1\75\1\63\1\71\1\64\1\21\1\2\1\52" +
        "\1\4\1\46\u0511\0\160\123\u0100\123\120\0\60\123\100\123\100\123\uf31d\0" +
        "\63\123\u02b0\123\160\0\220\123\u0100\0";

    /**
     * Translates characters to character classes
     */
    private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

    /**
     * Translates DFA states to action switch labels.
     */
    private static final int [] ZZ_ACTION = zzUnpackAction();

    private static final String ZZ_ACTION_PACKED_0 =
        "\1\0\1\1\3\0\1\1\1\0\1\2\1\3\1\4" +
        "\1\5\1\6\1\7\14\10\1\11\11\5\6\10\1\12" +
        "\1\13\2\14\1\15\1\2\1\1\1\16\1\17\1\1" +
        "\1\20\1\21\1\1\1\22\1\23\17\22\1\24\4\22" +
        "\1\25\2\22\1\26\1\27\1\26\1\30\1\31\1\32" +
        "\1\33\2\1\1\34\1\35\2\16\1\36\1\5\1\37" +
        "\1\0\2\40\1\10\1\40\12\10\1\41\4\10\1\5" +
        "\1\14\1\5\1\15\2\0\2\10\1\42\3\10\1\0" +
        "\1\37\2\0\1\37\1\15\3\0\27\22\1\0\13\22" +
        "\1\0\1\1\1\43\3\0\6\10\1\41\5\10\1\40" +
        "\1\10\1\15\7\10\2\15\1\44\2\0\30\22\1\0" +
        "\10\22\1\0\2\22\1\0\1\45\3\10\1\46\1\47" +
        "\11\10\21\22\1\50\4\22\1\0\10\22\2\0\1\22" +
        "\1\51\1\45\7\10\1\0\1\52\14\22\1\0\3\22" +
        "\1\0\10\22\1\0\2\51\1\10\1\46\2\10\1\22" +
        "\2\0\11\22\1\0\3\22\1\0\5\22\1\0\2\22" +
        "\1\51\1\10\1\53\3\0\2\22\1\0\3\22\4\0" +
        "\1\22\1\0\5\22\1\0\2\22\1\54\6\0\1\22" +
        "\2\0\1\22\5\0\1\22\1\55\2\0\1\22\4\0" +
        "\1\22\3\0\1\22\6\0\1\22\3\0\1\22\7\0" +
        "\1\22\1\55\1\0\1\22\4\0\1\22\3\0\1\22" +
        "\22\0\1\22\1\0\1\22\14\0\1\50\22\0\1\22" +
        "\34\0\1\22\30\0\1\55\22\0\3\55\11\0\2\55" +
        "\7\0\2\55\2\0\2\37\1\55";

    private static int [] zzUnpackAction() {
        int [] result = new int[598];
        int offset = 0;
        offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int [] result) {
        int i = 0;       /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }


    /**
     * Translates a state to a row index in the transition table
     */
    private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

    private static final String ZZ_ROWMAP_PACKED_0 =
        "\0\0\0\125\0\252\0\377\0\u0154\0\u01a9\0\u01fe\0\u0253" +
        "\0\u0253\0\u0253\0\u02a8\0\u02fd\0\u02fd\0\u0352\0\u03a7\0\u03fc" +
        "\0\u0451\0\u04a6\0\u04fb\0\u0550\0\u05a5\0\u05fa\0\u064f\0\u06a4" +
        "\0\u06f9\0\u074e\0\u07a3\0\u07f8\0\u084d\0\u08a2\0\u08f7\0\u094c" +
        "\0\u09a1\0\u09f6\0\u0a4b\0\u0aa0\0\u0af5\0\u0b4a\0\u0b9f\0\u0bf4" +
        "\0\u0c49\0\u0c9e\0\u0cf3\0\u07f8\0\u04a6\0\u0d48\0\u07f8\0\u0d9d" +
        "\0\u0253\0\u0df2\0\u0e47\0\u0253\0\u0253\0\u0e9c\0\u0ef1\0\u0253" +
        "\0\u0f46\0\u0f9b\0\u0ff0\0\u1045\0\u109a\0\u10ef\0\u1144\0\u1199" +
        "\0\u11ee\0\u1243\0\u1298\0\u12ed\0\u1342\0\u1397\0\u13ec\0\u0253" +
        "\0\u1441\0\u1496\0\u14eb\0\u1540\0\u0253\0\u1595\0\u15ea\0\u0253" +
        "\0\u163f\0\u163f\0\u0253\0\u0253\0\u1694\0\u1694\0\u16e9\0\u173e" +
        "\0\u0253\0\u0253\0\u1793\0\u17e8\0\u0253\0\u0253\0\u0253\0\u183d" +
        "\0\u04a6\0\u1892\0\u18e7\0\u193c\0\u1991\0\u19e6\0\u1a3b\0\u1a90" +
        "\0\u1ae5\0\u1b3a\0\u1b8f\0\u1be4\0\u1c39\0\u1c8e\0\u04a6\0\u1ce3" +
        "\0\u1d38\0\u1d8d\0\u1de2\0\u1e37\0\u1e8c\0\u1ee1\0\u1f36\0\u1f8b" +
        "\0\u1fe0\0\u2035\0\u208a\0\u04a6\0\u20df\0\u2134\0\u2189\0\u21de" +
        "\0\u2233\0\u07f8\0\u0cf3\0\u2288\0\u22dd\0\u0df2\0\u2332\0\u2387" +
        "\0\u23dc\0\u2431\0\u2486\0\u24db\0\u2530\0\u2585\0\u25da\0\u262f" +
        "\0\u2684\0\u26d9\0\u272e\0\u2783\0\u27d8\0\u282d\0\u2882\0\u28d7" +
        "\0\u292c\0\u2981\0\u29d6\0\u2a2b\0\u2a80\0\u2ad5\0\u2b2a\0\u2b7f" +
        "\0\u2bd4\0\u2c29\0\u2c7e\0\u2cd3\0\u2d28\0\u2d7d\0\u2dd2\0\u2e27" +
        "\0\u2e7c\0\u2ed1\0\u2f26\0\u1694\0\u2f7b\0\u17e8\0\u2fd0\0\u3025" +
        "\0\u307a\0\u30cf\0\u3124\0\u3179\0\u31ce\0\u3223\0\u3278\0\u32cd" +
        "\0\u3322\0\u3377\0\u33cc\0\u3421\0\u3476\0\u34cb\0\u3520\0\u3575" +
        "\0\u35ca\0\u361f\0\u3674\0\u36c9\0\u371e\0\u3773\0\u37c8\0\u381d" +
        "\0\u3872\0\u0253\0\u38c7\0\u391c\0\u3971\0\u39c6\0\u3a1b\0\u3a70" +
        "\0\u3ac5\0\u3b1a\0\u3b6f\0\u3bc4\0\u3c19\0\u3c6e\0\u3cc3\0\u3d18" +
        "\0\u3d6d\0\u3dc2\0\u3e17\0\u3e6c\0\u3ec1\0\u3f16\0\u3f6b\0\u3fc0" +
        "\0\u4015\0\u406a\0\u40bf\0\u4114\0\u4169\0\u41be\0\u4213\0\u4268" +
        "\0\u42bd\0\u4312\0\u4367\0\u43bc\0\u4411\0\u4466\0\u44bb\0\u4510" +
        "\0\u4565\0\u0253\0\u45ba\0\u460f\0\u4664\0\u46b9\0\u04a6\0\u470e" +
        "\0\u4763\0\u47b8\0\u480d\0\u4862\0\u48b7\0\u490c\0\u4961\0\u49b6" +
        "\0\u4a0b\0\u4a60\0\u4ab5\0\u4b0a\0\u4b5f\0\u4bb4\0\u4c09\0\u4c5e" +
        "\0\u4cb3\0\u4d08\0\u4d5d\0\u4db2\0\u4e07\0\u4e5c\0\u4eb1\0\u4f06" +
        "\0\u4f5b\0\u0ef1\0\u4fb0\0\u5005\0\u505a\0\u50af\0\u5104\0\u5159" +
        "\0\u51ae\0\u5203\0\u5258\0\u52ad\0\u5302\0\u5357\0\u53ac\0\u5401" +
        "\0\u5456\0\u54ab\0\u0ef1\0\u2fd0\0\u5500\0\u5555\0\u55aa\0\u55ff" +
        "\0\u5654\0\u56a9\0\u56fe\0\u5753\0\u57a8\0\u57fd\0\u5852\0\u58a7" +
        "\0\u58fc\0\u5951\0\u59a6\0\u59fb\0\u5a50\0\u5aa5\0\u5afa\0\u5b4f" +
        "\0\u5ba4\0\u5bf9\0\u5c4e\0\u5ca3\0\u5cf8\0\u5d4d\0\u5da2\0\u5df7" +
        "\0\u5e4c\0\u5ea1\0\u5ef6\0\u5f4b\0\u5fa0\0\u5ff5\0\u604a\0\u0253" +
        "\0\u4510\0\u609f\0\u04a6\0\u60f4\0\u6149\0\u619e\0\u61f3\0\u6248" +
        "\0\u629d\0\u62f2\0\u6347\0\u639c\0\u63f1\0\u6446\0\u649b\0\u64f0" +
        "\0\u6545\0\u659a\0\u65ef\0\u6644\0\u6699\0\u66ee\0\u6743\0\u6798" +
        "\0\u67ed\0\u6842\0\u6897\0\u68ec\0\u6941\0\u6996\0\u5456\0\u69eb" +
        "\0\u619e\0\u6a40\0\u6a95\0\u6aea\0\u6b3f\0\u6b94\0\u6be9\0\u6c3e" +
        "\0\u6c93\0\u6ce8\0\u6d3d\0\u6d92\0\u6de7\0\u6e3c\0\u6e91\0\u6ee6" +
        "\0\u6f3b\0\u6f90\0\u6fe5\0\u703a\0\u708f\0\u70e4\0\u7139\0\u718e" +
        "\0\u04a6\0\u71e3\0\u7238\0\u728d\0\u72e2\0\u7337\0\u738c\0\u73e1" +
        "\0\u7436\0\u748b\0\u74e0\0\u7535\0\u758a\0\u75df\0\u7634\0\u7689" +
        "\0\u76de\0\u0ef1\0\u7733\0\u7788\0\u77dd\0\u7832\0\u7887\0\u78dc" +
        "\0\u7931\0\u7986\0\u79db\0\u7a30\0\u7a85\0\u7ada\0\u7b2f\0\u7b84" +
        "\0\u7bd9\0\u7c2e\0\u7c83\0\u7cd8\0\u7d2d\0\u7d82\0\u7dd7\0\u7e2c" +
        "\0\u7e81\0\u7ed6\0\u7f2b\0\u7f80\0\u7fd5\0\u802a\0\u807f\0\u80d4" +
        "\0\u8129\0\u0253\0\u817e\0\u81d3\0\u8228\0\u827d\0\u82d2\0\u8327" +
        "\0\u837c\0\u83d1\0\u8426\0\u847b\0\u84d0\0\u8525\0\u857a\0\u85cf" +
        "\0\u8624\0\u8679\0\u86ce\0\u8723\0\u8778\0\u87cd\0\u8822\0\u8877" +
        "\0\u88cc\0\u8921\0\u8976\0\u89cb\0\u8a20\0\u8a75\0\u8aca\0\u8b1f" +
        "\0\u8b74\0\u8bc9\0\u8c1e\0\u8c73\0\u8cc8\0\u8d1d\0\u8d72\0\u8dc7" +
        "\0\u8e1c\0\u8e71\0\u8ec6\0\u8f1b\0\u8f70\0\u8fc5\0\u0253\0\u901a" +
        "\0\u906f\0\u90c4\0\u9119\0\u916e\0\u91c3\0\u9218\0\u926d\0\u92c2" +
        "\0\u9317\0\u936c\0\u93c1\0\u9416\0\u946b\0\u94c0\0\u9515\0\u956a" +
        "\0\u95bf\0\u9614\0\u9669\0\u96be\0\u9713\0\u9768\0\u97bd\0\u9812" +
        "\0\u9867\0\u98bc\0\u9911\0\u9966\0\u99bb\0\u9a10\0\u9a65\0\u9aba" +
        "\0\u9b0f\0\u9b64\0\u9bb9\0\u9c0e\0\u9c63\0\u9cb8\0\u9d0d\0\u9d62" +
        "\0\u9db7\0\u9e0c\0\u9e61\0\u9eb6\0\u9f0b\0\u9f60\0\u9fb5\0\ua00a" +
        "\0\ua05f\0\ua0b4\0\ua109\0\ua15e\0\ua1b3\0\ua208\0\ua25d\0\ua2b2" +
        "\0\ua307\0\ua35c\0\ua3b1\0\ua406\0\ua45b\0\ua4b0\0\ua505\0\ua55a" +
        "\0\ua5af\0\ua604\0\ua659\0\ua6ae\0\ua703\0\ua758\0\ua7ad\0\ua802" +
        "\0\ua857\0\ua8ac\0\ua901\0\ua956\0\ua9ab\0\uaa00\0\uaa55\0\uaaaa" +
        "\0\uaaff\0\uab54\0\uaba9\0\uabfe\0\uac53\0\uaca8\0\uacfd\0\uad52" +
        "\0\uada7\0\uadfc\0\uae51\0\uaea6\0\uaefb\0\uaf50\0\uafa5\0\uaffa" +
        "\0\ub04f\0\ub0a4\0\ub0f9\0\ub14e\0\ub1a3\0\ub1f8\0\ub24d\0\ub2a2" +
        "\0\ub2f7\0\ub34c\0\ub3a1\0\ub3f6\0\ub44b\0\ub4a0\0\ub4f5\0\ub54a" +
        "\0\ub59f\0\ub5f4\0\ub649\0\ua0b4\0\ub69e\0\ub6f3";

    private static int [] zzUnpackRowMap() {
        int [] result = new int[598];
        int offset = 0;
        offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int [] result) {
        int i = 0;  /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    /**
     * The transition table of the DFA
     */
    private static final int [] ZZ_TRANS = zzUnpackTrans();

    private static final String ZZ_TRANS_PACKED_0 =
        "\2\10\2\11\1\12\1\13\1\14\1\15\1\16\1\17" +
        "\1\20\1\21\1\22\1\23\1\24\1\25\2\22\1\26" +
        "\1\27\1\30\2\22\1\31\7\22\1\32\1\33\2\34" +
        "\1\35\1\36\1\37\1\40\1\41\1\40\1\42\1\43" +
        "\1\40\1\22\1\44\1\22\1\45\2\22\1\46\1\47" +
        "\1\22\1\50\1\22\1\51\2\22\1\52\15\22\1\53" +
        "\1\54\1\55\1\10\1\22\1\56\1\22\1\57\1\10" +
        "\2\22\2\10\1\60\1\61\4\60\2\62\27\60\1\63" +
        "\32\60\1\64\15\60\1\65\2\60\1\61\7\60\1\66" +
        "\1\60\1\67\1\70\7\67\1\71\1\72\1\73\6\67" +
        "\1\74\1\67\1\75\1\76\1\77\3\67\1\100\1\101" +
        "\1\102\1\103\11\67\1\104\7\67\1\105\1\106\7\67" +
        "\1\107\1\67\1\110\3\67\1\111\1\67\1\112\1\113" +
        "\2\67\1\114\3\67\1\115\1\67\1\116\10\67\1\117" +
        "\1\67\10\120\27\121\15\120\16\121\1\120\15\121\2\120" +
        "\1\122\1\120\1\121\1\120\1\121\2\120\2\121\3\120" +
        "\1\123\1\120\1\124\66\120\1\125\15\120\1\126\14\120" +
        "\5\127\1\130\64\127\1\131\15\127\1\132\6\127\1\120" +
        "\4\127\1\120\5\61\1\133\31\61\1\134\32\61\1\131" +
        "\15\61\1\132\14\61\132\0\1\135\31\0\1\136\5\0" +
        "\1\137\171\0\1\140\23\0\4\141\1\142\1\143\1\144" +
        "\1\145\2\141\14\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\26\22\15\0" +
        "\4\22\1\146\1\22\1\147\7\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\21\22\1\150" +
        "\4\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\1\151\1\22" +
        "\1\152\13\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\13\0\26\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\7\22" +
        "\1\153\16\22\15\0\5\22\1\154\7\22\1\155\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\12\22\1\156\13\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\2\22\1\157" +
        "\23\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\4\22\1\160\21\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\11\22\1\161\4\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\14\22\1\162\11\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\13\22\1\163" +
        "\12\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\7\0\1\164\1\136\30\0\1\165" +
        "\1\166\1\164\1\136\2\0\1\137\47\0\1\167\47\0" +
        "\1\136\4\0\1\137\124\0\1\137\64\0\1\137\31\0" +
        "\1\170\3\137\2\0\1\137\64\0\1\137\31\0\1\170" +
        "\3\137\2\0\1\137\2\0\1\137\121\0\1\136\1\0" +
        "\2\137\21\0\1\171\15\0\1\171\61\0\1\136\124\0" +
        "\1\136\2\0\1\136\125\0\1\137\125\0\1\137\63\0" +
        "\12\22\1\172\13\22\15\0\2\22\1\173\13\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\26\22\15\0\2\22\1\174\13\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\4\22\1\175" +
        "\21\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\4\22\1\176" +
        "\11\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\6\22\1\177\7\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\26\22\15\0\1\155\15\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\74\0\1\200\15\0\1\201" +
        "\5\0\1\202\100\0\1\201\15\0\1\203\25\0\4\204" +
        "\1\205\15\204\1\205\1\204\1\205\1\204\1\167\14\0" +
        "\3\204\1\205\12\204\1\0\15\204\2\0\1\204\1\0" +
        "\1\204\1\56\1\204\2\0\2\204\2\0\1\60\1\0" +
        "\4\60\2\206\27\60\1\0\32\60\1\0\15\60\1\0" +
        "\2\60\1\0\11\60\6\0\2\60\154\0\1\207\65\0" +
        "\1\66\1\0\4\66\2\210\27\66\1\0\53\66\1\0" +
        "\11\66\1\67\1\0\70\67\1\0\15\67\1\0\15\67" +
        "\1\0\54\67\1\211\13\67\1\0\15\67\1\0\15\67" +
        "\1\0\27\67\1\212\24\67\1\211\13\67\1\0\15\67" +
        "\1\0\15\67\1\0\7\67\1\213\5\67\1\214\52\67" +
        "\1\0\15\67\1\0\15\67\1\0\11\67\1\215\54\67" +
        "\1\216\1\67\1\0\15\67\1\0\15\67\1\0\13\67" +
        "\1\217\1\67\1\220\35\67\1\221\2\67\1\222\3\67" +
        "\1\223\5\67\1\0\15\67\1\0\15\67\1\0\13\67" +
        "\1\224\5\67\1\225\34\67\1\226\1\227\10\67\1\0" +
        "\15\67\1\0\15\67\1\0\16\67\1\230\51\67\1\0" +
        "\1\231\14\67\1\0\15\67\1\0\21\67\1\232\46\67" +
        "\1\0\15\67\1\0\15\67\1\0\70\67\1\0\1\233" +
        "\14\67\1\0\15\67\1\0\21\67\1\234\46\67\1\0" +
        "\15\67\1\0\15\67\1\0\15\67\1\235\6\67\1\236" +
        "\43\67\1\0\15\67\1\0\15\67\1\0\7\67\27\237" +
        "\4\67\1\237\7\67\16\237\1\240\15\237\1\240\4\67" +
        "\1\237\3\67\2\237\3\67\1\0\21\67\1\241\46\67" +
        "\1\0\15\67\1\0\15\67\1\0\7\67\1\242\60\67" +
        "\1\0\15\67\1\0\15\67\1\0\21\67\1\243\46\67" +
        "\1\0\15\67\1\0\15\67\1\0\13\67\1\244\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\16\67\1\245\36\67" +
        "\1\246\1\67\1\247\10\67\1\0\15\67\1\0\15\67" +
        "\1\0\60\67\1\250\7\67\1\0\15\67\1\0\15\67" +
        "\1\0\15\67\1\251\41\67\1\252\10\67\1\0\15\67" +
        "\1\0\15\67\1\0\70\67\1\0\15\67\1\0\1\67" +
        "\1\253\12\67\1\117\1\0\123\117\11\0\26\121\15\0" +
        "\16\121\1\0\15\121\2\0\1\121\1\0\3\121\2\0" +
        "\2\121\5\0\1\124\66\0\1\254\15\0\1\254\14\0" +
        "\5\127\1\0\64\127\1\0\15\127\1\0\6\127\1\0" +
        "\4\127\1\0\5\255\1\135\64\255\1\0\32\255\5\0" +
        "\1\135\156\0\1\256\65\0\6\140\2\257\31\140\1\260" +
        "\50\140\1\261\12\140\11\0\5\22\1\262\20\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\6\22\1\141\17\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\7\22\1\263\16\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\12\22\1\264" +
        "\13\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\4\22\1\265\21\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\10\22\1\157\5\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\23\22\1\266\2\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\7\22\1\267" +
        "\16\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\6\22\1\157" +
        "\7\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\3\22\1\270\12\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\11\22\1\271\14\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\6\22\1\272" +
        "\17\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\1\273\15\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\26\22\15\0\5\22\1\274\10\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\26\22" +
        "\15\0\2\22\1\275\13\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\15\22\1\276\10\22" +
        "\15\0\16\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\13\0\14\22\1\277\11\22\15\0\16\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\41\0\1\136\124\0\1\165\124\0\2\136\101\0\1\300" +
        "\15\0\1\300\1\0\1\300\21\0\1\300\35\0\1\167" +
        "\14\0\1\137\32\0\5\137\127\0\2\137\21\0\1\171" +
        "\15\0\1\171\25\0\1\301\10\22\1\302\14\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\7\22\1\303\16\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\1\304\10\22\1\305\14\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\6\22" +
        "\1\306\17\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\4\22\1\307\21\22" +
        "\15\0\16\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\74\0\1\200\15\0\1\201\106\0\1\201" +
        "\15\0\1\201\25\0\26\204\15\0\16\204\1\0\15\204" +
        "\2\0\1\204\1\0\3\204\2\0\2\204\13\0\26\204" +
        "\4\0\2\310\7\0\16\204\1\0\15\204\2\0\1\204" +
        "\1\0\1\204\1\311\1\204\2\0\2\204\3\0\1\312" +
        "\3\0\1\313\31\0\1\207\32\0\1\314\15\0\1\314" +
        "\22\0\2\66\115\0\1\67\1\0\55\67\1\315\12\67" +
        "\1\0\15\67\1\0\15\67\1\0\33\67\1\316\34\67" +
        "\1\0\15\67\1\0\15\67\1\0\14\67\1\317\53\67" +
        "\1\0\15\67\1\0\15\67\1\0\57\67\1\320\10\67" +
        "\1\0\15\67\1\0\15\67\1\0\7\67\1\321\60\67" +
        "\1\0\15\67\1\0\15\67\1\0\63\67\1\322\4\67" +
        "\1\0\15\67\1\0\15\67\1\0\60\67\1\323\7\67" +
        "\1\0\15\67\1\0\15\67\1\0\66\67\1\324\1\67" +
        "\1\0\15\67\1\0\15\67\1\0\15\67\1\325\52\67" +
        "\1\0\15\67\1\0\15\67\1\0\13\67\1\326\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\57\67\1\327\10\67" +
        "\1\0\15\67\1\0\15\67\1\0\55\67\1\330\12\67" +
        "\1\0\15\67\1\0\15\67\1\0\57\67\1\331\10\67" +
        "\1\0\15\67\1\0\15\67\1\0\21\67\1\332\46\67" +
        "\1\0\15\67\1\0\15\67\1\0\13\67\1\333\5\67" +
        "\1\334\46\67\1\0\15\67\1\0\15\67\1\0\60\67" +
        "\1\335\7\67\1\0\15\67\1\0\15\67\1\0\34\67" +
        "\1\336\33\67\1\0\15\67\1\0\15\67\1\0\16\67" +
        "\1\337\51\67\1\0\15\67\1\0\15\67\1\0\32\67" +
        "\1\340\35\67\1\0\15\67\1\0\15\67\1\0\52\67" +
        "\1\341\15\67\1\0\15\67\1\0\15\67\1\0\70\67" +
        "\1\0\12\67\1\342\2\67\1\0\15\67\1\0\70\67" +
        "\1\0\10\67\1\343\4\67\1\0\15\67\1\0\7\67" +
        "\27\237\4\67\1\237\6\67\1\344\16\237\1\0\15\237" +
        "\1\0\4\67\1\237\3\67\2\237\2\67\11\0\27\345" +
        "\4\0\1\345\7\0\16\345\1\240\15\345\1\240\4\0" +
        "\1\345\3\0\2\345\2\0\1\67\1\0\70\67\1\0" +
        "\2\67\1\317\12\67\1\0\15\67\1\0\7\67\1\213" +
        "\60\67\1\0\15\67\1\0\15\67\1\0\15\67\1\346" +
        "\52\67\1\0\15\67\1\0\15\67\1\0\54\67\1\347" +
        "\13\67\1\0\15\67\1\0\15\67\1\0\7\67\1\350" +
        "\60\67\1\0\15\67\1\0\15\67\1\0\13\67\1\351" +
        "\54\67\1\0\15\67\1\0\15\67\1\0\13\67\1\352" +
        "\54\67\1\0\15\67\1\0\15\67\1\0\52\67\1\353" +
        "\15\67\1\0\15\67\1\0\15\67\1\0\16\67\1\354" +
        "\51\67\1\0\15\67\1\0\15\67\1\0\21\67\1\355" +
        "\46\67\1\0\15\67\1\0\14\67\1\253\1\356\37\253" +
        "\1\357\30\253\1\356\15\253\1\356\1\253\1\360\12\253" +
        "\5\255\1\0\64\255\1\0\32\255\6\0\2\140\115\0" +
        "\6\140\2\257\31\140\1\260\50\140\1\361\12\140\6\0" +
        "\2\362\126\0\11\22\1\141\14\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\2\22\1\141\23\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\7\22\1\141" +
        "\16\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\7\22\1\174\16\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\24\22\1\363\1\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\26\22\15\0\1\22\1\364\14\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\2\22\1\365" +
        "\23\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\4\22\1\366\21\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\1\367\25\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\11\22" +
        "\1\370\14\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\4\22\1\371\21\22" +
        "\15\0\16\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\13\0\26\22\15\0\6\22\1\272\7\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\17\22\1\372\6\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\15\22" +
        "\1\141\10\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\45\0\2\310\50\0\1\310" +
        "\20\0\26\22\15\0\1\22\1\373\14\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\4\22" +
        "\1\174\21\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\1\374\25\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\1\375\15\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\26\22" +
        "\15\0\1\376\15\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\5\22\1\377" +
        "\10\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\12\22\1\u0100\13\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\117\0" +
        "\1\310\20\0\26\204\15\0\16\204\1\0\15\204\2\0" +
        "\1\204\1\0\1\204\1\311\1\204\2\0\2\204\7\0" +
        "\1\312\120\0\1\312\3\0\1\313\64\0\1\314\15\0" +
        "\1\314\14\0\1\67\1\0\54\67\1\u0101\13\67\1\0" +
        "\15\67\1\0\15\67\1\0\27\67\1\u0101\40\67\1\0" +
        "\15\67\1\0\15\67\1\0\20\67\1\u0102\47\67\1\0" +
        "\15\67\1\0\1\u0103\14\67\1\0\13\67\1\u0102\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\14\67\1\u0102\53\67" +
        "\1\0\15\67\1\0\15\67\1\0\70\67\1\0\15\67" +
        "\1\0\1\u0104\14\67\1\0\70\67\1\0\12\67\1\u0105" +
        "\2\67\1\0\15\67\1\0\54\67\1\u0106\13\67\1\0" +
        "\15\67\1\0\15\67\1\0\57\67\1\u0107\10\67\1\0" +
        "\15\67\1\0\15\67\1\0\57\67\1\u0108\10\67\1\0" +
        "\15\67\1\0\15\67\1\0\70\67\1\0\2\67\1\u0109" +
        "\12\67\1\0\15\67\1\0\60\67\1\u010a\7\67\1\0" +
        "\15\67\1\0\15\67\1\0\15\67\1\u010b\52\67\1\0" +
        "\15\67\1\0\15\67\1\0\60\67\1\u010c\7\67\1\0" +
        "\15\67\1\0\15\67\1\0\66\67\1\u010d\1\67\1\0" +
        "\15\67\1\0\15\67\1\0\52\67\1\u010e\15\67\1\0" +
        "\15\67\1\0\15\67\1\0\15\67\1\u010f\52\67\1\0" +
        "\15\67\1\0\15\67\1\0\24\67\1\u0110\43\67\1\0" +
        "\15\67\1\0\15\67\1\0\52\67\1\u0111\15\67\1\0" +
        "\15\67\1\0\15\67\1\0\23\67\1\u0112\44\67\1\0" +
        "\15\67\1\0\15\67\1\0\57\67\1\u0113\10\67\1\0" +
        "\15\67\1\0\15\67\1\0\15\67\1\u0114\52\67\1\0" +
        "\15\67\1\0\15\67\1\0\24\67\1\u0115\43\67\1\0" +
        "\15\67\1\0\15\67\1\0\7\67\26\u0116\5\67\1\u0116" +
        "\7\67\16\u0116\1\0\15\u0116\1\0\4\67\1\u0116\4\67" +
        "\1\u0116\2\67\11\0\27\345\4\0\1\345\6\0\1\u0117" +
        "\16\345\1\0\15\345\5\0\1\345\3\0\2\345\2\0" +
        "\1\67\1\0\57\67\1\u0118\10\67\1\0\15\67\1\0" +
        "\15\67\1\0\16\67\1\u0119\51\67\1\0\15\67\1\0" +
        "\15\67\1\0\54\67\1\u011a\13\67\1\0\15\67\1\0" +
        "\15\67\1\0\57\67\1\u011b\10\67\1\0\15\67\1\0" +
        "\15\67\1\0\67\67\1\u011c\1\0\15\67\1\0\15\67" +
        "\1\0\16\67\1\u011d\51\67\1\0\15\67\1\0\15\67" +
        "\1\0\53\67\1\u011e\14\67\1\0\15\67\1\0\15\67" +
        "\1\0\55\67\1\u011f\12\67\1\0\15\67\1\0\14\67" +
        "\41\356\1\u0120\50\356\1\u0121\12\356\1\253\1\356\37\253" +
        "\1\357\30\253\1\356\15\253\1\356\1\253\1\u0122\12\253" +
        "\1\67\1\0\70\67\1\0\15\67\1\0\1\67\1\u0123" +
        "\12\67\6\140\2\u0124\31\140\1\260\50\140\1\261\12\140" +
        "\11\0\15\22\1\u0125\10\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\1\u0126" +
        "\25\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\26\22\15\0\1\151\15\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\6\22\1\u0127\17\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\4\22" +
        "\1\367\21\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\26\22\15\0\1\22" +
        "\1\u0128\14\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\13\0\20\22\1\u0129\5\22\15\0\16\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\26\22\15\0\4\22\1\174\11\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\6\22" +
        "\1\u012a\17\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\26\22\15\0\6\22" +
        "\1\u012b\7\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\13\0\26\22\15\0\14\22\1\370\1\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\4\22\1\157\21\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\26\22" +
        "\15\0\12\22\1\367\3\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\2\0\1\67\1\0\70\67" +
        "\1\u012c\15\67\1\u012c\1\u012d\14\67\1\0\70\67\1\0" +
        "\15\67\1\0\1\u0103\14\67\1\0\3\67\1\u012e\64\67" +
        "\1\0\15\67\1\0\15\67\1\0\3\67\1\u0103\64\67" +
        "\1\0\15\67\1\0\15\67\1\0\13\67\1\u012f\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\16\67\1\u0130\51\67" +
        "\1\0\15\67\1\0\15\67\1\0\21\67\1\u0131\46\67" +
        "\1\0\15\67\1\0\15\67\1\0\55\67\1\u0132\12\67" +
        "\1\0\15\67\1\0\15\67\1\0\13\67\1\u0133\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\15\67\1\u0134\52\67" +
        "\1\0\15\67\1\0\15\67\1\0\67\67\1\u0135\1\0" +
        "\15\67\1\0\15\67\1\0\57\67\1\u0136\10\67\1\0" +
        "\15\67\1\0\15\67\1\0\13\67\1\u0137\54\67\1\0" +
        "\15\67\1\0\15\67\1\0\55\67\1\u0138\12\67\1\0" +
        "\15\67\1\0\15\67\1\0\21\67\1\u0112\46\67\1\0" +
        "\15\67\1\0\15\67\1\0\70\67\1\0\5\67\1\u0112" +
        "\7\67\1\0\15\67\1\0\13\67\1\u0139\54\67\1\0" +
        "\15\67\1\0\15\67\1\0\70\67\1\u013a\15\67\1\0" +
        "\15\67\1\0\7\67\1\u013b\60\67\1\0\15\67\1\0" +
        "\15\67\1\0\10\67\1\u013c\57\67\1\0\15\67\1\0" +
        "\15\67\1\0\7\67\26\u0116\1\u013d\4\67\1\u0116\7\67" +
        "\16\u0116\1\0\15\u0116\1\0\4\67\1\u0116\4\67\1\u0116" +
        "\2\67\11\0\26\u013e\5\0\1\u013e\7\0\16\u013e\1\0" +
        "\15\u013e\5\0\1\u013e\4\0\1\u013e\2\0\1\67\1\0" +
        "\7\67\1\u013f\60\67\1\0\15\67\1\0\15\67\1\0" +
        "\21\67\1\u0140\46\67\1\0\15\67\1\0\15\67\1\0" +
        "\15\67\1\u0141\52\67\1\0\15\67\1\0\15\67\1\0" +
        "\15\67\1\u0142\52\67\1\0\15\67\1\0\15\67\1\0" +
        "\21\67\1\u0143\46\67\1\0\15\67\1\0\15\67\1\0" +
        "\54\67\1\u0144\13\67\1\0\15\67\1\0\15\67\1\0" +
        "\13\67\1\u0145\54\67\1\0\15\67\1\0\15\67\1\0" +
        "\15\67\1\u0146\52\67\1\0\15\67\1\0\14\67\41\356" +
        "\1\u0120\50\356\1\u0147\12\356\112\0\1\u0148\12\0\1\253" +
        "\1\356\37\253\1\357\30\253\1\356\15\253\1\356\1\253" +
        "\1\u0149\12\253\11\0\25\22\1\141\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\6\22\1\u014a\17\22\15\0\16\22\1\0\15\22\2\0" +
        "\1\22\1\0\3\22\2\0\2\22\13\0\2\22\1\u014b" +
        "\23\22\15\0\16\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\1\157\25\22\15\0\16\22" +
        "\1\0\15\22\2\0\1\22\1\0\3\22\2\0\2\22" +
        "\13\0\21\22\1\u014c\4\22\15\0\16\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\13\0\7\22" +
        "\1\u014d\16\22\15\0\16\22\1\0\15\22\2\0\1\22" +
        "\1\0\3\22\2\0\2\22\13\0\7\22\1\367\16\22" +
        "\15\0\16\22\1\0\15\22\2\0\1\22\1\0\3\22" +
        "\2\0\2\22\74\0\1\u012c\15\0\1\u012c\1\u012d\13\0" +
        "\1\u012d\1\0\123\u012d\1\67\1\0\3\67\1\u014e\64\67" +
        "\1\0\15\67\1\0\15\67\1\0\70\67\1\u014f\15\67" +
        "\1\0\15\67\1\0\70\67\1\u0150\15\67\1\0\15\67" +
        "\1\0\63\67\1\u0151\4\67\1\0\15\67\1\0\15\67" +
        "\1\0\54\67\1\u0152\13\67\1\0\15\67\1\0\15\67" +
        "\1\0\20\67\1\u0153\47\67\1\0\15\67\1\0\15\67" +
        "\1\0\53\67\1\u0154\14\67\1\0\15\67\1\0\15\67" +
        "\1\0\7\67\1\u0155\60\67\1\0\15\67\1\0\15\67" +
        "\1\0\54\67\1\u0156\13\67\1\0\15\67\1\0\15\67" +
        "\1\0\16\67\1\u0157\51\67\1\0\15\67\1\0\15\67" +
        "\1\0\13\67\1\u0158\54\67\1\0\15\67\1\0\15\67" +
        "\1\0\57\67\1\u0159\10\67\1\0\15\67\1\0\14\67" +
        "\101\0\1\u015a\23\0\1\67\1\0\13\67\1\u015b\54\67" +
        "\1\0\15\67\1\0\15\67\1\0\31\67\1\u015c\36\67" +
        "\1\0\15\67\1\0\15\67\1\0\7\67\26\u015d\5\67" +
        "\1\u0116\7\67\16\u015d\1\0\15\u015d\1\0\4\67\1\u0116" +
        "\4\67\1\u015d\2\67\11\0\26\u013e\1\u015e\4\0\1\u013e" +
        "\7\0\16\u013e\1\0\15\u013e\5\0\1\u013e\4\0\1\u013e" +
        "\2\0\1\67\1\0\54\67\1\u015f\13\67\1\0\15\67" +
        "\1\0\15\67\1\0\60\67\1\u0160\7\67\1\0\15\67" +
        "\1\0\15\67\1\0\16\67\1\u0161\51\67\1\0\15\67" +
        "\1\0\15\67\1\0\16\67\1\u0162\51\67\1\0\15\67" +
        "\1\0\15\67\1\0\16\67\1\u0163\51\67\1\0\15\67" +
        "\1\0\15\67\1\0\70\67\1\u0164\15\67\1\0\15\67" +
        "\1\0\16\67\1\u0165\51\67\1\0\15\67\1\0\15\67" +
        "\1\0\20\67\1\u0166\47\67\1\0\15\67\1\0\14\67" +
        "\41\356\1\u0120\50\356\1\u0167\12\356\11\0\26\22\15\0" +
        "\2\22\1\u0168\13\22\1\0\15\22\2\0\1\22\1\0" +
        "\3\22\2\0\2\22\13\0\22\22\1\141\3\22\15\0" +
        "\16\22\1\0\15\22\2\0\1\22\1\0\3\22\2\0" +
        "\2\22\13\0\26\22\15\0\1\370\15\22\1\0\15\22" +
        "\2\0\1\22\1\0\3\22\2\0\2\22\2\0\1\u0169" +
        "\1\0\4\u0169\2\67\62\u0169\1\0\15\u0169\1\0\2\u0169" +
        "\1\67\4\u0169\1\67\4\u0169\24\0\1\u016a\132\0\1\u016b" +
        "\72\0\1\67\1\0\70\67\1\u016c\15\67\1\0\15\67" +
        "\1\0\16\67\1\u016d\51\67\1\0\15\67\1\0\15\67" +
        "\1\0\7\67\1\u016e\60\67\1\0\15\67\1\0\15\67" +
        "\1\0\70\67\1\u016f\15\67\1\0\15\67\1\0\13\67" +
        "\1\u0170\54\67\1\0\15\67\1\0\15\67\1\0\7\67" +
        "\1\u0171\60\67\1\0\15\67\1\0\15\67\1\0\7\67" +
        "\1\u0172\60\67\1\0\15\67\1\0\15\67\1\0\70\67" +
        "\1\u0173\15\67\1\0\15\67\1\0\70\67\1\u0174\15\67" +
        "\1\0\14\67\17\0\1\u0175\6\0\1\u0176\76\0\1\67" +
        "\1\0\54\67\1\u0112\13\67\1\0\15\67\1\0\15\67" +
        "\1\0\27\67\1\u0112\40\67\1\0\15\67\1\0\15\67" +
        "\1\0\7\67\26\u0177\1\u013d\4\67\1\u0116\7\67\16\u0177" +
        "\1\0\15\u0177\1\0\4\67\1\u0116\4\67\1\u0177\2\67" +
        "\11\0\26\u0178\5\0\1\u013e\7\0\16\u0178\1\0\15\u0178" +
        "\5\0\1\u013e\4\0\1\u0178\2\0\1\67\1\0\70\67" +
        "\1\0\15\67\1\0\1\u0179\14\67\1\0\55\67\1\u017a" +
        "\12\67\1\0\15\67\1\0\15\67\1\0\13\67\1\u017b" +
        "\54\67\1\0\15\67\1\0\15\67\1\0\13\67\1\u017c" +
        "\54\67\1\0\15\67\1\0\15\67\1\0\55\67\1\u017d" +
        "\12\67\1\0\15\67\1\0\14\67\102\0\1\u017e\22\0" +
        "\1\67\1\0\7\67\1\u017f\60\67\1\0\15\67\1\0" +
        "\15\67\1\0\57\67\1\u0180\10\67\1\0\15\67\1\0" +
        "\14\67\11\0\7\22\1\u0181\16\22\15\0\16\22\1\0" +
        "\15\22\2\0\1\22\1\0\3\22\2\0\2\22\13\0" +
        "\1\u0182\1\u0183\135\0\1\u0184\54\0\1\u0185\57\0\1\u0186" +
        "\71\0\1\67\1\0\70\67\1\u0187\15\67\1\0\15\67" +
        "\1\0\60\67\1\u0188\7\67\1\0\15\67\1\0\14\67" +
        "\35\0\1\u0189\67\0\1\67\1\0\70\67\1\u018a\15\67" +
        "\1\0\15\67\1\0\7\67\1\u018b\60\67\1\0\15\67" +
        "\1\0\15\67\1\0\70\67\1\u018c\15\67\1\0\14\67" +
        "\103\0\1\u018d\123\0\1\u018e\127\0\1\u018f\122\0\1\u0190" +
        "\21\0\1\67\1\0\7\67\26\u0191\1\u013d\4\67\1\u0116" +
        "\3\67\1\u0192\3\67\16\u0191\1\u0193\15\u0191\1\u0193\4\67" +
        "\1\u0116\4\67\1\u0191\2\67\11\0\26\u0194\1\u015e\4\0" +
        "\1\u013e\7\0\16\u0194\1\0\15\u0194\5\0\1\u013e\4\0" +
        "\1\u0194\2\0\1\67\1\0\7\67\27\u0195\4\67\1\u0195" +
        "\7\67\16\u0195\1\u0196\15\u0195\1\u0196\4\67\1\u0195\3\67" +
        "\2\u0195\3\67\1\0\70\67\1\u0197\15\67\1\0\15\67" +
        "\1\0\70\67\1\u0198\15\67\1\0\15\67\1\0\70\67" +
        "\1\u0199\15\67\1\0\15\67\1\0\60\67\1\u019a\7\67" +
        "\1\0\15\67\1\0\14\67\31\0\1\u019b\24\0\1\u019c" +
        "\46\0\1\67\1\0\70\67\1\u019d\15\67\1\0\15\67" +
        "\1\0\21\67\1\u019e\46\67\1\0\15\67\1\0\14\67" +
        "\15\0\1\u019f\142\0\1\u01a0\153\0\1\u01a1\100\0\1\u01a2" +
        "\106\0\1\u01a3\131\0\1\u01a4\77\0\1\67\1\0\13\67" +
        "\1\u01a5\54\67\1\0\15\67\1\0\14\67\15\0\1\u01a6" +
        "\15\0\1\u01a7\126\0\1\u01a8\67\0\1\67\1\0\13\67" +
        "\1\u01a9\54\67\1\0\15\67\1\0\14\67\35\0\1\u01aa" +
        "\120\0\1\u01ab\24\0\1\u01ac\122\0\1\u01ad\22\0\1\u01ae" +
        "\45\0\1\u01af\177\0\1\u01b0\31\0\1\67\1\0\7\67" +
        "\26\u01b1\1\u013d\4\67\1\u0116\3\67\1\u0192\3\67\16\u01b1" +
        "\1\u0193\15\u01b1\1\u0193\4\67\1\u0116\4\67\1\u01b1\2\67" +
        "\50\0\1\u01b2\21\0\1\u0193\15\0\1\u0193\25\0\26\u01b3" +
        "\1\u015e\4\0\1\u013e\3\0\1\u01b2\3\0\16\u01b3\1\u0193" +
        "\15\u01b3\1\u0193\4\0\1\u013e\4\0\1\u01b3\2\0\1\67" +
        "\1\0\7\67\27\u0195\4\67\1\u0195\6\67\1\u01b4\16\u0195" +
        "\1\0\15\u0195\1\0\4\67\1\u0195\3\67\2\u0195\2\67" +
        "\11\0\27\u01b5\4\0\1\u01b5\7\0\16\u01b5\1\u0196\15\u01b5" +
        "\1\u0196\4\0\1\u01b5\3\0\2\u01b5\32\0\1\u01b6\127\0" +
        "\1\u01b7\116\0\1\u01b8\77\0\1\67\1\0\13\67\1\u01b9" +
        "\54\67\1\0\15\67\1\0\14\67\14\0\1\u01ba\123\0" +
        "\1\u01bb\136\0\1\u01bc\77\0\1\67\1\0\70\67\1\0" +
        "\2\67\1\u01bd\12\67\1\0\14\67\15\0\1\u01be\142\0" +
        "\1\u01bf\146\0\1\u01c0\74\0\1\u01c1\110\0\1\u01c2\171\0" +
        "\1\u01c3\46\0\1\67\1\0\70\67\1\u01c4\15\67\1\0" +
        "\14\67\61\0\1\u01c5\141\0\1\u01c6\43\0\1\u01c7\15\0" +
        "\1\u01c8\71\0\1\67\1\0\70\67\1\u01c9\15\67\1\0" +
        "\14\67\23\0\1\u01ca\54\0\1\u01cb\56\0\1\u01cc\162\0" +
        "\1\u01cd\115\0\1\u01ce\141\0\1\u01cf\45\0\1\u019f\133\0" +
        "\1\u01a0\76\0\1\67\1\0\7\67\26\u01d0\1\u013d\4\67" +
        "\1\u0116\3\67\1\u0192\3\67\16\u01d0\1\u0193\15\u01d0\1\u0193" +
        "\4\67\1\u0116\4\67\1\u01d0\2\67\11\0\26\u01d1\1\u015e" +
        "\4\0\1\u013e\3\0\1\u01b2\3\0\16\u01d1\1\u0193\15\u01d1" +
        "\1\u0193\4\0\1\u013e\4\0\1\u01d1\2\0\1\67\1\0" +
        "\7\67\26\u01d2\5\67\1\u01d2\7\67\16\u01d2\1\0\15\u01d2" +
        "\1\0\4\67\1\u01d2\4\67\1\u01d2\2\67\11\0\27\u01b5" +
        "\4\0\1\u01b5\6\0\1\u01d3\16\u01b5\1\0\15\u01b5\5\0" +
        "\1\u01b5\3\0\2\u01b5\60\0\1\u01d4\127\0\1\u01d5\14\0" +
        "\1\u01d6\51\0\1\u01d7\54\0\1\u01d8\24\0\1\67\1\0" +
        "\70\67\1\u01d9\15\67\1\0\14\67\36\0\1\u01da\150\0" +
        "\1\u01db\73\0\1\u01dc\24\0\1\u01dd\46\0\1\67\1\0" +
        "\70\67\1\u01de\15\67\1\0\14\67\62\0\1\u01df\100\0" +
        "\1\u01df\146\0\1\u01e0\74\0\1\u01e1\111\0\1\u01e2\44\0" +
        "\1\u01e3\120\0\1\u01e4\144\0\1\u01e5\51\0\1\u01e6\201\0" +
        "\1\u01e7\44\0\1\u01e8\177\0\1\u01e9\61\0\1\u01ea\171\0" +
        "\1\u01eb\133\0\1\u01ec\53\0\1\u01ed\106\0\1\u01ee\126\0" +
        "\1\u01ef\133\0\1\u01f0\76\0\1\67\1\0\7\67\26\u0116" +
        "\1\u013d\4\67\1\u0116\3\67\1\u0192\3\67\16\u0116\1\u0193" +
        "\15\u0116\1\u0193\4\67\1\u0116\4\67\1\u0116\2\67\11\0" +
        "\26\u01f1\1\u015e\4\0\1\u013e\3\0\1\u01b2\3\0\16\u01f1" +
        "\1\u0193\15\u01f1\1\u0193\4\0\1\u013e\4\0\1\u01f1\2\0" +
        "\1\67\1\0\7\67\26\u01d2\1\u01f2\4\67\1\u01d2\7\67" +
        "\16\u01d2\1\0\15\u01d2\1\0\4\67\1\u01d2\4\67\1\u01d2" +
        "\2\67\11\0\26\u01f3\5\0\1\u01f3\7\0\16\u01f3\1\0" +
        "\15\u01f3\5\0\1\u01f3\4\0\1\u01f3\15\0\1\u01f4\130\0" +
        "\1\u01f5\133\0\1\u01f6\160\0\1\u01f7\100\0\1\u01f8\116\0" +
        "\1\u01f9\127\0\1\u01fa\106\0\1\u01fb\206\0\1\u01fc\101\0" +
        "\1\u01fd\62\0\1\u01fe\127\0\1\u01ff\142\0\1\u0200\153\0" +
        "\1\u0201\57\0\1\u0202\125\0\1\u019f\123\0\1\u0203\15\0" +
        "\1\u0204\161\0\1\u0205\66\0\1\u0206\111\0\1\u0207\133\0" +
        "\1\u0208\113\0\1\u0209\15\0\1\u020a\110\0\1\u020b\133\0" +
        "\1\u020c\172\0\1\u01df\51\0\1\u01df\126\0\1\u020d\201\0" +
        "\1\u020e\35\0\26\u013e\1\u015e\4\0\1\u013e\3\0\1\u01b2" +
        "\3\0\16\u013e\1\u0193\15\u013e\1\u0193\4\0\1\u013e\4\0" +
        "\1\u013e\2\0\1\67\1\0\7\67\26\u020f\5\67\1\u01d2" +
        "\7\67\16\u020f\1\0\15\u020f\1\0\4\67\1\u01d2\4\67" +
        "\1\u020f\2\67\11\0\26\u01f3\1\u0210\4\0\1\u01f3\7\0" +
        "\16\u01f3\1\0\15\u01f3\5\0\1\u01f3\4\0\1\u01f3\24\0" +
        "\1\u0211\125\0\1\u0212\201\0\1\u0213\44\0\1\u0214\177\0" +
        "\1\u0215\46\0\1\u0216\15\0\1\u0217\103\0\1\u01df\123\0" +
        "\1\u01df\217\0\1\u0218\115\0\1\u0219\65\0\1\u021a\23\0" +
        "\1\u021b\53\0\1\u021c\125\0\1\u021d\130\0\1\u021e\124\0" +
        "\1\u021f\165\0\1\u0220\102\0\1\u0221\112\0\1\u0222\201\0" +
        "\1\u0223\45\0\1\u01db\177\0\1\u01da\105\0\1\u0224\74\0" +
        "\1\u0225\156\0\1\u01df\102\0\1\u01df\144\0\1\u0226\74\0" +
        "\1\u0227\77\0\1\67\1\0\7\67\26\u0228\1\u01f2\4\67" +
        "\1\u01d2\7\67\16\u0228\1\0\15\u0228\1\0\4\67\1\u01d2" +
        "\4\67\1\u0228\2\67\11\0\26\u0229\5\0\1\u01f3\7\0" +
        "\16\u0229\1\0\15\u0229\5\0\1\u01f3\4\0\1\u0229\13\0" +
        "\1\u022a\135\0\1\u01df\126\0\1\u01df\117\0\1\u0212\133\0" +
        "\1\u0213\160\0\1\u022b\100\0\1\u022c\121\0\1\u022d\106\0" +
        "\1\u022e\206\0\1\u022f\101\0\1\u0230\61\0\1\u0231\125\0" +
        "\1\u0232\174\0\1\u0233\124\0\1\u0234\124\0\1\u0235\100\0" +
        "\1\u0236\150\0\1\u0237\100\0\1\u0238\155\0\1\u0239\143\0" +
        "\1\u023a\76\0\1\u0212\74\0\1\u0213\74\0\1\67\1\0" +
        "\7\67\26\u023b\1\u01f2\4\67\1\u01d2\7\67\16\u023b\1\u023c" +
        "\15\u023b\1\u023c\4\67\1\u01d2\4\67\1\u023b\2\67\11\0" +
        "\26\u023d\1\u0210\4\0\1\u01f3\7\0\16\u023d\1\0\15\u023d" +
        "\5\0\1\u01f3\4\0\1\u023d\25\0\1\u023e\120\0\1\u023f" +
        "\133\0\1\u0240\134\0\1\u01fa\150\0\1\u01fb\143\0\1\u0241" +
        "\110\0\1\u0242\115\0\1\u01df\77\0\1\u01df\112\0\1\u0243" +
        "\124\0\1\u0244\161\0\1\u01df\147\0\1\u01df\107\0\1\u0245" +
        "\100\0\1\u0246\142\0\1\u01db\147\0\1\u01da\25\0\1\67" +
        "\1\0\7\67\26\u0247\1\u01f2\4\67\1\u01d2\7\67\16\u0247" +
        "\1\u023c\15\u0247\1\u023c\4\67\1\u01d2\4\67\1\u0247\2\67" +
        "\72\0\1\u023c\15\0\1\u023c\25\0\26\u0248\1\u0210\4\0" +
        "\1\u01f3\7\0\16\u0248\1\u023c\15\u0248\1\u023c\4\0\1\u01f3" +
        "\4\0\1\u0248\61\0\1\u0249\67\0\1\u024a\126\0\1\u024b" +
        "\207\0\1\u024c\103\0\1\u024d\60\0\1\u024e\124\0\1\u024f" +
        "\117\0\1\u01df\142\0\1\u01df\71\0\1\67\1\0\7\67" +
        "\26\u0250\1\u01f2\4\67\1\u01d2\7\67\16\u0250\1\u023c\15\u0250" +
        "\1\u023c\4\67\1\u01d2\4\67\1\u0250\2\67\11\0\26\u0251" +
        "\1\u0210\4\0\1\u01f3\7\0\16\u0251\1\u023c\15\u0251\1\u023c" +
        "\4\0\1\u01f3\4\0\1\u0251\13\0\1\u019f\135\0\1\u0245" +
        "\126\0\1\u0246\126\0\1\u0252\115\0\1\u0253\122\0\1\u0254" +
        "\124\0\1\u0255\107\0\1\67\1\0\7\67\26\u01d2\1\u01f2" +
        "\4\67\1\u01d2\7\67\16\u01d2\1\u023c\15\u01d2\1\u023c\4\67" +
        "\1\u01d2\4\67\1\u01d2\2\67\11\0\26\u0256\1\u0210\4\0" +
        "\1\u01f3\7\0\16\u0256\1\u023c\15\u0256\1\u023c\4\0\1\u01f3" +
        "\4\0\1\u0256\75\0\1\u01df\51\0\1\u01df\126\0\1\137" +
        "\113\0\26\u01f3\1\u0210\4\0\1\u01f3\7\0\16\u01f3\1\u023c" +
        "\15\u01f3\1\u023c\4\0\1\u01f3\4\0\1\u01f3\2\0";

    private static int [] zzUnpackTrans() {
        int [] result = new int[46920];
        int offset = 0;
        offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int [] result) {
        int i = 0;       /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            value--;
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }


    /* error codes */
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;

    /* error messages for the codes above */
    private static final String ZZ_ERROR_MSG[] = {
        "Unkown internal scanner error",
        "Error: could not match input",
        "Error: pushback value was too large"
    };

    /**
     * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
     */
    private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

    private static final String ZZ_ATTRIBUTE_PACKED_0 =
        "\1\0\1\1\3\0\1\1\1\0\3\11\46\1\1\11" +
        "\2\1\2\11\2\1\1\11\17\1\1\11\4\1\1\11" +
        "\2\1\1\11\2\1\2\11\4\1\2\11\2\1\3\11" +
        "\1\0\27\1\2\0\6\1\1\0\1\1\2\0\2\1" +
        "\3\0\27\1\1\0\13\1\1\0\2\1\3\0\30\1" +
        "\1\11\2\0\30\1\1\0\10\1\1\0\2\1\1\0" +
        "\1\11\44\1\1\0\10\1\2\0\12\1\1\0\15\1" +
        "\1\0\3\1\1\0\10\1\1\0\1\11\6\1\2\0" +
        "\11\1\1\0\3\1\1\0\5\1\1\0\5\1\3\0" +
        "\2\1\1\0\3\1\4\0\1\1\1\0\5\1\1\0" +
        "\3\1\6\0\1\1\2\0\1\1\5\0\2\1\2\0" +
        "\1\1\4\0\1\1\3\0\1\1\6\0\1\1\3\0" +
        "\1\1\7\0\1\1\1\11\1\0\1\1\4\0\1\1" +
        "\3\0\1\1\22\0\1\1\1\0\1\1\14\0\1\11" +
        "\22\0\1\1\34\0\1\1\30\0\1\1\22\0\3\1" +
        "\11\0\2\1\7\0\2\1\2\0\3\1";

    private static int [] zzUnpackAttribute() {
        int [] result = new int[598];
        int offset = 0;
        offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int [] result) {
        int i = 0;       /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    /** the input device */
    private java.io.Reader zzReader;

    /** the current state of the DFA */
    private int zzState;

    /** the current lexical state */
    private int zzLexicalState = YYINITIAL;

    /** this buffer contains the current text to be matched and is
        the source of the yytext() string */
    private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

    /** the textposition at the last accepting state */
    private int zzMarkedPos;

    /** the current text position in the buffer */
    private int zzCurrentPos;

    /** startRead marks the beginning of the yytext() string in the buffer */
    private int zzStartRead;

    /** endRead marks the last character in the buffer, that has been read
        from input */
    private int zzEndRead;

    /** number of newlines encountered up to the start of the matched text */
    private int yyline;

    /** the number of characters up to the start of the matched text */
    private int yychar;

    /**
     * the number of characters from the last newline up to the start of the
     * matched text
     */
    private int yycolumn;

    /**
     * zzAtBOL == true <=> the scanner is currently at the beginning of a line
     */
    private boolean zzAtBOL = true;

    /** zzAtEOF == true <=> the scanner is at the EOF */
    private boolean zzAtEOF;

    /** denotes if the user-EOF-code has already been executed */
    private boolean zzEOFDone;

    /* user code: */
    public int start;
    public int end;
    public int beginString;
    public static Set<String> commands = new HashSet<String>();
    public static Set<String> macros = new HashSet<String>();
    public static Set<String> variables = new HashSet<String>();
    public Set<String> infile;

    private ScilabDocument doc;
    private boolean transposable;
    private Element elem;
    private boolean breakstring;

    public ScilabLexer(ScilabDocument doc) {
        this(doc, true);
    }

    public ScilabLexer(ScilabDocument doc, boolean update) {
        this.doc = doc;
        this.elem = doc.getDefaultRootElement();
        this.infile = doc.getFunctionsInDoc();
        if (update) {
            update();
        }
    }

    public static void update() {
        if (ScilabCommonsUtils.isScilabThread()) {
            String[] vars = ScilabKeywords.GetVariablesName();
            String[] funs = ScilabKeywords.GetFunctionsName();
            String[] macs = ScilabKeywords.GetMacrosName();
            variables.clear();
            commands.clear();
            macros.clear();
            if (vars != null) {
                variables.addAll(Arrays.asList(vars));
            }
            if (funs != null) {
                commands.addAll(Arrays.asList(funs));
            }
            if (macs != null) {
                macros.addAll(Arrays.asList(macs));
            }
        }
    }

    public void setRange(int p0, int p1) {
        start = p0;
        end = p1;
        transposable = false;
        breakstring = false;
        yyreset(new ScilabDocumentReader(doc, p0, p1));
        int currentLine = elem.getElementIndex(start);
        if (currentLine != 0 && ((ScilabDocument.ScilabLeafElement) elem.getElement(currentLine - 1)).isBrokenString()) {
            yybegin(QSTRING);
        }
    }

    public int yychar() {
        return yychar;
    }

    public int scan() throws IOException {
        int ret = yylex();
        if (start + yychar + yylength() == end - 1) {
            ((ScilabDocument.ScilabLeafElement) elem.getElement(elem.getElementIndex(start))).setBrokenString(breakstring);
            breakstring = false;
        }
        return ret;
    }

    public int getKeyword(int pos, boolean strict) {
        Element line = elem.getElement(elem.getElementIndex(pos));
        int end = line.getEndOffset();
        int tok = -1;
        start = line.getStartOffset();
        int startL = start;
        int s = -1;

        try {
            yyreset(new ScilabDocumentReader(doc, start, end));
            if (!strict) {
                pos++;
            }

            while (startL < pos && (s != startL || yystate() == BREAKSTRING)) {
                s = startL;
                tok = yylex();
                startL = start + yychar + yylength();
            }

            return tok;
        } catch (IOException e) {
            return ScilabLexerConstants.DEFAULT;
        }
    }

    public static ScilabTokens getScilabTokens(String str) {
        ScilabDocument doc = new ScilabDocument(false);
        try {
            doc.insertString(0, str, null);
        } catch (BadLocationException e) { }
        return getScilabTokens(doc);
    }

    public static ScilabTokens getScilabTokens(ScilabDocument doc) {
        ScilabLexer lexer = new ScilabLexer(doc);
        lexer.yyreset(new ScilabDocumentReader(doc, 0, doc.getLength()));
        ScilabTokens tokens = new ScilabTokens();
        int tok = -1;
        try {
            while (tok != ScilabLexerConstants.EOF) {
                tok = lexer.yylex();
                tokens.add(tok, lexer.yychar + lexer.yylength());
            }
        } catch (IOException e) { }

        return tokens;
    }

    public static class ScilabTokens {
        private List<Integer> tokenType = new ArrayList<Integer>();
        private List<Integer> tokenPos = new ArrayList<Integer>();

        ScilabTokens() { }

        void add(final int type, final int pos) {
            tokenType.add(type);
            tokenPos.add(pos);
        }

        public final List<Integer> getTokenType() {
            return tokenType;
        }

        public final List<Integer> getTokenPos() {
            return tokenPos;
        }
    }


    /**
     * Creates a new scanner
     * There is also a java.io.InputStream version of this constructor.
     *
     * @param   in  the java.io.Reader to read input from.
     */
    public ScilabLexer(java.io.Reader in) {
        this.zzReader = in;
    }

    /**
     * Creates a new scanner.
     * There is also java.io.Reader version of this constructor.
     *
     * @param   in  the java.io.Inputstream to read input from.
     */
    public ScilabLexer(java.io.InputStream in) {
        this(new java.io.InputStreamReader(in));
    }

    /**
     * Unpacks the compressed character translation table.
     *
     * @param packed   the packed character translation table
     * @return         the unpacked character translation table
     */
    private static char [] zzUnpackCMap(String packed) {
        char [] map = new char[0x10000];
        int i = 0;  /* index in packed string  */
        int j = 0;  /* index in unpacked array */
        while (i < 210) {
            int  count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }


    /**
     * Refills the input buffer.
     *
     * @return      <code>false</code>, iff there was new input.
     *
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    private boolean zzRefill() throws java.io.IOException {

        /* first: make room (if you can) */
        if (zzStartRead > 0) {
            System.arraycopy(zzBuffer, zzStartRead,
                             zzBuffer, 0,
                             zzEndRead - zzStartRead);

            /* translate stored positions */
            zzEndRead -= zzStartRead;
            zzCurrentPos -= zzStartRead;
            zzMarkedPos -= zzStartRead;
            zzStartRead = 0;
        }

        /* is the buffer big enough? */
        if (zzCurrentPos >= zzBuffer.length) {
            /* if not: blow it up */
            char newBuffer[] = new char[zzCurrentPos * 2];
            System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
            zzBuffer = newBuffer;
        }

        /* finally: fill the buffer with new input */
        int numRead = zzReader.read(zzBuffer, zzEndRead,
                                    zzBuffer.length - zzEndRead);

        if (numRead > 0) {
            zzEndRead += numRead;
            return false;
        }
        // unlikely but not impossible: read 0 characters, but not at end of stream
        if (numRead == 0) {
            int c = zzReader.read();
            if (c == -1) {
                return true;
            } else {
                zzBuffer[zzEndRead++] = (char) c;
                return false;
            }
        }

        // numRead < 0
        return true;
    }


    /**
     * Closes the input stream.
     */
    public final void yyclose() throws java.io.IOException {
        zzAtEOF = true;            /* indicate end of file */
        zzEndRead = zzStartRead;  /* invalidate buffer    */

        if (zzReader != null) {
            zzReader.close();
        }
    }


    /**
     * Resets the scanner to read from a new input stream.
     * Does not close the old reader.
     *
     * All internal variables are reset, the old input stream
     * <b>cannot</b> be reused (internal buffer is discarded and lost).
     * Lexical state is set to <tt>ZZ_INITIAL</tt>.
     *
     * @param reader   the new input stream
     */
    public final void yyreset(java.io.Reader reader) {
        zzReader = reader;
        zzAtBOL  = true;
        zzAtEOF  = false;
        zzEOFDone = false;
        zzEndRead = zzStartRead = 0;
        zzCurrentPos = zzMarkedPos = 0;
        yyline = yychar = yycolumn = 0;
        zzLexicalState = YYINITIAL;
    }


    /**
     * Returns the current lexical state.
     */
    public final int yystate() {
        return zzLexicalState;
    }


    /**
     * Enters a new lexical state
     *
     * @param newState the new lexical state
     */
    public final void yybegin(int newState) {
        zzLexicalState = newState;
    }


    /**
     * Returns the text matched by the current regular expression.
     */
    public final String yytext() {
        return new String( zzBuffer, zzStartRead, zzMarkedPos - zzStartRead );
    }


    /**
     * Returns the character at position <tt>pos</tt> from the
     * matched text.
     *
     * It is equivalent to yytext().charAt(pos), but faster
     *
     * @param pos the position of the character to fetch.
     *            A value from 0 to yylength()-1.
     *
     * @return the character at position pos
     */
    public final char yycharat(int pos) {
        return zzBuffer[zzStartRead + pos];
    }


    /**
     * Returns the length of the matched text region.
     */
    public final int yylength() {
        return zzMarkedPos - zzStartRead;
    }


    /**
     * Reports an error that occured while scanning.
     *
     * In a wellformed scanner (no or only correct usage of
     * yypushback(int) and a match-all fallback rule) this method
     * will only be called with things that "Can't Possibly Happen".
     * If this method is called, something is seriously wrong
     * (e.g. a JFlex bug producing a faulty scanner etc.).
     *
     * Usual syntax/scanner level error handling should be done
     * in error fallback rules.
     *
     * @param   errorCode  the code of the errormessage to display
     */
    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        } catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
        }

        throw new Error(message);
    }


    /**
     * Pushes the specified amount of characters back into the input stream.
     *
     * They will be read again by then next call of the scanning method
     *
     * @param number  the number of characters to be read again.
     *                This number must not be greater than yylength()!
     */
    public void yypushback(int number)  {
        if ( number > yylength() ) {
            zzScanError(ZZ_PUSHBACK_2BIG);
        }

        zzMarkedPos -= number;
    }


    /**
     * Resumes scanning until the next regular expression is matched,
     * the end of input is encountered or an I/O-Error occurs.
     *
     * @return      the next token
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    public int yylex() throws java.io.IOException {
        int zzInput;
        int zzAction;

        // cached fields:
        int zzCurrentPosL;
        int zzMarkedPosL;
        int zzEndReadL = zzEndRead;
        char [] zzBufferL = zzBuffer;
        char [] zzCMapL = ZZ_CMAP;

        int [] zzTransL = ZZ_TRANS;
        int [] zzRowMapL = ZZ_ROWMAP;
        int [] zzAttrL = ZZ_ATTRIBUTE;

        while (true) {
            zzMarkedPosL = zzMarkedPos;

            yychar += zzMarkedPosL - zzStartRead;

            zzAction = -1;

            zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

            zzState = ZZ_LEXSTATE[zzLexicalState];


            zzForAction: {
                while (true) {

                    if (zzCurrentPosL < zzEndReadL) {
                        zzInput = zzBufferL[zzCurrentPosL++];
                    } else if (zzAtEOF) {
                        zzInput = YYEOF;
                        break zzForAction;
                    } else {
                        // store back cached positions
                        zzCurrentPos  = zzCurrentPosL;
                        zzMarkedPos   = zzMarkedPosL;
                        boolean eof = zzRefill();
                        // get translated positions and possibly new buffer
                        zzCurrentPosL  = zzCurrentPos;
                        zzMarkedPosL   = zzMarkedPos;
                        zzBufferL      = zzBuffer;
                        zzEndReadL     = zzEndRead;
                        if (eof) {
                            zzInput = YYEOF;
                            break zzForAction;
                        } else {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                    }
                    int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
                    if (zzNext == -1) {
                        break zzForAction;
                    }
                    zzState = zzNext;

                    int zzAttributes = zzAttrL[zzState];
                    if ( (zzAttributes & 1) == 1 ) {
                        zzAction = zzState;
                        zzMarkedPosL = zzCurrentPosL;
                        if ( (zzAttributes & 8) == 8 ) {
                            break zzForAction;
                        }
                    }

                }
            }

            // store back cached position
            zzMarkedPos = zzMarkedPosL;

            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 34: {
                    transposable = false;
                    return ScilabLexerConstants.SKEYWORD;
                }
                case 46:
                    break;
                case 1: {
                    return ScilabLexerConstants.STRING;
                }
                case 47:
                    break;
                case 28: {
                    return ScilabLexerConstants.WHITE;
                }
                case 48:
                    break;
                case 42: {
                    return ScilabLexerConstants.TODO;
                }
                case 49:
                    break;
                case 31: {
                    return ScilabLexerConstants.ERROR;
                }
                case 50:
                    break;
                case 2: {
                    transposable = false;
                    return ScilabLexerConstants.DEFAULT;
                }
                case 51:
                    break;
                case 3: {
                    transposable = false;
                    return ScilabLexerConstants.OPENCLOSE;
                }
                case 52:
                    break;
                case 38: {
                    transposable = false;
                    return ScilabLexerConstants.ELSEIF;
                }
                case 53:
                    break;
                case 26: {
                    yybegin(COMMANDSWHITE);
                    return ScilabLexerConstants.WHITE;
                }
                case 54:
                    break;
                case 43: {
                    return ScilabLexerConstants.URL;
                }
                case 55:
                    break;
                case 12: {
                    transposable = false;
                    return ScilabLexerConstants.SPECIAL;
                }
                case 56:
                    break;
                case 39: {
                    transposable = false;
                    return ScilabLexerConstants.CKEYWORD;
                }
                case 57:
                    break;
                case 21: {
                    return ScilabLexerConstants.TAB_COMMENT;
                }
                case 58:
                    break;
                case 32: {
                    transposable = true;
                    return ScilabLexerConstants.CONSTANTES;
                }
                case 59:
                    break;
                case 11: {
                    transposable = false;
                    return ScilabLexerConstants.TAB;
                }
                case 60:
                    break;
                case 17: {
                    return ScilabLexerConstants.TAB_STRING;
                }
                case 61:
                    break;
                case 41: {
                    return ScilabLexerConstants.LATEX;
                }
                case 62:
                    break;
                case 23: {
                    transposable = true;
                    return ScilabLexerConstants.FIELD;
                }
                case 63:
                    break;
                case 14: {
                    return ScilabLexerConstants.DEFAULT;
                }
                case 64:
                    break;
                case 36: {
                    yypushback(yylength());
                    yybegin(BREAKSTRING);
                    transposable = false;
                    return ScilabLexerConstants.STRING;
                }
                case 65:
                    break;
                case 44: {
                    transposable = false;
                    return ScilabLexerConstants.FKEYWORD;
                }
                case 66:
                    break;
                case 7: {
                    transposable = false;
                    beginString = zzStartRead;
                    yybegin(QSTRING);
                    return ScilabLexerConstants.STRING;
                }
                case 67:
                    break;
                case 35: {
                    breakstring = true;
                    return ScilabLexerConstants.SPECIAL;
                }
                case 68:
                    break;
                case 20: {
                    return ScilabLexerConstants.WHITE_COMMENT;
                }
                case 69:
                    break;
                case 37: {
                    return ScilabLexerConstants.LATEXINSTRING;
                }
                case 70:
                    break;
                case 25: {
                    yypushback(yylength());
                    yybegin(YYINITIAL);
                }
                case 71:
                    break;
                case 9: {
                    transposable = false;
                    yybegin(FIELD);
                    return ScilabLexerConstants.OPERATOR;
                }
                case 72:
                    break;
                case 33: {
                    transposable = false;
                    return ScilabLexerConstants.OSKEYWORD;
                }
                case 73:
                    break;
                case 45: {
                    return ScilabLexerConstants.MAIL;
                }
                case 74:
                    break;
                case 13: {
                    transposable = true;
                    return ScilabLexerConstants.NUMBER;
                }
                case 75:
                    break;
                case 40: {
                    return ScilabLexerConstants.AUTHORS;
                }
                case 76:
                    break;
                case 16: {
                    return ScilabLexerConstants.WHITE_STRING;
                }
                case 77:
                    break;
                case 22: {
                    yypushback(1);
                    yybegin(YYINITIAL);
                }
                case 78:
                    break;
                case 8: {
                    transposable = true;
                    String str = yytext();
                    if (commands.contains(str)) {
                        yybegin(COMMANDS);
                        return ScilabLexerConstants.COMMANDS;
                    } else if (macros.contains(str)) {
                        yybegin(COMMANDS);
                        return ScilabLexerConstants.MACROS;
                    } else if (infile.contains(str)) {
                        yybegin(COMMANDS);
                        return ScilabLexerConstants.MACROINFILE;
                    } else {
                        List<String>[] arr = doc.getInOutArgs(start + yychar);
                        if (arr != null && (arr[0].contains(str) || arr[1].contains(str))) {
                            return ScilabLexerConstants.INPUTOUTPUTARGS;
                        } else if (variables.contains(str)) {
                            return ScilabLexerConstants.VARIABLES;
                        }
                    }
                    return ScilabLexerConstants.ID;
                }
                case 79:
                    break;
                case 6: {
                    if (transposable) {
                        return ScilabLexerConstants.TRANSP;
                    } else {
                        beginString = zzStartRead;
                        yybegin(QSTRING);
                        return ScilabLexerConstants.STRING;
                    }
                }
                case 80:
                    break;
                case 18: {
                    return ScilabLexerConstants.COMMENT;
                }
                case 81:
                    break;
                case 30: {
                    transposable = false;
                    yypushback(2);
                    yybegin(COMMENT);
                }
                case 82:
                    break;
                case 19: {
                    yybegin(YYINITIAL);
                    return ScilabLexerConstants.DEFAULT;
                }
                case 83:
                    break;
                case 27: {
                    yybegin(COMMANDSWHITE);
                    return ScilabLexerConstants.TAB;
                }
                case 84:
                    break;
                case 4: {
                    transposable = true;
                    return ScilabLexerConstants.OPENCLOSE;
                }
                case 85:
                    break;
                case 15: {
                    transposable = false;
                    yybegin(YYINITIAL);
                    return ScilabLexerConstants.STRING;
                }
                case 86:
                    break;
                case 10: {
                    transposable = false;
                    return ScilabLexerConstants.WHITE;
                }
                case 87:
                    break;
                case 5: {
                    transposable = false;
                    return ScilabLexerConstants.OPERATOR;
                }
                case 88:
                    break;
                case 29: {
                    return ScilabLexerConstants.TAB;
                }
                case 89:
                    break;
                case 24: {
                }
                case 90:
                    break;
                default:
                    if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
                        zzAtEOF = true;
                        {
                            return ScilabLexerConstants.EOF;
                        }
                    } else {
                        zzScanError(ZZ_NO_MATCH);
                    }
            }
        }
    }


}
