/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "NetworkInterface.h"
#include <errno.h>
#include <stdlib.h>

NetworkInterface::NetworkInterface() : interfaces(NULL) {
#ifdef SA_OPEN_NET
	error = sa_open_net();
#endif
}

NetworkInterface::~NetworkInterface() {
#ifdef SA_CLOSE_NET
	sa_close_net();
#endif
	if (interfaces != NULL)
		free(interfaces);
}

struct sa_net_interface* NetworkInterface::getNetworkInterfaces(uint16_t* written) {
	if ((error = sa_count_net_interfaces(&numberInterfaces)) != 0)
		return NULL;
	if ((interfaces = (struct sa_net_interface*) realloc(interfaces, numberInterfaces * sizeof(struct sa_net_interface))) == NULL) {
		error = ENOMEM;
		return NULL;
	}
	if ((error = sa_reset_net_interfaces()) != 0)
		return NULL;
	if ((error = sa_get_net_interfaces(interfaces, numberInterfaces, written)) != 0)
		return NULL;
	return interfaces;
}

void NetworkInterface::getNetworkInterface(const QString& name, struct sa_net_interface* dst) {
	if ((error = sa_reset_net_interfaces()) != 0)
		return;
	error = sa_get_net_interface(name.toAscii().data(), dst);
}
