#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of the Shiboken Python Bindings Generator project.
#
# Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
#
# Contact: PySide team <contact@pyside.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation. Please
# review the following information to ensure the GNU Lesser General
# Public License version 2.1 requirements will be met:
# http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
# #
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

'''Test cases for SimpleFile class'''

import os
import unittest

from sample import SimpleFile

class SimpleFileTest(unittest.TestCase):
    '''Test cases for SimpleFile class.'''

    def setUp(self):
        filename = 'simplefile%d.txt' % os.getpid()
        self.existing_filename = os.path.join(os.path.curdir, filename)
        self.delete_file = False
        if not os.path.exists(self.existing_filename):
            f = open(self.existing_filename, 'w')
            for line in range(10):
                f.write('sbrubbles\n')
            f.close()
            self.delete_file = True

        self.non_existing_filename = os.path.join(os.path.curdir, 'inexistingfile.txt')
        i = 0
        while os.path.exists(self.non_existing_filename):
            i += 1
            filename = 'inexistingfile-%d.txt' % i
            self.non_existing_filename = os.path.join(os.path.curdir, filename)

    def tearDown(self):
        if self.delete_file:
            os.remove(self.existing_filename)

    def testExistingFile(self):
        '''Test SimpleFile class with existing file.'''
        f = SimpleFile(self.existing_filename)
        self.assertEqual(f.filename(), self.existing_filename)
        f.open()
        self.assertNotEqual(f.size(), 0)
        f.close()

    def testNonExistingFile(self):
        '''Test SimpleFile class with non-existing file.'''
        f = SimpleFile(self.non_existing_filename)
        self.assertEqual(f.filename(), self.non_existing_filename)
        self.assertRaises(IOError, f.open)
        self.assertEqual(f.size(), 0)

if __name__ == '__main__':
    unittest.main()

