/*
 * Copyright 2008 Klaus Triendl
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free 
 * Software Foundation, 51 Franklin Street, Fifth Floor, 
 * Boston, MA 02110-1301, USA.
*/

#include <sigc++/sigc++.h>
#include <sigx/sigx.h>


class MyClass: public sigx::glib_auto_dispatchable
{
public:
	void test()	{}
};


sigx::signal_wrapper<sigc::signal<void> > the_signal;

int main()
{
	MyClass x1;
	
	// ok
	the_signal.connect(sigc::mem_fun(x1, &MyClass::test));
	// ok
	the_signal.connect(sigx::open_tunnel(sigc::mem_fun(x1, &MyClass::test)));

	// tunnel functor is not toplevel
	the_signal.connect(sigc::bind(sigc::hide(sigx::open_tunnel(sigc::mem_fun(x1, &MyClass::test))), 1));
	// cannot connect slots
	the_signal.connect(sigc::slot<void>(sigc::mem_fun(x1, &MyClass::test)));
	// cannot pass a functor adapting a slot
	the_signal.connect(sigx::open_tunnel(sigc::slot<void>(sigc::mem_fun(x1, &MyClass::test))));
	// cannot pass a functor adapting a slot
	the_signal.connect(sigc::bind(sigc::hide(sigc::slot<void>(sigc::mem_fun(x1, &MyClass::test))), 1));
}
