/*
 *  sha1.h
 *
 *  Copyright (C) 1998, 2009
 *  Paul E. Jones <paulej@packetizer.com>
 *  All Rights Reserved.
 *
 *****************************************************************************
 *  $Id: sha1.h 12 2009-06-22 19:34:25Z paulej $
 *****************************************************************************
 *
 *  Description:
 *      This class implements the Secure Hashing Standard as defined
 *      in FIPS PUB 180-1 published April 17, 1995.
 *
 *      Many of the variable names in this class, especially the single
 *      character names, were used because those were the names used
 *      in the publication.
 *
 *      Please read the file sha1.cpp for more information.
 *
 */

#ifndef UTILS_SHA1_H
#define UTILS_SHA1_H


#include "../simtypes.h"

class SHA1
{

    public:

        SHA1() { Reset(); }

        /*
         *  Re-initialize the class
         */
        void Reset();

        /*
         *  Returns the message digest (must be 20 bytes long!)
         */
        bool Result(uint8 *message_digest_array );

        /*
         *  Provide input to SHA1
         */
        void Input( const char *message_array, uint32 length);
        void Input( char message_element);

private:

        /*
         *  Process the next 512 bits of the message
         */
        void ProcessMessageBlock();

        /*
         *  Pads the current message block to 512 bits
         */
        void PadMessage();

        /*
         *  Performs a circular left shift operation
         */
        inline unsigned CircularShift(int bits, unsigned word);

        uint32 H[5];                      // Message digest buffers

        uint32 Length_Low;                // Message length in bits
        uint32 Length_High;               // Message length in bits

        uint8 Message_Block[64];    // 512-bit message blocks
        int Message_Block_Index;            // Index into message block array

        bool Computed;                      // Is the digest computed?
        bool Corrupted;                     // Is the message digest corrupted?
};

#endif
