# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/defaults.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Default values

=end
$latex_run=nil
module SiSU_Viz
  begin
    require 'uri'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('uri NOT FOUND (LoadError)')
  end
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'css'                                # css.rb
    include SiSU_Style
  class Defaults
    def initialize
      @fonts='verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman' # 'verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
      @dir=SiSU_Env::InfoEnv.new
      @date=SiSU_Env::InfoDate.new #{@date.year}
      @v=SiSU_Env::InfoVersion.instance.get_version
    end
    #% glyph
    def glyph_bullet # &bullet;
      '&#149;&nbsp;' # [&#149; flagged]
    end
    #% html
    def html_hardspace
      '&nbsp;'
    end
    def semantic_tags
      def default
        {
          pub:     'publication',
          conv:    'convention',
          vol:     'volume',
          pg:      'page',
          cty:     'city',
          org:     'organization',
          uni:     'university',
          dept:    'department',
          fac:     'faculty',
          inst:    'institute',
          co:      'company',
          com:     'company',
          conv:    'convention',
          dt:      'date',
          y:       'year',
          m:       'month',
          d:       'day',
          ti:      'title',
          au:      'author',
          ed:      'editor', #editor?
          v:       'version', #edition
          n:       'name',
          fn:      'firstname',
          mn:      'middlename',
          ln:      'lastname',
          in:      'initials',
          qt:      'quote',
          ct:      'cite',
          ref:     'reference',
          ab:      'abreviation',
          def:     'define',
          desc:    'description',
          trans:   'translate',
        }
      end
      self
    end
    #% decorate
    def decorate_italics
      'title|article|book|journal'
    end
    def decorate_bold
    end
    def decorate_uppercase
      'surname'
    end
    #% semantic
    def sem_title #dc 1
      'title'
    end
    def sem_article
      'article'
    end
    def sem_book
      'book'
    end
    def sem_journal
      'journal'
    end
    def sem_fullname # (contains: firstname, surname) #issues arise as contains surname etc.
      'fullname'
    end
    def sem_first
      'first'
    end
    def sem_surname
      'surname'
    end
    def sem_middle
      'middle'
    end
    def sem_creator #dc 2 #==fullname (contains: firstname, surname)
      'creator'
    end
    def sem_author #==fullname (contains: firstname, surname)
      'author'
    end
    def sem_editor #==fullname (contains: firstname, surname)
      'editor'
    end
    def sem_illustrator #==fullname (contains: firstname, surname)
      'illustrator'
    end
    def sem_translator #==fullname (contains: firstname, surname)
      'translator'
    end
    def sem_isbn # 10 or 13
      'isbn'
    end
    def sem_isbn_10
      'isbn10'
    end
    def sem_isbn_13
      'isbn13'
    end
    def sem_loc # library of congress
      'loc'
    end
    def sem_dewey
      'dewey'
    end
    def sem_pg # project gutenberg number
      'pg'
    end
    def sem_subject #dc 3
      'subject'
    end
    def sem_date #dc 7
      'date'
    end
    def sem_date_created
      'date_created'
    end
    def sem_date_issued
      'date_issued'
    end
    def sem_date_available
      'date_available'
    end
    def sem_date_valid
      'date_valid'
    end
    def sem_date_modified
      'date_modified'
    end
    def sem_type #dc 8
      'type'
    end
    def sem_description #dc 4
      'description'
    end
    def sem_publisher #dc 5
      'publisher'
    end
    def sem_contributor #dc 6
      'contributor'
    end
    def sem_format #dc 9
      'format'
    end
    def sem_identifier #dc 10
      'identifier'
    end
    def sem_source #dc 11
      'source'
    end
    def sem_language #dc 12
      'language'
    end
    def sem_relation #dc 13
      'source'
    end
    def sem_coverage #dc 14
      'coverage'
    end
    def sem_rights #dc 15
      'rights'
    end
    def sem_copyright
      'copyright'
    end
    def sem_license
      'license'
    end
    def sem_prepared_by
      'prepared_by'
    end
    def sem_digitized_by
      'digitized_by'
    end
    def sem_keywords
      'keywords'
    end
    def sem_comments
      'comments'
    end
    def sem_abstract
      'abstract'
    end
    #% path
    def path_stylesheet_home
      %{  <link rel="stylesheet" href="./#{@dir.path.style}/homepage.css" type="text/css" />}
    end
    #% text #changed from txt to avoid naming conflicts #FOLLOW
    def txt_generator
      %{  <meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
    <link rel="generator" href="http://www.sisudoc.org/" />}
    end
    def txt_generator_comment
      %{  <!- #{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" http://www.sisudoc.org/ ->}
    end
    def txt_hp
      '&nbsp;SiSU'
    end
    def txt_hp_alias
      'SiSU'
    end
    def txt_home
      'SiSU'
    end
    def txt_signature # used in latex/pdf footer
      'SiSU'
    end
    #% url
    def url_urify(uri)
      URI.parse(uri)
    end
    def url_sisu
      'http://www.sisudoc.org/'
    end
    def url_sisudoc
      'http://www.sisudoc.org'
    end
    def url_footer_signature
      'http://www.sisudoc.org/'
    end
    def url_root
      '/sisu' #watch
    end
    def url_root_http
      'http://www.sisudoc.org/' #watch
    end
    def url_home
      'http://www.sisudoc.org/' # used in pdf header
    end
    def url_site #used as stub... where there are subdirectories and is different from home
      url_home
      #'http://www.sisudoc.org/' # used in pdf header
    end
    def url_txt
      'www.sisudoc.org/'
    end
    def url_path_image_base #used for html image display
      "#{Xx[:html_relative2]}_sisu/image"
    end
    def url_path_image #used for html image display
      "#{Xx[:html_relative2]}_sisu/image"
    end
    def url_path_image_sys #used for html image display
      "#{Xx[:html_relative2]}_sisu/image_sys"
    end
    def url_decoration
      def tex_open                     #'{\UseTextSymbol{OML}{<}}'
        Dx[:url_o]
      end
      def tex_close                    #'{\UseTextSymbol{OML}{>}}'
        Dx[:url_c]
      end
      def xml_open                     #'&lt;'
        Dx[:url_o]
      end
      def xml_close                    #'&gt;'
        Dx[:url_c]
      end
      def txt_open
        '<'
      end
      def txt_close
        '>'
      end
      self
    end
    def rel_decoration
      def tex_open                     #'{\UseTextSymbol{OML}{<}}'
        Dx[:rel_o]
      end
      def tex_close                    #'{\UseTextSymbol{OML}{>}}'
        Dx[:rel_c]
      end
      def xml_open                     #'&lt;'
        Dx[:rel_o]
      end
      def xml_close                    #'&gt;'
        Dx[:rel_c]
      end
      def txt_open
        '<'
      end
      def txt_close
        '>'
      end
      self
    end
    #% color
    def color_body
      %{<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">}
    end
    def color_white
      '"#ffffff"'
    end
    def color_black
      '#000000'
    end
    def color_blue_ink
      '#003399'
    end
    def color_blue_tinge
      '#e3ecef'
    end
    def color_blue_grey
      '#8faebf'
    end
    def color_blue_murky
      '#437389'
    end
    def color_beige
      '#f1e8de'
    end
    def color_subtleglow
      '#dddccc'
    end
    def color_glow
      '#fff0c3'
    end
    def color_rose
      '#ffdec9'
    end
    def color_turquoise
      '#1c869b'
    end
    def color_grey_pale
      '#eeeeee'
    end
    def color_grey_medium
      '#cccccc'
    end
    def color_grey
      '#999999'
    end
    def color_yellow_light
      '#fff3b6'
    end
    def color_yellow
      '#ffde14'
    end
    def color_yellow_dark
      '#ffcc00'
    end
    def color_green_light
      '#b7d398'  #  #e2efd5 #b7d398 #b1c999 # '#aed19e'
    end
    def color_green
      '#0a8400'
    end
    def color_green_dark
      '#086800'
    end
    def color_ruby
      '#a00000'
    end
    def color_maroon
      '#800000'
    end
    def color_paper
      %{"#{color_white}"}
    end
    def color_band1
      %{"#{color_white}"}
    end
    def color_band2
      %{"#{color_white}"}
    end
    def color_body
      %{<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">}
    end
    def color_font_face #was font WATCH
      "#{color_black}"
    end
    def color_surround
      %{"#{color_white}"}
    end
    def color_band
      %{"#{color_white}"}
    end
    def color_table1
      'ffffcc'
    end
    def color_table2
      'c0d0f0'
    end
    def color_band1
      '"#ffffff"'
    end
    def color_band2
      '"#ffffff"'
    end
    #% icon
    def icon_ico
      'rb7.ico'
    end
    def icon_sisu
      'sisu.png'
    end
    def icon_manifest
      'b_info.png'
    end
    def icon_doc
      'b_doc.png'
    end
    def icon_toc
      'b_toc.png'
    end
    def icon_wmp
      'b_wmp.png'
    end
    def icon_odf
      'b_odf.png'
    end
    def icon_epub
      'b_epub.png'
    end
    def icon_pdf
      'b_pdf.png'
    end
    def icon_pdf_portrait
      'b_pdf.png'
    end
    def icon_pdf_landscape
      'b_pdf.png'
    end
    def icon_choice
      'b_choice.png'
    end
    def icon_new
      'b_new.png'
    end
    def icon_dot_clear
      'dot_clear.png'
    end
    def icon_dot_white
      'dot_white.png'
    end
    def icon_dot
      icon_dot_white
    end
    def icon_home_button
      'sisu.png'
    end
    def icon_next
      'arrow_next_red.png'
    end
    def icon_previous
      'arrow_prev_red.png'
    end
    def icon_up
      'arrow_up_red.png'
    end
    #% font
    def font_fonts
      @fonts
    end
    def font_face
      %{face="#{font_fonts}"}
    end
    def font_color
      'color="#000000"'
    end
    def font_size_endnote
      'size="3"'
    end
    def font_small
      'size="3"'
    end
    def font_tiny
      'size="2"'
    end
    #% markup
    def markup_italics_list #regular expression of words to be italised
    end
    def markup_bold_list #regular expression of words to be made bold
      'SiSU'
    end
    def markup_make_italic
      if defined? italics_list \
      and italics_list
        make={}
        if italics_list
          r=italics_list.dup
          x=case r
          when /\/i$/ then 'i'
          else             ''
          end
          r=r.gsub(/^\/(.+?)\/i?/,'\1').
            gsub(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=(x =~/i/) \
          ? (/#{m}/i)
          : (/#{m}/)
        else nil
        end
      end
    end
    def markup_make_bold
      if defined? bold_list \
      and not bold_list.empty?
        make={}
        if bold_list
          r=bold_list.dup
          x=case r
          when /\/i$/ then 'i'
          else             ''
          end
          r.gsub(/^\/(.+?)\/i?/,'\1').
            gsub(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=(x =~/i/) \
          ? (/#{m}/i)
          : (/#{m}/)
        else nil
        end
        make
      end
    end
    #% paragraph
    def paragraph_txt
      %{<p class="normal">}
    end
    def paragraph_endnote
      %{<p class="endnote">}
    end
    def paragraph_font_tiny
      %{<font #{font_tiny} #{font_face}>}
    end
    def paragraph_font_small
      %{<font #{font_small} #{font_face}>}
    end
    #% table
    def table_close
      '</td></tr>
</table>'
    end
    def table_width_1
      '"100%"'
    end
    def table_width_2
      '"99%"'
    end
    def table_width_txt
      '"94%"'
    end
    def table_width_txt_r
      '"96%"'
    end
    def table_cellpad_box
      '"20"'
    end
    #% indent
    def indent_level_0
      '"1%"'
    end
    def indent_level_1
      '"4%"'
    end
    def indent_level_2
      '"6%"'
    end
    def indent_level_3
      '"8%"'
    end
    def indent_level_4
      '"10%"'
    end
    #% margin
    def margin_num
      '</p> </td><td width="4%" align="right" valign="top">'
    end
    def margin_numless
      '</td><td width="4%" align="right" valign="top">'
    end
    def margin_num_css
      '</td>
<td width="2%" align="right" valign="top">  '
    end
    def margin_txt_w1
      %{<table summary="" width=#{table_width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="6%" align="right">&nbsp;</td>
<td width="90%" valign="top" align="justify">}
    end
    def margin_txt_w2
      %{<table summary="" width=#{table_width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="10%" align="right">&nbsp;</td>
<td width="86%" valign="top" align="justify">}
    end
    def margin_txt_0
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_0} align="right">
</td><td valign="top" align="justify">}
    end
    def margin_txt_1
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_1} align="right"></td><td valign="top" align="justify">}
    end
    def margin_txt_2
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def margin_txt_3
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_3} align="right">
</td>
<td valign="top" align="justify">}
    end
    def margin_css
      '<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td valign="top" align="justify"> '
    end
    #% png
    def png_ico
      %{  <link rel="shortcut icon" href="../_sisu/image/#{icon_ico}" />}
    end
    def png_sisu #check url path
      %{  <a href="#{@url.sisu}">
    <img border="0" width="160" height="60" src="#{url_path_image}/#{icon_sisu}" alt="SiSU" />
    </a>}
    end
    def png_site
      %{<img src="#{url_path_image}/#{icon_site}" alt="@" border="0" />}
    end
    def png_nav
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_bluebell}" alt="Contents" />}
    end
    def png_manifest
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_manifest}" alt="Document Manifest" />}
    end
    def png_doc
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_doc}" alt="Full Text" />}
    end
    def png_toc
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_toc}" alt="TOC linked" />}
    end
    def png_odf
      %{<img border="0" height="18" width="18" src="#{url_path_image_sys}/#{icon_odf}" alt="ODF/ODT" />}
    end
    def png_epub
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_epub}" alt="EPUB" />}
    end
    def png_pdf
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF" />}
    end
    def png_pdf_portrait
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF portrait" />}
    end
    def png_pdf_landscape
      %{<img border="0" height="15" width="18" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF landscape" />}
    end
    def png_home
      #dir=SiSU_Env::InfoEnv.new #(@fns)
      %{<img border="0" src="#{url_path_image_base}/#{icon_home_button}" alt="#{txt_home} --&gt;" />}
      #%{<img border="0" src="#{dir.url.images_local}/#{icon_home_button}" alt="#{txt_home} --&gt;" />}
    end
    def png_home_button
      rel=@dir.path_rel_links.html_scroll_2
      %{<img border="0" src="#{rel}/#{icon_home_button}" alt="#{txt_home} --&gt;" />}
    end
    #% png_nav #not currently used
    #% nav_txt
    def nav_txt_homepage
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;home&nbsp;
  </font> }
    end
    def nav_txt_toc_link
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;&nbsp;toc&nbsp;
  </font> }
    end
    def nav_txt_doc_link
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;scroll&nbsp;
  </font> }
    end
    def nav_txt_manifest
      #{png_manifest}&nbsp;document&nbsp;manifest
      %{  <font face="#{font_fonts}" size="2">
    [&nbsp;document&nbsp;manifest&nbsp;]
  </font> }
    end
    def nav_txt_concordance
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;&nbsp;A-Z&nbsp;
  </font> }
    end
    def nav_txt_pdf_portrait
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;pdf&nbsp;
  </font> }
    end
    def nav_txt_pdf_landscape
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;pdf&nbsp;
  </font> }
    end
    #% banner
    def banner_home_button_only
      %{<a href="#{url_site}/">
    #{png_home_button}
  </a>}
    end
    def banner_band #yellow_dark now white
      %{<table summary="home button" width="100%" border="0" cellpadding="3" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{color_white}">
  <a href="#{url_site}/" target="_top">
    #{png_home}
  </a>
</td>
<td width="90%">
#{table_close}}
    end
    def banner_instrument_cover_band_scr
      '<table summary="scroll instrument cover band" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">'
    end
    def banner_instrument_cover_band_seg
      '<table summary="segment instrument cover band, title, author, location" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">'
    end
    #% widget
    def widget_promo # Array used to build promo from list.yml and promo.yml
    #  ['sisu_icon','sisu','sisu_search_libre','open_society','fsf','ruby']
    end
    def widgets_open
<<WOK
<table summary="SiSU summary" bgcolor="#ffffff" cellpadding="4" border="0">
WOK
    end
    def widget_sisu_text
<<WOK
  <p class="tiny"><font color="#666666" size="2">
    Output generated by
    <a href="#{url_sisu}">
      #{@v[:project]}
    </a>
    #{@v[:version]} #{@v[:date]} (#{@v[:date_stamp]})
  </font></p>
WOK
    end
    def widget_sisu
<<WOK
<!-- widget sisu -->
<tr><td valign="top" width="100%">
<!-- SiSU Rights -->
#{widget_sisu_text}
</td></tr>
WOK
    end
    def widget_sisu_verbose
<<WOK
<!-- widget sisu -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="#{url_sisu}">
      <img border="0" src="../_sisu/image/sisu.png" alt="SiSU" width="120" height="39" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
<!-- SiSU Rights -->
  <p class="tiny_left"><font color="#666666" size="2">
    Output generated by
    <a href="#{url_sisu}">
      #{@v[:project]}
    </a>
    #{@v[:version]} #{@v[:date]} (#{@v[:date_stamp]})
    <br />
    <a href="#{url_sisu}">
      <b>#{@v[:project]}</b>
    </a>
    Copyright <sup>&copy;</sup> Ralph Amissah
    1997, current #{@date.year_static}.
    All Rights Reserved.
    <br />
    <a href="#{url_sisu}">
      #{@v[:project]}
    </a>
    is software for document structuring, publishing and search,
    <br />
    <a href="#{url_sisu}">
      www.sisudoc.org/
    </a>
    and
    <a href="#{url_sisudoc}">
      www.sisudoc.org
    </a>
  <br />
    <i>w3 since October 3 1993</i>
    <a href="mailto:ralph@amissah.com">
      ralph@amissah.com
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{@v[:project]} using:
    <br />Standard SiSU markup syntax,
    <br />Standard SiSU meta-markup syntax, and the
    <br />Standard SiSU <u>object citation numbering</u> and system, (object/text positioning system)
  <br />
    Copyright <sup>&copy;</sup> Ralph Amissah 1997, current #{@date.year_static}.
    All Rights Reserved.
  </font></p>
</td></tr>
WOK
    end
    def widget_way_better
      <<WOK
<!-- widget way better -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="http://www.gnu.org/licenses/gpl.html">
      <img border="0" src="../_sisu/image/gplv3_free_software.png" alt="GPLv3" width="127" height="51" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="#{url_sisu}">
      #{@v[:project]}
    </a>
    is released under
    <a href="http://www.gnu.org/licenses/gpl.html">GPLv3</a>
    or later,
    #{url_decoration.xml_open}<a href="http://www.gnu.org/licenses/gpl.html">http://www.gnu.org/licenses/gpl.html</a>#{url_decoration.xml_close}
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{@v[:project]}, developed using
    <a href="http://www.ruby-lang.org/en/">
      Ruby
    </a>
    on
    <a href="http://www.debian.org/">
      Debian/Gnu/Linux
    </a>
    software infrastructure,
    with the usual GPL (or OSS) suspects.
  <br />
    Better - "performance, reliability, scalability, security &amp; total cost of ownership"
    [not to mention flexibility &amp; choice] use of and adherence to open standards (where practical and fair) and it is software libré.
  <br />
    Get With the Future
    <a href="http://www.sisudoc.org/">
      Way Better!
    </a>
  </font></p>
</td></tr>
WOK
    end
    #% credits
    def credits_sisu_manifest
      widget_sisu_text
    end
    def credits_sisu
      %{<div class="substance">
<table summary="SiSU summary" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  #{widget_sisu}
</table></div>}
      ''
    end
    def credits_splash
    end
    def credits_sisu_epub
      %{<div class="substance">
<p class="center"><a href="http://www.openebook.org"><b>EPUB</b></a> generated by <a href="http://www.sisudoc.org"><b>#{@v[:project]}</b></a> v#{@v[:version]}, GPL3</p>
</div>}
      ''
    end
  end
  class Home < Defaults
    def initialize
      @v=SiSU_Env::InfoVersion.instance.get_version
      @dir=SiSU_Env::InfoEnv.new
      @date=SiSU_Env::InfoDate.new #{@date.year}
    end
    def redirect
      <<WOK
<html><head>
<title>SiSU</title>
<meta http-equiv="refresh" content="0, url=http://www.sisudoc.org/sisu/SiSU/">
</head>
<body>
SiSU informtion provided at <a href="http://www.sisudoc.org/sisu/SiSU/">www.sisudoc.org/sisu/SiSU</a><p />
If your browser supports redirection, you will be escorted there shortly.
</body>
</html>
WOK
    end
    def homepage
      <<WOK
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>SiSU information Structuring Universe - Structured information, Serialized Units - software for electronic texts, documents, books, digital libraries in plaintext, HTML, EPUB, XHTML, XML, ODF (OpenDocument), LaTeX, PDF, SQL (PostgreSQL and SQLite), and for search</title>
<meta name="dc.title" content="SiSU - SiSU information Structuring Universe, Structured information Serialised Units, #{@date.year_static}" />
<meta name="dc.creator" content="Ralph Amissah" />
<meta name="dc.subject" content= "document structuring, ebook, publishing, PDF, LaTeX, XML, ODF, EPUB, SQL, postgresql, sqlite, electronic book, electronic publishing, electronic document, electronic citation, data structure, citation systems, granular search, digital library" />
<meta name="dc.publisher" content= "SiSU http://www.sisudoc.org/" />
<meta name="dc.language" content="en" />
<meta name="dc.rights" content="Copyright Ralph Amissah" />
<meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
<link rel="generator" href="http://www.sisudoc.org/" />
<link rel="stylesheet" href="./#{@dir.path.style}/harvest.css" type="text/css" />
<link rel="shortcut icon" href="./_sisu/image/rb7.ico" />
</head>

<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>

<h1>SiSU</h1>
<p>
[<a href="http://sisudoc.org/sisu_manual/en/html/sisu/toc.html">Manual</a>]
</p>
<p>
[<a href="http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary">Source</a>]
[<a href="http://lists.sisudoc.org/listinfo/sisu">List Info (sisu@lists.sisudoc.org)</a>]
</p>

<h1>SiSU Markup Samples</h1>
<p>
[<a href="http://sources.sisudoc.org/gitweb/?p=doc/sisu-markup-samples.git;a=summary">Source</a>]
[<a href="http://sisudoc.org/sisu_markup_samples.html">Output</a>]
</p>

<hr />

<h2 class="top_band_tiny">
  Structured information, Serialized Units
  &nbsp;&nbsp;
  <a href="http://www.sisudoc.org" target="_top">
    &lt;www.sisudoc.org&gt;
  </a>
  &nbsp;&nbsp;or&nbsp;&nbsp;
  <a href="http://www.jus.uio.no/sisu/" target="_top">
    &lt;www.jus.uio.no/sisu/&gt;
  </a>
software for electronic texts, document collections, books, digital libraries &amp; search, with "atomic search" &amp; text locating system (shared object citation numbering: "<i>ocn</i>").
Outputs include: plaintext, HTML, EPUB, ODT (OpenDocumentText), (XHTML, XML,) LaTeX, PDF, SQL (PostgreSQL and SQLite).
</h2>
<p class="small">
<a href="mailto:sisu@lists.sisudoc.org">
&lt;sisu@lists.sisudoc.org&gt;
</a>
<a href="http://lists.sisudoc.org/listinfo/sisu">
&lt;http://lists.sisudoc.org/listinfo/sisu&gt;
</a>
</p>
<p class="small">
<a href="mailto:ralph@amissah.com">
&lt;ralph@amissah.com&gt;
</a>
<a href="mailto:ralph.amissah@gmail.com">
&lt;ralph.amissah@gmail.com&gt;
</a>
</p>
<p class="tiny">
#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!), #{@date.year_static}.
</p>
<p class="tiny">
w3 since October 3 1993.
</p>
</body>
</html>
WOK
    end
    def home_toc
      ' '
    end
  end
  class Inserts
  end
  class TeX < Defaults
    def initialize(papersize='')
      @papersize=papersize
    end
    def a4
      def portrait
        def w
          160
        end
        def h
          228
        end
        def img_px
          450
        end
        self
      end
      def landscape
        def w
          238
        end
        def h
          160
        end
        def img_px
          300
        end
        self
      end
      self
    end
    def letter
      def portrait
        def w
          166
        end
        def h
          212
        end
        def img_px
          468
        end
        self
      end
      def landscape
        def w
          226
        end
        def h
          166
        end
        def img_px
          290
        end
        self
      end
      self
    end
    def legal
      def portrait
        def w
          168
        end
        def h
          286
        end
        def img_px
          474
        end
        self
      end
      def landscape
        def w
          296
        end
        def h
          166
        end
        def img_px
          420
        end
        self
      end
      self
    end
    def b5
      def portrait
        def w
          140
        end
        def h
          204
        end
        def img_px
          356
        end
        self
      end
      def landscape
        def w
          200
        end
        def h
          130
        end
        def img_px
          260
        end
        self
      end
      self
    end
    def a5
      def portrait
        def w
          112
        end
        def h
          162
        end
        def img_px
          280
        end
        self
      end
      def landscape
        def w
          152
        end
        def h
          100
        end
        def img_px
          190
        end
        self
      end
      self
    end
    def dimensions
      case @papersize
      when /a4/     then a4
      when /letter/ then letter
      when /legal/  then legal
      when /b5/     then b5
      when /a5/     then a5
      else               a4
      end
    end
  end
end
__END__
