/*
    Copyright (c) 1996-2003 Maximum Entropy Data Consultants Ltd,
                            114c Milton Road, Cambridge CB4 1XE, England

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <err.h>

#define DIMS 3	/* number of dimensions in the Hilbert space */
#define BITS 5	/* number of bits used to store the axis values, size of Hilbert space */
#define MAX  (1 << BITS)

extern int hilbert_integer(uint8_t x, uint8_t y, uint8_t z);
extern void hilbert_inverse(uint32_t H, uint8_t *x, uint8_t *y, uint8_t *z);

int main(int argc, char **argv)
{
	uint32_t H;
	uint8_t x, y, z, xx, yy, zz;

	for (x = 0; x < MAX; x++)
		for (y = 0; y < MAX; y++)
			for (z = 0; z < MAX; z++) {
				H = hilbert_integer(x, y, z);
				printf("%2u %2u %2u => %6u\n", x, y, z, H);
				hilbert_inverse(H, &xx, &yy, &zz);
				if (xx != x || yy != y || zz != z)
					errx(1, "FAILED INVERSE");
			}
	warnx("PASS for %u cases", x * y * z);
	return EXIT_SUCCESS;
}
