/*
 * snmptest3.C: Test example program 1 for snmpkit
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later 
 * version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 */

#include <snmpkit>

#include <string.h>
#include <iostream.h>
#include <string>

const std::string HPSTR("JETDIRECT");
const std::string LEXMARKSTR("Lexmark");
const std::string TEKTRONIXSTR("Tektronix");
const std::string XEROXDC230STR("131;C1H011131;");
const std::string XEROXDC230STR2(";C1H017730;");
const std::string XEROXDC265STR("3UP060485");
const std::string XEROXSTR("Xerox");
const std::string QMSSTR("QMS");
const std::string IBMSTR("IBM");
const std::string EFISTR("EFI Fiery Color Printer Server");
const std::string EFISTR2("EFI Fiery Server ZX");
const std::string FUJISTR("Able Model-PRII");

const std::string SYSDESC("1.3.6.1.2.1.1.1.0");
const std::string HPINFO("1.3.6.1.4.1.11.2.3.9.1.1.7.0"); // undocumented
const std::string HRDEVICEDESC("1.3.6.1.2.1.25.3.2.1.3.1");
const std::string TKMODEL("1.3.6.1.4.1.128.2.1.3.1.2.0");

class PrinterException{};

struct PrinterInfo{
  std::string vendor;
  std::string model;

  std::string sysDesc;
  char *info;
};

void printer_info_insert_sysDesc(void *dest_ptr,const char *str){
  PrinterInfo *dest=reinterpret_cast<PrinterInfo*>(dest_ptr);
  dest->sysDesc=str;
}

void printer_info_insert_info(void *dest_ptr,const char *str){
  PrinterInfo *dest=reinterpret_cast<PrinterInfo*>(dest_ptr);
  dest->info=strdup(str);
}

void *do_req(SNMP_session *printer){
  PrinterInfo prinfo;
  try{
    printer->setDebug();
    SNMP_structFiller table(*printer);
    table.append_string(SYSDESC,printer_info_insert_sysDesc);
    table.get(&prinfo);
    table.remove(SYSDESC); /* ITS4: ignore */

    /* ------- HP ------- */
    if(prinfo.sysDesc.find(HPSTR)!=std::string::npos){
      prinfo.vendor="HP";
      table.append_string(HPINFO,printer_info_insert_info);
      table.get(&prinfo);
      char *model_begin=strstr(prinfo.info,"MODEL:");
      if(model_begin!=NULL){
	model_begin+=6;
	if(!strncmp(model_begin,"HP ",3))
	  model_begin+=3;
      }else if((model_begin=strstr(prinfo.info,"MDL:"))!=NULL)
	model_begin+=4;
      else
	throw PrinterException();
      char *end=strchr(model_begin,';');
      if(end==NULL)
	end=model_begin+strlen(model_begin);
      prinfo.model=std::string(model_begin,end-model_begin);
    /* ------- Lexmark ------- */
    }else if(prinfo.sysDesc.compare(LEXMARKSTR)){
      prinfo.vendor="Lexmark";
      prinfo.model=prinfo.sysDesc.substr(8,prinfo.sysDesc.find("  "));
    /* ------- Tektronix ------- */
    }else if(prinfo.sysDesc.compare(XEROXSTR)){
      prinfo.vendor="Xerox";
      if(prinfo.sysDesc.find("???")!=std::string::npos)
	prinfo.model="???";
      else
	prinfo.model=prinfo.sysDesc.substr(prinfo.sysDesc.find(' ')+1);      
    }else if(prinfo.sysDesc.compare(TEKTRONIXSTR)){
      prinfo.vendor="Tektronix";
      table.append_string(HRDEVICEDESC,printer_info_insert_info);
      try{
	table.get(&prinfo);
      }catch(SNMPBadOidException e){
	table.remove(HRDEVICEDESC); /* ITS4: ignore */
	table.append_string(TKMODEL,printer_info_insert_info);
	table.get(&prinfo);
      }
      char *begin=strstr(prinfo.info,"Inc., ");
      if(begin){
	begin+=6;
	prinfo.model=std::string(begin,strchr(begin,',')-begin);
      }else
	throw PrinterException();
    /* ------- Xerox Desktop ------- */
    }else if(prinfo.sysDesc.compare(XEROXDC230STR) || 
	     prinfo.sysDesc.compare(XEROXDC230STR2)){
      prinfo.vendor="Xerox";
      prinfo.model="Document Centre 230ST";
    }else if(prinfo.sysDesc.compare(XEROXDC265STR)){
      prinfo.vendor="Xerox";
      prinfo.model="Document Centre 265";
    }else if(prinfo.sysDesc.compare(EFISTR) || 
	     prinfo.sysDesc.find(EFISTR2,EFISTR2.length())){
      prinfo.vendor="EFI";
      prinfo.model="???";
    }else if(prinfo.sysDesc.compare(QMSSTR)){
      prinfo.vendor="QMS";
      prinfo.model=prinfo.sysDesc.substr(4);
    }else if(prinfo.sysDesc.compare(IBMSTR)){
      prinfo.vendor="IBM";
      prinfo.model=prinfo.sysDesc.substr(4);
    }else if(prinfo.sysDesc.compare(FUJISTR)){
      prinfo.vendor="Fuji";
      prinfo.model="Able PRII";
    }else
      return NULL;
    cout << "printer=" << printer->Hostname() << ";vendor=" << prinfo.vendor
	 << "model=" << prinfo.model << endl;
      
    return NULL;
  }catch(SNMPNoResponseException e){ // this is not a problem
    return NULL;
  }catch(ProgrammerException e){
    cerr << "inside programmer error\n";
  }catch(DecodeException e){
    cerr << "inside decode error\n";
  }catch(SNMPException e){
    cerr << "inside SNMPException\n";
  }catch(...){
    cerr << "inside other error\n";
  }
  int *i=new int;
  *i=1;
  return i;
}

int main(int argc,char **argv){
  if(argc!=2)
    exit(2);
  set_snmpsock_props(5,2);
  std::list<SNMP_session*> sessions;
  try{
    std::string hostspec(argv[1]);
    SNMP_sessions(sessions,hostspec,do_req);
    SNMP_sessions_done();
  }catch(ProgrammerException e){
    cerr << "programmer error\n";
  }catch(DecodeException e){
    cerr << "decode error\n";
  }catch(...){
    cerr << "other error\n";
  }
  exit(1);
}  

