/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  mod_sql.h: Comman data structures for all SQL modules
 */

#ifndef MOD_SQL_H
#define MOD_SQL_H

#include "spl.h"

typedef struct spl_node *sql_query_callback(struct spl_task *task, void *backend_data, const char *query);
typedef void sql_close_callback(struct spl_vm *vm, void *backend_data);

struct sql_hnode_data {
	void *backend_data;
	sql_query_callback *query_callback;
	sql_close_callback *close_callback;
};

typedef void sql_open_callback(struct spl_task *task, struct spl_node *node, const char *data);

struct sql_backend {
	struct sql_backend *next;
	sql_open_callback *open_callback;
	const char *name;
};

static inline void sql_register_backend(struct spl_vm *vm, const char *name, sql_open_callback *open_callback)
{
	struct sql_backend *b = malloc(sizeof(struct sql_backend));

	b->name = name;
	b->open_callback = open_callback;

	b->next = vm->sql_backends;
	vm->sql_backends = b;
}

static inline void sql_unregister_backend(struct spl_vm *vm, const char *name)
{
	struct sql_backend **l = &vm->sql_backends;
	struct sql_backend *b = vm->sql_backends;

	while (b) {
		if (!strcmp(b->name, name)) {
			*l = b->next;
			free(b);
			return;
		}

		l = &b->next;
		b = b->next;
	}
}

#endif

