use json;
use test;

class Employee : jsonSerializable {
	Str name;
	Nat salary = 500;
	Str? speciality;

	init(Str name, Nat salary, Str? skill) {
		init {
			name = name;
			salary = salary;
			speciality = skill;
		}
	}
}

class Manager : extends Employee, jsonSerializable {
	Str lastReview;

	init(Str name, Nat salary, Str? skill, Str review) {
		init(name, salary, skill) {
			lastReview = review;
		}
	}
}

class Office : jsonSerializable {
	Manager manager;
	Employee[] employees;
	Str->Nat rooms;
	JsonValue raw;

	init(Manager m) {
		init {
			manager = m;
		}
	}
}

test ClassToJson {
	Office office(Manager("A", 1000, null, "no"));
	office.employees << Employee("B", 500, null);
	office.employees << Employee("C", 1000, "expert");
	office.rooms.put("A", 20);
	office.rooms.put("B", 18);
	office.rooms.put("C", 10);
	office.raw = json[1, "2", 3.1];

	var ref = json{
		"manager": {
			"name": "A",
			"salary": 1000,
			"speciality": null,
			"lastReview": "no"
		},
		"rooms": {
			"A": 20,
			"B": 18,
			"C": 10
		},
		"employees": [{
				"name": "B",
				"salary": 500,
				"speciality": null
			}, {
				"name": "C",
				"salary": 1000,
				"speciality": "expert"
			}],
		"raw": [1, "2", 3.1]
	};

	check ref == office.toJson();

	// var y = 10.X;
}

test JsonToClass {
	var data = json{
		"manager": {
			"name": "A",
			"salary": 1000,
			"speciality": null,
			"lastReview": "no"
		},
		"rooms": {
			"A": 20,
			"B": 18,
			"C": 10
		},
		"employees": [{
				"name": "B",
				"speciality": null
			}, {
				"name": "C",
				"salary": 1000,
				"speciality": "expert"
			}],
		"raw": [1, "2", 3.1]
	};

	// Yes, this works.
	var original = data.Office;

	// Add back the defaulted value so that we can compare.
	data["employees"][0]["salary"] = 500;
	check data == original.toJson();
}
