use lang:bnf;
use lang:bs;
use core:lang;

class BsProductionDecl extends ProductionDecl {
	init(SrcPos pos, Name memberOf, Name? parent, SBlock body) {
		init(pos, memberOf, parent) {
			body = body;
		}
	}

	// The body of the production.
	SBlock body;

	// Custom creation.
	ProductionType create(Package into, Delimiters delimiters, Scope scope) : override {
		for (t in tokens) {
			if (t.invoke.any)
				throw SyntaxError(pos, "It is not possible to use the -> syntax together with code.");
			if (t.raw)
				throw SyntaxError(pos, "Tokens are always captured in raw form with code.");
		}

		var safeName = if (name) {
			name;
		} else {
			into.anonName;
		};
		BsProductionType(safeName, this, delimiters, scope);
	}
}

class BsProductionType extends ProductionType {
	init(Str name, BsProductionDecl decl, Delimiters delim, Scope scope) {
		init(name, decl, delim, scope) {
			body = decl.body;
		}
	}

	// Body of the production.
	SBlock body;

	// Load everything.
	protected void loadFunctions(ProductionDecl decl, Scope scope) : override {
		// Add the 'children' function.
		add(createChildrenFn(decl, this, scope));

		// Add the 'transform' function.
		ValParam[] params = rule.params().clone();
		params.insert(0, thisParam(this));

		BSLookup lookup;
		if (extraLookup = scope.lookup as ScopeExtra) {
			for (x in extraLookup.extra) {
				if (x as Package) {
					lookup.addInclude(x, false);
				}
			}
		}

		BSTreeFn newTransform(rule.result, SStr("transform"), params, null);
		FnBody fnBody(newTransform, Scope(this, lookup));
		fnBody.add(body.transform(fnBody));
		newTransform.body = fnBody;

		add(newTransform);
	}
}
