/**
 * IAU 2000 R06 nutation terms in longitude, derived from the IAU 2000A lunisolar and planetary
 * components with slight IAU 2006 adjustments.
 *
 * Extracted from https://iers-conventions.obspm.fr/content/chapter5/additional_info/tab5.3a.txt
 *
 * This file a C source code snippet, which should be included in 'nutation.c' after the
 * definition of the 'nutation_terms' data structure.
 *
 * @version IERS Conventions v1.3.0
 */

static const nutation_terms A0[1320] = { //
        { -1720642418,      333860, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {  -131709122,     -136960, {   0,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {   -22764181,       27960, {   0,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {    20745540,       -6980, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {    14758770,      118170, {   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {     7111590,       -8720, {   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {    -5168210,       -5240, {   0,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {    -3873020,        3800, {   0,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {    -3014640,        8160, {   1,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {    -2158290,        1110, {   0,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {    -1569980,       -1680, {   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {     1282270,        1810, {   0,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {    -1234570,         190, {   1,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      633790,       -1500, {   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {      631100,         270, {   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      596450,        1490, {   1,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      579760,       -1890, {   1,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {     -516130,        1290, {   1,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      477220,        -180, {   2,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {     -458930,         310, {   2,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {     -385660,        1580, {   0,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {     -324810,           0, {   0,   2,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {     -310460,        1310, {   2,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      292430,        -740, {   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {      285930,         -10, {   1,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      258870,        -660, {   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  3 }, //
        {     -217830,         130, {   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {     -204410,         100, {   1,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      167070,        -100, {   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {     -157940,        -160, {   0,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {     -151640,         110, {   1,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {     -140530,         790, {   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {     -128730,        -370, {   1,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      126540,         630, {   0,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      110240,        -140, {   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {      102040,         250, {   1,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -30840,       51230, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -2,   5,   0,   0,   0 },  2, 11 }, //
        {      -76870,         440, {   1,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       75660,        -110, {   0,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -73500,         -80, {   1,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       71410,          80, {   0,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -66370,         250, {   0,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       65750,        -240, {   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       64430,         -70, {   2,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -63020,          20, {   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {       58000,          20, {   1,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       57740,        -150, {   2,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -53500,         210, {   2,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       49400,        -210, {   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {       47520,         -30, {   0,   1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       47250,         -60, {   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {      -40260,       -3530, {   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {      -43480,        -100, {   0,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {      -42300,          50, {   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {       40650,          60, {   2,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       40560,          50, {   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {       14440,       24090, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,  -1 },  9, 14 }, //
        {       35790,          50, {   0,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -33890,          50, {   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {       33390,        -130, {   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {      -32760,          10, {   1,  -1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       30710,         -20, {   2,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -29010,         150, {   3,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -28780,          80, {   1,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       28190,          70, {   1,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       26470,         110, {   0,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       24810,         -70, {   1,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       22940,        -100, {   2,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       21790,         -20, {   2,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -4620,       16040, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  7, 10 }, //
        {       20650,           0, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {       19870,         -60, {   1,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,      -19880, {   0,   1,  -1,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -19810,           0, {   1,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       12000,        5980, {   0,   0,   1,  -1,   1,   0,  -8,  12,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {       16600,         -50, {   0,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       15750,         -60, {   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {       15210,          90, {   1,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       14850,           0, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {       14400,           0, {   0,   0,   0,   0,   0,   0,   0,   8, -16,   4,   5,   0,   0,   0 },  7, 11 }, //
        {      -14050,          40, {   1,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -13780,         -20, {   2,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -13380,         -50, {   1,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {      -13310,          80, {   1,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -13140,           0, {   1,  -1,   0,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       12900,           0, {   1,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -12820,         -30, {   2,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       12830,           0, {   0,   2,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -12230,        -290, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  7, 10 }, //
        {       12480,           0, {   0,   0,   2,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       12140,          50, {   2,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -11660,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   2 },  9, 14 }, //
        {      -11460,         -30, {   1,   0,  -4,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -11000,          90, {   2,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {      -10200,        -250, {   1,   0,   0,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,      -10440, {   1,   0,  -1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       10190,         -10, {   2,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       10140,         -10, {   2,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -9700,          20, {   1,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        9490,          10, {   1,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        9340,         -30, {   3,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        9220,         -10, {   0,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -4600,       -4350, {   0,   0,   0,   0,   1,   0,   0,  -1,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {       -4490,        4300, {   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0 },  7,  9 }, //
        {       -8750,          10, {   0,   1,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {       -8340,          20, {   0,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        8150,         -10, {   0,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -7660,          10, {   1,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -7420,          10, {   1,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        7150,         -40, {   0,   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        7160,         -20, {   2,   0,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -7040,           0, {   0,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -6940,          50, {   0,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -6730,          20, {   0,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        6660,         -30, {   0,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        6670,          10, {   0,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -6580,           0, {   0,   1,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {       -6390,         -20, {   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -4250,        2120, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          80,        6140, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {       -4910,        1280, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0 },  9, 11 }, //
        {       -5980,           0, {   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        5950,           0, {   1,  -1,   0,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -5900,          40, {   1,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -5910,           0, {   0,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        5880,         -30, {   2,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -5850,         -20, {   1,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -5780,          10, {   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -5700,         -20, {   1,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2350,        3340, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        5650,         -10, {   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        1230,       -4160, {   0,   0,   0,   0,   0,   0,   0,   2,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {        1230,       -4150, {   0,   0,   0,   0,   0,   0,   0,   6,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {        5350,         -20, {   0,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        5170,         160, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {        5280,           0, {   1,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         310,       -4810, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   2,  -5,   0,   0,   0 },  2, 11 }, //
        {       -5020,          30, {   3,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        4940,         -20, {   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {        4920,         -30, {   1,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        4930,         -20, {   1,  -1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -4880,          20, {   2,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -4900,           0, {   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        4670,          10, {   1,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -4680,           0, {   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {       -4630,           0, {   1,  -1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        4580,           0, {   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {       -4530,         -10, {   1,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -180,       -4360, {   0,   0,   2,  -2,   1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        4460,          20, {   0,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        4390,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {       -4380,           0, {   0,   3,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -1660,        2690, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -2,   0,   0,   0,   0 },  7, 10 }, //
        {        4130,         130, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  7, 10 }, //
        {       -4210,          10, {   1,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        4160,         -20, {   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {        4120,         -20, {   2,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        3490,        -620, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {        3960,           0, {   1,   0,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -3900,           0, {   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         840,        2980, {   0,   0,   0,   0,   1,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  4, 10 }, //
        {        3700,         -80, {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {        3750,         -10, {   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {        -820,        2920, {   0,   0,   0,   0,   1,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  4, 10 }, //
        {       -3680,           0, {   0,   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0 },  7,  9 }, //
        {           0,        3640, {   1,   0,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        3600,         -10, {   1,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -3610,           0, {   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -3570,          10, {   1,   0,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2730,         800, {   0,   0,   1,  -1,   1,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {       -2660,        -780, {   0,   0,   1,  -1,   0,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {       -3390,           0, {   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {        -910,        2480, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0 },  9, 10 }, //
        {        3370,         -10, {   1,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        3350,         -20, {   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {       -3350,         -10, {   0,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -3340,           0, {   1,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,        3280, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,        3300, {   1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {       -2260,        1010, {   1,   0,   0,   0,   0,   0, -18,  16,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {       -3250,          10, {   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         510,        2720, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   1 },  9, 14 }, //
        {       -3210,          10, {   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        3090,          10, {   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2190,         890, {   1,   0,   0,   0,   0,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        3010,         -10, {   1,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2860,          10, {   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {       -2840,           0, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {        2800,         -10, {   0,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -2760,           0, {   1,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        2760,           0, {   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {         110,       -2610, {   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        2630,          20, {   1,   0,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2620,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {       -2590,          20, {   4,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1740,         840, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,  -1,   0,   0,   0 },  2, 11 }, //
        {        2530,          10, {   1,   0,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2520,           0, {   2,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2450,          10, {   0,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        2450,           0, {   1,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2430,         -10, {   1,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -500,        1940, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {         100,        2330, {   0,   0,   2,  -2,   0,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        -860,        1530, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         140,       -2180, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   1 },  9, 14 }, //
        {       -2310,           0, {   2,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2290,           0, {   1,   0,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        2280,           0, {   2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -2190,           0, {   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {         410,        1750, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {       -2130,           0, {   0,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        2080,          10, {   2,   0,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2080,          10, {   1,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2020,           0, {   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        1990,           0, {   0,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -1970,         -10, {   1,   0,  -4,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1920,          20, {   2,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1310,        -630, {   1,   0,   2,   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {       -1450,         470, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        1260,        -630, {   1,   0,  -2,   0,  -2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {       -1880,           0, {   0,   0,   2,  -3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        1860,         -10, {   0,   0,   4,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        1590,        -280, {   1,   0,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1870,           0, {   1,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1840,         -30, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {       -1540,        -300, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {          50,       -1730, {   0,   0,   0,   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {       -1750,           0, {   2,   0,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1740,          10, {   1,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1630,        -120, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {         620,       -1120, {   0,   0,   0,   0,   0,   0,   8, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -560,       -1170, {   0,   0,   0,   0,   0,   0,   0,   8, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {        -270,       -1430, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {        1250,        -430, {   0,   0,   0,   0,   0,   0,   0,   8, -16,   4,   5,   0,   0,   2 },  7, 14 }, //
        {        1400,         270, {   0,   0,   1,  -1,   1,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {       -1630,          20, {   1,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         510,        1140, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   1 }, 10, 14 }, //
        {        1030,        -600, {   1,   0,   0,  -2,   0,   0,  19, -21,   3,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,       -1620, {   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -1610,           0, {   3,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        1590,           0, {   1,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -480,       -1100, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {         670,        -910, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {        -610,        -960, {   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        1560,           0, {   0,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -1540,          10, {   0,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        -850,        -700, {   0,   0,   0,   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {       -1530,         -10, {   0,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -1510,         -10, {   1,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         800,        -710, {   0,   0,   0,   0,   0,   0,   0,   3,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {       -1270,         210, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   2 },  9, 14 }, //
        {        1470,           0, {   3,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1430,         -30, {   0,   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        1440,         -10, {   1,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1410,           0, {   0,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        1380,           0, {   2,   0,   0,  -2,   0,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {       -1340,          10, {   3,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1330,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   2 }, 10, 14 }, //
        {        1320,           0, {   2,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         250,        1060, {   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,        1310, {   1,   0,   0,  -1,   0,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -250,        1060, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        1290,          10, {   0,   2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        1280,           0, {   0,   0,   2,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -1230,           0, {   2,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -780,         450, {   0,   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0 },  7,  9 }, //
        {       -1210,          10, {   0,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -1200,           0, {   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        1180,         -10, {   3,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1180,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,  -2 },  7, 14 }, //
        {        1170,           0, {   0,   0,   2,  -2,   1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {       -1170,           0, {   0,   0,   0,   0,   0,   0,   6,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {       -1150,           0, {   2,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        1130,         -10, {   4,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1140,           0, {   2,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1140,           0, {   0,   0,   1,  -1,   1,   0,   0,   3,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,       -1140, {   0,   0,   0,   0,   0,   0,   3,  -2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,       -1140, {   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        1130,           0, {   1,  -1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1130,           0, {   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         460,         660, {   0,   0,   0,   0,   1,   0,   8, -13,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {        1100,           0, {   2,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         220,        -870, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -680,         390, {   0,   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0 },  7,  9 }, //
        {       -1030,         -30, {   1,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -1060,           0, {   0,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         890,        -160, {   2,   0,   0,  -2,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {        1050,           0, {   1,  -1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -880,         170, {   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        1040,           0, {   1,   2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1030,           0, {   1,   0,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {       -1020,           0, {   2,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1020,           0, {   2,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         680,        -340, {   1,   0,   0,   0,  -1,   0, -18,  16,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        1010,           0, {   2,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1000,         -10, {   1,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1000,          10, {   1,  -1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         990,           0, {   0,   0,   1,  -1,   1,   0,   0,  -5,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {         210,        -780, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {         830,         150, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -3,   0,   0,   0,   0 },  7, 10 }, //
        {        -920,         -50, {   2,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -400,         570, {   0,   0,   0,   0,   1,   0,  -8,  13,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {        -780,        -180, {   2,   0,   0,  -2,   0,   0,  -6,   8,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -960,           0, {   1,  -1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -910,         -40, {   2,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         940,           0, {   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {        -940,           0, {   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -940,           0, {   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        -940,           0, {   0,   1,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         930,           0, {   1,   0,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         830,         100, {   0,   2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -920,          10, {   2,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         920,          10, {   0,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         760,         170, {   0,   0,   0,   0,   1,   0,   0,   0,   0,  -2,   5,   0,   0,   0 },  4, 11 }, //
        {        -910,           0, {   2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -910,           0, {   1,   0,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -730,         170, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   2,  -5,   0,   0,   0 },  4, 11 }, //
        {         200,        -700, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {         890,           0, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -890,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        -880,           0, {   2,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         870,           0, {   0,   2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -860, {   0,   0,   0,   0,   0,   0,   0,   6, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {         570,        -280, {   1,   0,   0,   0,   1,   0, -18,  16,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         850,           0, {   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {        -840,           0, {   1,  -1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         840,           0, {   0,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         830,           0, {   3,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         830,           0, {   1,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -830,           0, {   1,   0,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         830,           0, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -350,        -480, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   2,   0,   0,   0,   2 },  7, 14 }, //
        {         820,           0, {   2,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -820,           0, {   2,  -1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         810,         -10, {   1,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         820,           0, {   1,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         790,           0, {   2,   0,  -4,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         630,        -160, {   0,   0,   0,   0,   0,   0,   3,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         780,           0, {   3,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -660,        -120, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   1,   0,   0,   0 },  2, 11 }, //
        {         770,           0, {   2,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -770,           0, {   2,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         740,         -30, {   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         750,           0, {   1,   0,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         750, {   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  3 }, //
        {        -750,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,  -1,   0,   0,   0 },  7, 11 }, //
        {         520,         230, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   2 },  9, 14 }, //
        {         740,           0, {   0,   2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -740,           0, {   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -740,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   2 },  8, 14 }, //
        {        -140,        -590, {   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        -730,           0, {   1,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -370,         350, {   0,   0,   0,   0,   1,   0,   0,   1,  -2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         710,           0, {   1,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -690,           0, {   2,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         540,        -150, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -30,         660, {   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -680,           0, {   1,   1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -120,         550, {   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         450,        -220, {   0,   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         110,         560, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0 }, 10, 11 }, //
        {        -650,           0, {   0,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {         130,         520, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,  -1 },  9, 14 }, //
        {         640,           0, {   2,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -280,         360, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,   0 },  7, 10 }, //
        {        -630,           0, {   3,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -630,           0, {   2,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         630,           0, {   1,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -630, {   1,   0,  -1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         530,         -90, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         620,           0, {   1,  -1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         420,         200, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   0,  -1,   0,   0,   0 },  2, 11 }, //
        {        -610,           0, {   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         610,           0, {   0,   2,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         600,           0, {   2,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -600,           0, {   1,   0,   2,  -3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -460,         140, {   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -110,        -490, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          60,         540, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1 },  9, 14 }, //
        {         590,           0, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         570,           0, {   1,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -560,           0, {   2,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -260,        -290, {   1,   0,   0,  -1,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {         -80,        -470, {   0,   0,   1,  -1,   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         470,          80, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1 }, 10, 14 }, //
        {         540,           0, {   2,   0,   0,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {        -200,         340, {   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0 },  7,  9 }, //
        {        -210,        -320, {   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   2 },  8, 14 }, //
        {         530,           0, {   3,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -530,           0, {   1,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         530,           0, {   1,   0,   0,  -1,   0,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  0, 10 }, //
        {         -60,        -470, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {        -500,          30, {   0,   0,   0,   0,   0,   0,   8, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -140,        -390, {   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         -60,         470, {   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {         510,           0, {   2,   0,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         510,           0, {   2,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -510,           0, {   1,  -2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         510,           0, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         500,           0, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {        -100,         400, {   0,   0,   1,  -1,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         490,           0, {   3,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         490,           0, {   0,   1,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         480,           0, {   0,   1,   2,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         480,           0, {   0,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         300,        -180, {   0,   0,   0,   0,   0,   0,   0,   5,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         470,           0, {   2,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         470,           0, {   2,  -1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         470,           0, {   1,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -470,           0, {   1,   1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         180,        -290, {   0,   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        -250,         220, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0 },  9, 10 }, //
        {        -320,         150, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,  -1 }, 10, 14 }, //
        {        -460,           0, {   2,   0,  -4,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -450,           0, {   4,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         450,           0, {   1,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -450,           0, {   1,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -450,           0, {   0,   1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         450,           0, {   0,   0,   4,  -4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -450, {   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -440,           0, {   3,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         440,           0, {   2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {        -440,           0, {   0,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -370,         -70, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {         430,           0, {   2,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -430,           0, {   1,   0,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          80,         350, {   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          70,        -360, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   1 },  7, 14 }, //
        {        -130,        -300, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   2,  -5,   0,   0,   0 },  7, 11 }, //
        {         420,           0, {   2,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -420,           0, {   0,   1,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -350,         -70, {   0,   0,   1,  -1,   0,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -80,         340, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         190,        -230, {   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         410,           0, {   2,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -400,           0, {   1,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         400,           0, {   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         260,        -140, {   0,   0,   0,   0,   0,   0,   0,   4,  -3,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -70,        -320, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -80,        -310, {   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         390,           0, {   1,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -390,           0, {   1,  -1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -160,         230, {   0,   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         380,           0, {   2,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -380,           0, {   2,  -1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         380,           0, {   2,  -2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -380,           0, {   1,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         370,           0, {   2,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         150,         220, {   2,   0,   0,  -2,   0,   0,   0,  -6,   8,   0,   0,   0,   0,   0 },  0,  9 }, //
        {        -370,           0, {   1,  -1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         370,           0, {   0,   0,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         310,         -60, {   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         240,        -130, {   0,   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         360,           0, {   1,   1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -360,           0, {   1,   0,  -2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         360,           0, {   1,  -1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         360,           0, {   0,   1,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          90,        -270, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -4,  10,   0,   0,   0 },  2, 11 }, //
        {        -300,         -60, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,  -2 },  7, 14 }, //
        {         240,        -120, {   2,   0,   2,   0,   2,   0,   0,   2,   0,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {         240,         120, {   2,   0,   0,  -2,   0,   0,   0,  -5,   6,   0,   0,   0,   0,   0 },  0,  9 }, //
        {        -240,        -120, {   0,   0,   2,   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        -170,        -190, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   0,   2,   0 },  2, 13 }, //
        {         260,         -90, {   2,   0,  -1,  -1,   0,   0,   0,   3,  -7,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         350,           0, {   2,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -350,           0, {   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {        -350,           0, {   1,  -2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         110,         240, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {         -70,         280, {   0,   0,   1,  -1,   1,   0,  -4,   5,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         350,           0, {   0,   0,   0,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -30,        -320, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         350, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -1,   0,   0,   0,   0 },  7, 10 }, //
        {         140,         210, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {          80,        -270, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {        -110,        -240, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,  -2 },  9, 14 }, //
        {         220,         120, {   0,   0,   0,   0,   0,   0,   0,   1,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {         340,           0, {   1,   0,   0,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         340,           0, {   1,   0,   0,  -2,   0,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {        -340,           0, {   1,  -1,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -340,           0, {   0,   0,   0,   0,   0,   0,   9, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         330,           0, {   1,   0,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -330,           0, {   0,   1,  -2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -300,         -30, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         320,           0, {   3,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -320,           0, {   2,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -210,         110, {   2,   0,   0,   0,   0,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         320,           0, {   1,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         210,        -110, {   1,   0,   2,   0,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {        -320,           0, {   1,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         210,        -110, {   1,   0,  -2,   0,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         320,           0, {   1,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -320,           0, {   1,   0,  -4,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         320,           0, {   0,   0,   4,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         100,        -220, {   0,   0,   2,  -2,   1,   0,   0,  -9,  13,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,        -320, {   0,   0,   0,   0,   1,   0,   2,  -3,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {        -110,        -210, {   0,   0,   0,   0,   1,   0,   0,  -2,   4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -40,        -280, {   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0 },  6,  7 }, //
        {        -310,           0, {   1,  -1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -310,           0, {   1,  -2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         310,           0, {   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {         310,           0, {   0,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         310, {   0,   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -30,         280, {   0,   0,   1,   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         300,           0, {   3,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         300,           0, {   1,   1,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         300,           0, {   1,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         300, {   0,   0,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -60,         240, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        -190,        -110, {   0,   0,   0,   0,   0,   0,   0,   3,  -8,   3,   0,   0,   0,   0 },  7, 10 }, //
        {         230,          70, {   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   1 },  7, 14 }, //
        {         290,           0, {   3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {        -290,           0, {   2,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         290,           0, {   2,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         290,           0, {   2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {        -290,           0, {   1,   1,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -290,           0, {   1,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         290, {   1,   0,   0,  -1,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -240,          50, {   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         290,           0, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,  -1,   0,   0,   2 },  7, 14 }, //
        {          60,         230, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   1 },  9, 14 }, //
        {        -280,           0, {   2,   0,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -280,           0, {   1,   2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -280,           0, {   1,   1,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -280,           0, {   1,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -280,           0, {   0,   1,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -280,           0, {   0,   0,   0,   0,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          40,         240, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0 },  4, 11 }, //
        {         280,           0, {   0,   0,   0,   0,   0,   0,   7,  -7,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          50,        -230, {   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {        -180,        -100, {   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   2 },  8, 14 }, //
        {        -270,           0, {   2,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         270,           0, {   2,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -270,           0, {   0,   1,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {         270,           0, {   0,   0,   2,  -2,   1,   0,  -4,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         270,           0, {   0,   0,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -210,         -60, {   0,   0,   0,   0,   1,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,        -270, {   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         270,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         190,         -80, {   0,   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {        -260,           0, {   3,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -260,           0, {   3,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         260,           0, {   2,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -260, {   0,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          50,         210, {   0,   0,   1,  -1,   1,   0,  -1,   0,   0,   0,   0,   0,   0,   0 },  2,  7 }, //
        {         -60,         200, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,  -2,   0,   0,   0 },  7, 11 }, //
        {        -250,           0, {   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         250,           0, {   1,  -2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          90,        -160, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,  -2,   5,   0,   0,   0 },  2, 11 }, //
        {          60,         190, {   0,   0,   0,   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -250,           0, {   0,   0,   0,   0,   0,   0,   0,   7,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {        -160,          90, {   0,   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -40,         210, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   1 },  7, 14 }, //
        {        -250,           0, {   0,   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         160,          80, {   1,   0,   0,  -1,   0,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {        -240,           0, {   3,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -240,           0, {   3,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         240,           0, {   1,   0,   4,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -240,           0, {   1,  -1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -240,           0, {   1,  -1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         240, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,  -1,   1,   0,   0,   0 },  2, 11 }, //
        {           0,        -240, {   0,   0,   0,   0,   0,   0,   7, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          50,         190, {   0,   0,   0,   0,   0,   0,   6,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         210,          30, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   3,   0,   0,   0,   0 },  7, 10 }, //
        {        -230,           0, {   5,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -230,           0, {   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {         230,           0, {   3,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -230,           0, {   2,   0,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         230,           0, {   1,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         230,           0, {   1,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         230, {   1,   0,   0,  -1,  -1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         100,         130, {   1,  -2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         110,        -120, {   0,   0,   1,  -1,   1,   0,   8, -14,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -90,        -140, {   0,   0,   1,  -1,   1,   0,   3,  -6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        -140,          90, {   0,   0,   0,   0,   0,   0,   3,  -9,   4,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -220,           0, {   2,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -220,           0, {   1,   2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         220,           0, {   1,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         220,           0, {   1,  -1,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         220,           0, {   1,  -1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         220,           0, {   0,   2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          90,        -130, {   0,   0,   1,  -1,   1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         150,         -70, {   0,   0,   0,   0,   1,   0,   0,   8, -15,   0,   0,   0,   0,   0 },  4,  9 }, //
        {        -130,          90, {   0,   0,   0,   0,   0,   0,   3,  -5,   4,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         140,          80, {   0,   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         130,          90, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         160,         -60, {   0,   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0 },  7,  9 }, //
        {           0,         220, {   0,   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,   0 },  7,  9 }, //
        {        -170,         -40, {   2,   0,   0,  -2,   1,   0,  -6,   8,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -210,           0, {   2,   0,  -2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         210,           0, {   1,   2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         210,           0, {   0,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         210,           0, {   0,   1,  -2,   2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -40,         170, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         160,         -50, {   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          40,         170, {   0,   0,   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         180,         -30, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -3,   0,   0,   0,   0 },  7, 10 }, //
        {         140,          70, {   0,   0,   1,  -1,   0,   0,  -8,  12,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        -200,           0, {   4,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         200,           0, {   2,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -200,           0, {   2,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         200,           0, {   1,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -200,           0, {   0,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  3 }, //
        {         170,         -30, {   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          70,         130, {   0,   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -80,         120, {   0,   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          90,        -110, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -200, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -1,   0,   0,   2 },  7, 14 }, //
        {         -90,        -110, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   1 }, 12, 14 }, //
        {          30,         160, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {         160,         -30, {   0,   0,   0,   0,   0,   0,   7, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          80,         110, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0 },  7, 10 }, //
        {        -190,           0, {   3,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         190,           0, {   2,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -190,           0, {   2,  -1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -190,           0, {   1,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {        -190,           0, {   1,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         190,           0, {   1,   0,   0,  -2,   0,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         190,           0, {   1,   0,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         190, {   0,   0,   1,  -1,   1,   0,   0,  -9,  15,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          40,         150, {   0,   0,   0,   0,   1,   0,   0,   0,   0,  -1,   0,   0,   0,   0 },  4, 10 }, //
        {        -190,           0, {   0,   0,   0,   0,   1,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,         190, {   0,   0,   0,   0,   1,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         190,           0, {   0,   0,   0,   0,   0,   0,   8,  -8,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          40,        -150, {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          70,        -120, {   0,   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         190,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -190, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   1,   0,   0,   2 },  7, 14 }, //
        {         180,           0, {   4,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -180,           0, {   3,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -180,           0, {   1,  -1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         180,           0, {   1,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {        -180,           0, {   0,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -180,           0, {   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {         180,           0, {   0,   0,   1,  -1,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         120,         -60, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   5,   0,   0,   2 },  7, 14 }, //
        {        -110,         -60, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   2,  -5,   0,   0,   2 },  7, 14 }, //
        {        -170,           0, {   1,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         170,           0, {   1,   0,  -2,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -170,           0, {   1,   0,  -2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -170,           0, {   0,   2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        -170,           0, {   0,   2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         170,           0, {   0,   1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         170,           0, {   0,   1,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         140,         -30, {   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          50,         120, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   2,  -5,   0,   0,   2 },  7, 14 }, //
        {        -170,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {        -170,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -4,   0,   0,   0,  -2 },  7, 14 }, //
        {         160,           0, {   3,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         160,           0, {   2,   0,   0,  -2,   1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -160,           0, {   2,   0,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -160,           0, {   2,  -1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -160,           0, {   1,   0,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -160,           0, {   1,   0,  -2,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -160,           0, {   1,   0,  -2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         160,           0, {   0,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         160,           0, {   0,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         100,         -60, {   0,   0,   0,   0,   1,   0,   3,  -7,   4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -30,         130, {   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -30,        -130, {   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -50,        -110, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -110,          50, {   0,   0,   0,   0,   0,   0,   0,  11,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        -110,          50, {   0,   0,   0,   0,   0,   0,   0,   6, -15,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          60,        -100, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -50,        -110, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {         -40,        -120, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -2,   0,   0,   0,   0 },  7, 10 }, //
        {        -150,           0, {   4,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,         -90, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   4,  -3,   0,   0,   0 },  0, 11 }, //
        {        -150,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   3,  -1,   0,   0,   0 },  0, 11 }, //
        {        -150,           0, {   2,   0,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         150,           0, {   2,  -1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         150,           0, {   1,   0,   2,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -150,           0, {   0,   1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         150,           0, {   0,   0,   4,  -2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -150,           0, {   0,   0,   2,  -2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         150, {   0,   0,   2,  -2,   2,   0,  -8,  11,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         150, {   0,   0,   1,  -1,   2,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {        -150,           0, {   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {         150,           0, {   0,   0,   0,   0,   1,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  4, 10 }, //
        {          30,         120, {   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         120,         -30, {   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          30,         120, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          60,         -90, {   0,   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          90,          60, {   0,   0,   0,   0,   0,   0,   0,   6, -11,   0,   0,   0,   0,   0 },  7,  9 }, //
        {          30,         120, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {         150,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -2,   0,   0,   0 },  7, 11 }, //
        {         110,          40, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -4,   0,   0,   0,   0 },  7, 10 }, //
        {           0,         150, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   2 }, 10, 14 }, //
        {        -110,         -30, {   2,   0,   0,  -2,  -1,   0,  -6,   8,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         110,         -30, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {        -140,           0, {   3,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -140,           0, {   3,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -140,           0, {   3,   0,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         140,           0, {   1,   2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         140,           0, {   1,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -140,           0, {   0,   0,   4,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         140, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   1,   0,   0,   0 },  2, 11 }, //
        {         -90,         -50, {   0,   0,   0,   0,   1,   0,  -3,   7,  -4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {          40,         100, {   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,   0,   0,  -2 },  5, 14 }, //
        {         140,           0, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {        -140,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   2 },  7, 14 }, //
        {          50,         -90, {   0,   0,   0,   0,   0,   0,   0,   1,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {        -130,           0, {   2,   0,  -2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         130,           0, {   1,   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -130,           0, {   1,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -130, {   1,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -130,           0, {   1,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -130,           0, {   1,   0,   0,  -2,   0,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         130,           0, {   1,   0,   0,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -130,           0, {   1,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {         130,           0, {   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         130,           0, {   0,   1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        -130,           0, {   0,   0,   2,   6,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -130,           0, {   0,   0,   2,  -2,   0,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,        -130, {   0,   0,   1,  -1,   1,   0,   2,  -4,   0,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {          40,          90, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {         130,           0, {   0,   0,   0,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         130,           0, {   0,   0,   0,   0,   1,   0,   3,  -5,   0,   2,   0,   0,   0,   0 },  4, 10 }, //
        {         130,           0, {   0,   0,   0,   0,   0,   0,   9,  -9,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          30,         100, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {        -130,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -80,          40, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   3,   0,   0,   0 },  2, 11 }, //
        {         -40,          80, {   0,   0,   0,   0,   1,   0,   0,   2,  -4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {          80,         -40, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          40,          80, {   0,   0,   0,   0,   0,   0,   0,   7, -13,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          80,         -40, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   1 }, 10, 14 }, //
        {         120,           0, {   4,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -120,           0, {   3,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -120,           0, {   3,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         120,           0, {   3,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -120,           0, {   2,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -120,           0, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   0,   5,   0,   0,   0 },  0, 11 }, //
        {         120,           0, {   1,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -120, {   1,   0,   1,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -120,           0, {   1,   0,   0,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         120,           0, {   1,  -1,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -120,           0, {   1,  -2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         120,           0, {   0,   1,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -120,           0, {   0,   1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         120,           0, {   0,   0,   2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -120,           0, {   0,   0,   2,  -2,   2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         120, {   0,   0,   2,  -2,   2,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -30,         -90, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {         -30,         -90, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          50,         -70, {   0,   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -50,         -70, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   3,   0,   0,   0,   2 },  7, 14 }, //
        {         -90,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   2 },  9, 14 }, //
        {        -120,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   2 },  9, 14 }, //
        {        -110,           0, {   3,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         110,           0, {   3,  -1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         110,           0, {   2,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -110,           0, {   1,   2,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         110,           0, {   1,   0,  -2,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         110,           0, {   1,  -1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -110,           0, {   1,  -1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -110,           0, {   0,   1,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        -110,           0, {   0,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  3 }, //
        {         110,           0, {   0,   0,   2,  -2,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -80,         -30, {   0,   0,   1,  -1,  -1,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         110,           0, {   0,   0,   0,   0,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {          50,         -60, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          30,          80, {   0,   0,   0,   0,   0,   0,   5, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -50,          60, {   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          80,         -30, {   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          50,         -60, {   0,   0,   0,   0,   0,   0,   0,   9, -17,   0,   0,   0,   0,   0 },  7,  9 }, //
        {           0,         110, {   0,   0,   0,   0,   0,   0,   0,   6, -11,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         110, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         110,           0, {   0,   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         100,           0, {   5,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   4,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   2,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   2,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   2,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   2,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          60,          40, {   2,   0,   0,  -2,  -1,   0,   0,  -5,   6,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          30,          70, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         100,           0, {   2,   0,  -4,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   1,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   1,   1,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {        -100,           0, {   1,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   0,   0,   4,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -100, {   0,   0,   3,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         100, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {         100,           0, {   0,   0,   0,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,        -100, {   0,   0,   0,   0,   0,   0,   9, -12,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -100,           0, {   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -100, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,        -100, {   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         100,           0, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   2,   0,   0,   0,   0 },  6, 10 }, //
        {          50,         -50, {   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {        -100,           0, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         100,           0, {   0,   0,   0,   0,   0,   0,   0,   7, -13,   0,   0,   0,   0,   0 },  7,  9 }, //
        {        -100,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -30,         -70, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   1,   5,   0,   0,  -2 },  7, 14 }, //
        {         -90,           0, {   2,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,           0, {   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,         -40, {   2,   0,  -1,  -1,  -1,   0,   0,   3,  -7,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         -90,           0, {   2,  -1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -90,           0, {   2,  -2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,           0, {   1,   3,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          90,           0, {   1,   0,   0,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,           0, {   1,  -1,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,           0, {   1,  -2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,           0, {   1,  -2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,           0, {   0,   3,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {          90,           0, {   0,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          90, {   0,   0,   2,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          90, {   0,   0,   2,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {         -90,           0, {   0,   0,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          90,           0, {   0,   0,   2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         -90, {   0,   0,   1,  -1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          90, {   0,   0,   1,  -1,   1,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -50,         -40, {   0,   0,   0,   0,   2,   0,   0,  -1,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,          90, {   0,   0,   0,   0,   0,   0,   7,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          90, {   0,   0,   0,   0,   0,   0,   6,  -7,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         -90,           0, {   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          90, {   0,   0,   0,   0,   0,   0,   4,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -90,           0, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          90, {   0,   0,   0,   0,   0,   0,   0,   3,  -2,   0,   0,   0,   0,   0 },  7,  9 }, //
        {          90,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {          30,          60, {   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {          60,         -30, {   0,   2,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          30,         -60, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -60,          30, {   0,   0,   0,   0,   0,   0,   0,   6,  -5,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          60,         -30, {   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          80,           0, {   4,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -80,           0, {   3,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -80,           0, {   3,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          80,           0, {   2,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -80,           0, {   2,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,          50, {   2,   0,   0,  -2,   1,   0,   0,  -6,   8,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,         -80, {   2,   0,  -1,  -1,  -2,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          80,           0, {   1,   2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -80,           0, {   1,   1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -80, {   1,   0,   0,  -2,   0,   0,  20, -21,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          80,           0, {   0,   2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -80,           0, {   0,   0,   4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {          80,           0, {   0,   0,   2,   0,   2,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -80,           0, {   0,   0,   2,   0,   2,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          80,           0, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {           0,          80, {   0,   0,   2,  -2,   1,   0,   0,  -8,  11,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          80, {   0,   0,   2,  -2,   1,  -1,   0,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,         -50, {   0,   0,   2,  -2,   0,   0,   0,  -9,  13,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         -30,          50, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,  -2,   5,   0,   0,   0 },  2, 11 }, //
        {           0,         -80, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   2,   0,   0 },  2, 12 }, //
        {           0,         -80, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   2,   0,   0,   0 },  2, 11 }, //
        {          50,          30, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -2,   4,   0,   0,   0 },  2, 11 }, //
        {          80,           0, {   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -80,           0, {   0,   0,   0,   0,   1,   0,   3,  -5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         -50,         -30, {   0,   0,   0,   0,   1,   0,   0,  -8,  15,   0,   0,   0,   0,   0 },  4,  9 }, //
        {          50,          30, {   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,   0,   0,   0 },  5,  8 }, //
        {          80,           0, {   0,   0,   0,   0,   0,   0,   8, -12,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         -80,           0, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,          80, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          80,           0, {   0,   0,   0,   0,   0,   0,   2,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          80, {   0,   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -80, {   0,   0,   0,   0,   0,   0,   0,   5,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -50,          30, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          80,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0 },  7,  9 }, //
        {          30,          50, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -40,          40, {   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          30,         -50, {   0,   0,   0,   0,   0,   0,   0,   2,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -40,          40, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,   0 },  7, 10 }, //
        {           0,          80, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   2 }, 10, 14 }, //
        {         -70,           0, {   4,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   3,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   3,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          70,           0, {   2,   0,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   2,  -1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {          70,           0, {   1,   1,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -70,           0, {   1,   1,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   1,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   1,   1,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          70,           0, {   1,   1,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   1,   1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          70,           0, {   1,   0,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,           0, {   1,   0,   2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          70,           0, {   1,   0,   0,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,          30, {   1,   0,   0,  -1,   1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          70,           0, {   1,   0,   0,  -2,   0,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  0, 10 }, //
        {         -70,           0, {   1,   0,  -2,  -2,  -2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          70,           0, {   1,  -1,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          70,           0, {   1,  -2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -70,           0, {   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {          70,           0, {   0,   0,   2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {          70,           0, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {         -70,           0, {   0,   0,   1,  -1,   2,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          30,         -40, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,  -2,   0,   0,   0 },  2, 11 }, //
        {         -70,           0, {   0,   0,   0,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,         -70, {   0,   0,   0,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  4, 10 }, //
        {           0,         -70, {   0,   0,   0,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  4, 10 }, //
        {         -30,         -40, {   0,   0,   0,   0,   1,   0,   0,  -9,  17,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,          70, {   0,   0,   0,   0,   0,   0,   8,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          70, {   0,   0,   0,   0,   0,   0,   8, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -70,           0, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          70,           0, {   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -70,           0, {   0,   0,   0,   0,   0,   0,   3,  -7,   4,   0,   0,   0,   0,   0 },  6,  9 }, //
        {         -30,         -40, {   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          70, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   1 },  7, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   0,   6,  -7,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          30,         -40, {   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {         -70,           0, {   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,  -2,   0,   0,   2 },  7, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,  -2,   0,   0,   2 },  7, 14 }, //
        {           0,          70, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,   1 },  7, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   0,   1,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          70,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   2 },  9, 14 }, //
        {         -70,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   2 }, 11, 14 }, //
        {          60,           0, {   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {         -60,           0, {   4,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   3,   0,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -60,           0, {   2,   2,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          60,           0, {   2,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   2,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   2,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   2,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   2,   0,   0,  -2,  -2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -60, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          60,           0, {   2,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   2,   0,  -4,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   2,  -1,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   1,   0,   2,  -2,   2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {         -60,           0, {   1,   0,   0,   0,   0,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          60,           0, {   1,   0,   0,  -2,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -60, {   1,   0,  -1,   1,  -1,   0, -18,  17,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -60,           0, {   1,   0,  -2,  -2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   1,  -1,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -60,           0, {   1,  -1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,           0, {   1,  -2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   1,  -2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          60,           0, {   0,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          60,           0, {   0,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -60,           0, {   0,   1,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          60,           0, {   0,   1,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {         -60,           0, {   0,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -60,           0, {   0,   0,   2,   0,   2,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {          60,           0, {   0,   0,   2,   0,   2,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          60, {   0,   0,   2,  -2,  -1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          60, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         -60, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {          60,           0, {   0,   0,   0,   0,   1,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          60,           0, {   0,   0,   0,   0,   0,   0,   8, -12,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          60,           0, {   0,   0,   0,   0,   0,   0,   8, -16,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          60, {   0,   0,   0,   0,   0,   0,   7,  -8,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          30,         -30, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,         -60, {   0,   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -60,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          60, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   1,   5,   0,   0,   2 },  7, 14 }, //
        {         -60,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -60, {   0,   0,   0,   0,   0,   0,   0,   2,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          60,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0 },  8,  9 }, //
        {         -60,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   2 }, 10, 14 }, //
        {         -60,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2 }, 12, 14 }, //
        {          50,           0, {   4,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   4,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   3,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   3,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -50,           0, {   2,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,   1,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,   0,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   2,   0,   0,  -2,   0,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {          50,           0, {   2,   0,   0,  -2,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          50,           0, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   4,  -5,   0,   0,   0 },  0, 11 }, //
        {          50,           0, {   2,   0,   0,  -2,  -1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          50,           0, {   2,   0,   0,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          50,           0, {   2,  -1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,  -1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   2,  -2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   1,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,   1,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   1,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          50, {   1,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          50, {   1,   0,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -50, {   1,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -50, {   1,   0,   0,   0,   0,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {          50,           0, {   1,   0,   0,   0,   0,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          50,           0, {   1,   0,   0,  -1,   0,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         -50,           0, {   1,   0,   0,  -1,  -1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,          50, {   1,   0,   0,  -2,   0,   0,  17, -16,   0,  -2,   0,   0,   0,   0 },  0, 10 }, //
        {          50,           0, {   1,   0,   0,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   1,   0,  -1,   1,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          50, {   1,   0,  -1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,   0,  -1,  -1,  -1,   0,  20, -20,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -50,           0, {   1,   0,  -2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,   0,  -2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   1,   0,  -2,   0,  -2,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          50,           0, {   1,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          50,           0, {   1,  -1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,  -1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,  -1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   1,  -1,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   1,  -2,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,           0, {   1,  -2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,           0, {   0,   3,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -50,           0, {   0,   2,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {          50,           0, {   0,   1,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          50,           0, {   0,   1,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          50,           0, {   0,   0,   4,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          50,           0, {   0,   0,   2,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -50,           0, {   0,   0,   2,  -2,   2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {          50,           0, {   0,   0,   2,  -2,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {         -50,           0, {   0,   0,   2,  -2,   0,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {         -50,           0, {   0,   0,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {         -50,           0, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,   1,   0,   0,   0 },  2, 11 }, //
        {         -50,           0, {   0,   0,   1,  -1,   2,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          50, {   0,   0,   1,  -1,   1,   0,   1,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          50, {   0,   0,   1,  -1,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -50,           0, {   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {          50,           0, {   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {           0,          50, {   0,   0,   0,   0,   1,   0,   5,  -8,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          50,           0, {   0,   0,   0,   0,   1,   0,   0,   2,  -2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,          50, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,  -1,   0,   0,   0 },  4, 11 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   9,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   9, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0 },  7,  9 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   0,   5, -10,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -4,   0,   0,   0,   2 },  7, 14 }, //
        {          50,           0, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -4,   0,   0,   0,   0 },  7, 10 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -2,   5,   0,   0,   2 },  7, 14 }, //
        {          50,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -2,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,  -1 },  7, 14 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   1 }, 11, 14 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,  -2,  -2 }, 11, 14 }, //
        {          40,           0, {   4,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          40,           0, {   3,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   3,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   3,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   3,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   3,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   3,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          40,           0, {   3,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   3,  -1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          40,           0, {   2,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -40,           0, {   2,   1,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -40,           0, {   2,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   2,   0,   2,   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -40,           0, {   2,   0,   2,  -3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   2,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   2,   2,   0,   0,   0 },  0, 11 }, //
        {          40,           0, {   2,   0,   0,  -2,   0,   0,   0,  -4,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          40,           0, {   2,   0,   0,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   2,   0,  -2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   2,   0,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         -40,           0, {   2,  -1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   2,  -1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   2,  -2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,          30, {   2,  -2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   2,  -2,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   1,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -40,           0, {   1,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -40,           0, {   1,   0,   0,   0,   0,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  0, 10 }, //
        {         -40,           0, {   1,   0,   0,   0,   0,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          40,           0, {   1,   0,   0,  -1,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  0, 10 }, //
        {         -40,           0, {   1,   0,   0,  -2,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -40, {   1,   0,   0,  -2,   0,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -40, {   1,   0,   0,  -2,   0,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {         -40,           0, {   1,   0,   0,  -2,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          40,           0, {   1,   0,   0,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   1,   0,  -4,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   1,  -1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          40,           0, {   1,  -1,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -40,           0, {   1,  -1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,           0, {   1,  -2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,  -2,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   0,   2,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -40,           0, {   0,   2,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          40,           0, {   0,   2,  -2,   2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -40,           0, {   0,   1,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {          40,           0, {   0,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -40,           0, {   0,   1,  -2,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          40,           0, {   0,   0,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          40, {   0,   0,   2,  -2,   1,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {         -40,           0, {   0,   0,   2,  -2,   1,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {          40,           0, {   0,   0,   2,  -2,   1,   0,   0,  -3,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          40, {   0,   0,   2,  -2,   1,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {          40,           0, {   0,   0,   2,  -2,   1,   0,  -5,   5,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -40,           0, {   0,   0,   2,  -2,   0,   0,  -4,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          40,           0, {   0,   0,   2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {           0,         -40, {   0,   0,   1,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -40,           0, {   0,   0,   1,  -1,   2,   0,  -8,  12,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -40,           0, {   0,   0,   1,  -1,   1,   0,   1,  -3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          40, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,  -1,   0,   0 },  2, 12 }, //
        {          40,           0, {   0,   0,   1,  -1,   1,   0,   0,  -4,   6,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          40, {   0,   0,   1,  -1,   1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          40, {   0,   0,   1,  -1,   0,   0,   3,  -6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          40, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {          40,           0, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   0,   1,   0,   0,   0 },  2, 11 }, //
        {           0,          40, {   0,   0,   1,  -1,   0,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,         -40, {   0,   0,   1,  -1,   0,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -40, {   0,   0,   1,  -1,   0,   0,  -4,   5,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -40, {   0,   0,   1,  -1,  -1,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {         -40,           0, {   0,   0,   0,   2,   0,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  3, 10 }, //
        {           0,         -40, {   0,   0,   0,   0,   1,   0,   3,  -4,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,         -40, {   0,   0,   0,   0,   1,   0,   0,   1,   0,  -2,   0,   0,   0,   0 },  4, 10 }, //
        {          40,           0, {   0,   0,   0,   0,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   8,  -9,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   7, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   3,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   0,   7,  -8,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -2,   0,   0,   1 },  7, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   1 },  7, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0 },  9, 11 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0 },  9, 11 }, //
        {          20,          10, {   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0 },  8,  9 }, //
        {         -30,           0, {   5,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   4,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   4,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   4,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   3,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   3,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   3,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   3,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   3,   0,  -2,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   3,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   3,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   3,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -30,           0, {   3,  -1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   2,   2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         -30,           0, {   2,   1,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         -30,           0, {   2,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   2,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   2,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,   2,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,   2,  -2,   2,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         -30,           0, {   2,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   2,   0,   2,  -6,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   2,   0,   1,  -3,   1,   0,  -6,   7,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          30,           0, {   2,   0,   0,  -2,   1,   0,   0,  -5,   6,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,         -30, {   2,   0,   0,  -2,   0,   0,   2,  -5,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   5,  -5,   0,   0,   0 },  0, 11 }, //
        {          30,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   1,   5,   0,   0,   0 },  0, 11 }, //
        {          30,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   0,   5,   0,   0,   0 },  0, 11 }, //
        {          30,           0, {   2,   0,   0,  -2,   0,   0,   0,  -2,   0,   0,   2,   0,   0,   0 },  0, 11 }, //
        {          30,           0, {   2,   0,   0,  -2,   0,   0,  -4,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -30,           0, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   3,  -1,   0,   0,   0 },  0, 11 }, //
        {           0,          30, {   2,   0,   0,  -2,  -1,   0,   0,  -6,   8,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          30,           0, {   2,   0,   0,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,   0,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,   0,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,  -1,  -1,   1,   0,   0,   3,  -7,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,          30, {   2,   0,  -1,  -1,   0,   0,   0,  -1,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          30, {   2,   0,  -2,   0,  -2,   0,   0,   5,  -9,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          30,           0, {   2,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {         -30,           0, {   2,   0,  -2,  -5,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   2,  -1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,  -1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,  -1,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,  -1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,   3,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,   2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   2,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   1,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   1,   1,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,   0,   4,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   1,   0,   2,   0,   2,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   1,   0,   2,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          30, {   1,   0,   2,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {         -30,           0, {   1,   0,   2,   0,   2,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -30,           0, {   1,   0,   2,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   0,   2,  -2,   2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          30,           0, {   1,   0,   2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   0,   2,  -6,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,   0,   1,   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -30,           0, {   1,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   1,   0,   0,   0,   1,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          30,           0, {   1,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   1,   0,   0,   0,   0,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   1,   0,   0,   0,  -1,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          30,           0, {   1,   0,   0,  -1,  -1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          30,           0, {   1,   0,   0,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {         -30,           0, {   1,   0,   0,  -2,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   1,   0,   0,  -2,  -1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   1,   0,   0,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,   0,  -1,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          30,           0, {   1,   0,  -1,   0,  -1,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -30,           0, {   1,   0,  -1,  -1,   0,   0,   0,   8, -15,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,         -30, {   1,   0,  -1,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   0,  -2,   4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,   0,  -2,  -2,  -2,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  0, 10 }, //
        {         -30,           0, {   1,  -1,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,  -1,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,  -1,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,  -1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,           0, {   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          30,           0, {   0,   1,   4,  -4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -30,           0, {   0,   1,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          30,           0, {   0,   1,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          30,           0, {   0,   0,   4,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          30,           0, {   0,   0,   2,   2,   2,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  2, 10 }, //
        {         -30,           0, {   0,   0,   2,   0,   2,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   2,   0,   2,   0,   2,  -3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   2,   0,   2,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   2,   0,   2,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   2,  -2,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -30,           0, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {         -30,           0, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   2,  -2,   1,   0,   0,  -4,   4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          30, {   0,   0,   2,  -2,   1,   0,   0,  -7,   9,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         -30,           0, {   0,   0,   2,  -2,   1,   0,   0, -10,  15,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          30, {   0,   0,   2,  -2,   1,   0,  -8,  11,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -30, {   0,   0,   2,  -2,   0,  -1,   0,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -30, {   0,   0,   1,   1,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -30,           0, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,  -1,   0,   0,   0 },  2, 11 }, //
        {           0,         -30, {   0,   0,   1,  -1,   2,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   1,  -1,   1,   0,   0,   1,  -4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          30, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   1,  -3,   0,   0,   0 },  2, 11 }, //
        {           0,          30, {   0,   0,   1,  -1,   1,   0,  -1,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   1,  -1,   1,   0,  -4,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   1,  -1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   1,  -1,   0,   0,   0,  -1,   0,   0,  -2,   0,   0,   0 },  2, 11 }, //
        {           0,         -30, {   0,   0,   1,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0 },  2,  7 }, //
        {         -30,           0, {   0,   0,   1,  -1,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   1,  -1,  -1,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   0,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -30,           0, {   0,   0,   0,   2,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  3, 10 }, //
        {         -30,           0, {   0,   0,   0,   2,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  3,  8 }, //
        {           0,         -30, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {          30,           0, {   0,   0,   0,   0,   2,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         -30,           0, {   0,   0,   0,   0,   1,   0,   0,   7, -13,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -30,           0, {   0,   0,   0,   0,   1,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  4, 10 }, //
        {           0,          30, {   0,   0,   0,   0,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  4, 10 }, //
        {          30,           0, {   0,   0,   0,   0,   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,          30, {   0,   0,   0,   0,   1,   0,  -1,   2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,          30, {   0,   0,   0,   0,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   9, -13,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   8, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   8, -14,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   7, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   6,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   6,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   6,  -8,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   5,  -4,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   5,  -6,  -4,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   4,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   2,   0,   0,   0,   2 },  6, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0 },  6,  7 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   9, -17,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   7,  -7,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   7, -12,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   6,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   6,  -8,   1,   5,   0,   0,   2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -4,   0,   0,   0,   2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0 },  7,  9 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   5, -13,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   5, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,   1 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,  -1 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   3,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   3,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   2,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -3,   0,   0,   0 },  7, 11 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   2,  -8,   1,   5,   0,   0,  -2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   1 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,  -5,   0,   0,   0 },  7, 11 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   2,   0,   0,   2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,  -3,   0,   0,   0 },  7, 11 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   5,   0,   0,   0 },  7, 11 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0 },  7,  9 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -6,   3,   0,  -2 },  9, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0 },  9, 11 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0 }, 11, 12 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2 }, 13, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,   0,   0,  -2 },  5, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,  -2,   0,   0,   0 },  7, 11 }  //
};

static const nutation_terms A1[38] = { //
        {    -1741882,         289, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {      -36371,        -150, {   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {      -16384,         120, {   0,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       12274,          20, {   0,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        4946,           0, {   0,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       -3659,          10, {   0,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -2277,          20, {   0,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        2012,           0, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {        1366,           0, {   0,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -850,           0, {   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {         720,           0, {   0,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         710,           0, {   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {         628,           0, {   1,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         628,           0, {   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -499,           0, {   2,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -419,           0, {   1,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -352,           0, {   1,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -250,           0, {   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -210,           0, {   0,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -210,           0, {   0,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -209,           0, {   1,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -110,           0, {   0,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         110,           0, {   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {         110,           0, {   0,   1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         110,           0, {   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         110,           0, {   2,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -110,           0, {   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        -110,           0, {   0,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         108,           0, {   1,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         108,           0, {   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {        -107,           0, {   1,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,           0, {   1,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   1,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   1,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -96,           0, {   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          -9,           0, {   2,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          -9,           0, {   0,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          -1,           0, {   2,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }  //
};
