/*
 * Implementation of a DEMReader to download and decode the SRTM2 dataset
 */
package uk.co.mccombe.terrain;

import javax.swing.JComponent;

/**
 *
 * @author Mike McCombe
 */
public class SRTM2Reader extends DEMReader {

    public SRTM2Reader(JComponent item) throws MissingDataFileException, DataFileException {
        super(item);
    }

    public String datasetName() {
        return NAME;
    }

    public boolean downloadable() {
        return DOWNLOADABLE;
    }

    public int recordlength() {
        return RECORDLENGTH;
    }

    public String formatstring() {
        return FILENAMEFORMAT;
    }

    public String extn() {
        return EXTN;
    }

    public boolean littleendian() {
        return LITTLEENDIAN;
    }

    public int missingValue() {
        return MISSINGVALUE;
    }

    public String zipEntryName(String name) {
        return name + ".hgt";
    }

    @Override
    public String[] copyright() {
        return copyright;
    }

    @Override
    protected String getDownloadSiteName() {
        return SITENAME + getProperty(TerrainProperties.REGION);
    }

    @Override
    protected String eastWest(double val) {
        if (val >= 0) {
            return "e";
        }
        return "w";
    }

    @Override
    protected String northSouth(double val) {
        if (val >= 0) {
            return "n";
        }
        return "s";
    }

    @Override
    protected void setDownloadSiteName(String s) {
        demURL = s;
    }
        /**
     * Maximum latitude of SRTM2 dataset
     * Latitude must be less than 61.0
     * @return double 61.0
     */
    @Override
    public double maxLat() {
        return 61.0;
    }
     /**
     * Minimum latitude of SRTM2 dataset
     * Latitude must be greater or equal to -56.0
     * @return double -56.0
     */
    @Override
    public double minLat() {
        return -56.0 ;
    }

    protected String demURL = "Not Downloadable";
    protected static final String SITENAME = "https://dds.cr.usgs.gov/srtm/version2_1/SRTM3/";
    public static final boolean DOWNLOADABLE = false;
    protected static final int RECORDLENGTH = 1201;
    protected static final String FILENAMEFORMAT = "%1s%02d%1s%03d";
    protected static final String NAME = "Shuttle Radar Topography Mission";
    protected static final String EXTN = ".hgt.zip";
    protected static final boolean LITTLEENDIAN = false;
    protected static final int MISSINGVALUE = -32768;
    protected String[] copyright = {"SRTM DEM data is public-domain."};
}
