/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DLayer;
import net.tinyos.mviz.DMoteModel;
import net.tinyos.mviz.DMoteModelListener;

abstract class DShape
extends JComponent
implements DMoteModelListener {
    protected DMoteModel model;
    protected DDocument document;
    public Image img;
    private int lastX;
    private int lastY;
    protected DLayer layer;
    private int action;
    private static final int MOVE = 0;

    public DShape(DMoteModel dMoteModel, DDocument dDocument, DLayer dLayer) {
        this.model = dMoteModel;
        this.img = dDocument.image;
        this.document = dDocument;
        this.layer = dLayer;
        dMoteModel.addListener(this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() + DShape.this.getX();
                int n2 = mouseEvent.getY() + DShape.this.getY();
                int n3 = n - DShape.this.lastX;
                int n4 = n2 - DShape.this.lastY;
                DShape.this.lastX = n;
                DShape.this.lastY = n2;
                switch (DShape.this.action) {
                    case 0: {
                        DShape.this.DoAction(n3, n4);
                    }
                }
            }
        });
        this.synchToModel();
    }

    public DMoteModel getModel() {
        return this.model;
    }

    public void shapeChanged(DMoteModel dMoteModel, int n) {
        this.synchToModel();
        this.repaint();
    }

    public abstract void paintShape(Graphics var1);

    public void paintComponent(Graphics graphics) {
    }

    private void DetermineAction(int n, int n2) {
        this.action = 0;
    }

    private void DoAction(int n, int n2) {
        this.model.applyDeltas(n, n2);
    }

    private void synchToModel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (this.layer.paintMode) {
            case 3: {
                n = this.model.getLocX();
                n2 = this.model.getLocY();
                n3 = 250;
                n4 = 250;
                break;
            }
            case 1: {
                n = this.model.getLocX();
                n2 = this.model.getLocY();
                n3 = 10;
                n4 = 10;
                break;
            }
            case 5: {
                n = this.model.getLocX();
                n2 = this.model.getLocY();
                n3 = 250;
                n4 = 250;
            }
        }
        this.setBounds(0, 0, 0, 0);
    }

    private void selected() {
        this.document.setSelected(this);
    }
}

