/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef COMMON_H
#define COMMON_H

#include <QDebug>

#include "upm-control-dbus/upm_controldbus.h"
#include "upm-upower-dbus/upm_upowerdbus.h"
#include "upm-gsettings/upm_gsettings.h"
#include "upm-common-dbus/upm_commondbus.h"

#include "upm_checkconfig.h"

#define REDUCE_BRIGHTNESS    0
#define INCREASE_BRIGHTNESS  1

#define UPM_POWER_CONFIG_ERROR        "error"
#define UPM_POWER_ACTION_NOTHING      "nothing"
#define UPM_POWER_ACTION_BLANK        "blank"
#define UPM_POWER_ACTION_SUSPEND      "suspend"
#define UPM_POWER_ACTION_HIBERNATE    "hibernate"
#define UPM_POWER_ACTION_SHUTDOWN     "shutdown"

#define DEFAULE_BRIGHTNESS_PERCNET      66
#define DEFAULE_PERCENTAGE_LOW          20
#define DEFAULE_PERCENTAGE_ACTION       5
#define DEFAULE_SLEEP_DISPLAY_TIME      600
#define DEFAULE_SLEEP_COMPUTER_TIME     900

enum policy
{
    power_policy_performance = 0,
    power_policy_balance,
    power_policy_powersave,
    power_policy_unknown
};

#endif // COMMON_H
