/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef POWERSUPPLYDEV_H
#define POWERSUPPLYDEV_H

#include <QObject>

#include "upower-dbus/upowerdbus.h"
#include "upower-dbus/upowerbatterydbus.h"
#include "upower-dbus/upowerlinepowerdbus.h"

typedef enum {
    battery_state_unknown = 0,
    battery_state_charging,
    battery_state_discharging,
    battery_state_empty,
    battery_state_fully,
    battery_state_pending_charge,
    battery_state_pending_discharge,
    battery_state_last
} BatteryState;

class PowerSupplyDev : public QObject
{
    Q_OBJECT
public:
    explicit PowerSupplyDev(QObject *parent = nullptr);
    ~PowerSupplyDev();

private:
    UPowerDBus *m_upowerDBus;

    QVector<UpowerBatteryDBus *> m_batteryDBusVector;

    QVector<UpowerLinePowerDBus *> m_linePowerDBusVector;

    QString m_batteryIconName;

Q_SIGNALS:
    void lidStateChanged(bool);

    void batteryOnlineStateChanged(bool);

    void batteryInfoChanged(int, QStringList);

    void acOnlineStateChanged(int, bool);

private:
    void dealLidStateChanged(bool);

    void dealBatteryOnlineStateChanged(bool);

    void dealBatteryInfoChanged(int, QStringList);

    void dealAcOnlineStateChanged(int, bool);

public Q_SLOTS:
    bool getLidClosedState();

    bool getBatteryOnlineState();

    QString getUpowerDaemonVersion();

    int getBatteryNum();

    int getLinePowerNum();

    int getBatteryState(int index = 0);

    double getOneBatteryPercentage(int index = 0);

    double getBatteryPercentage();

    double calcBatteryPercentage();

    double getEnergyNow(int index = 0);

    double getEnergyFull(int index = 0);

    double getEnergyFullDesign(int index = 0);

    double getEnergyRate(int index = 0);

    qlonglong getTimeToFull(int index = 0);

    qlonglong getTimeToEmpty(int index = 0);

    double getBatteryTemperature(int index = 0);

    int getWarninglevel(int index = 0);

    QString getBatteryVendor(int index = 0);

    QString getBatteryModel(int index = 0);

    QString getOneBatteryIconName(int index = 0);

    QString getBatteryIconName();

    bool getAcOnlineState();
};

#endif // POWERSUPPLYDEV_H
