# Description

Please include a summary of the change and which issue is fixed.
List any dependencies that are required for this change.

Fixes # (issue)

## Type of change

Please delete options that are not relevant.

- [ ] Simple fix (like an one-like typo fix)
- [ ] Workaround (any change than will workaround a bug in upstream libraries)
- [ ] Breaking change (fix that would cause existing functionality to not work as expected)
- [ ] Documentation or translation update

# How Has This Been Tested?

Please describe the tests that you ran to verify your changes.
Provide instructions so we can reproduce.
Please also list any relevant details for your test configuration

- [ ] Test A
- [ ] Test B

**Test Configuration**:
* Distribution version:
* Package versions: (cmake, vala, glib, gtk3, libwnck)
* Toolchain: (gcc, clang, glibc, musl)

# Checklist:

- [ ] My code follows the style guidelines of this project
- [ ] I ran `make clangformat` after any C code change
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings to relevant language (it is ok if Vala code generate C warnings)
- [ ] I have added tests that prove my fix is effective
- [ ] Any dependent changes have been merged and published in downstream modules
