/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.fastinfoset.EncodingAlgorithm;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public abstract class BuiltInEncodingAlgorithm
implements EncodingAlgorithm {
    protected static final Pattern SPACE_PATTERN = Pattern.compile("\\s");

    public abstract int getPrimtiveLengthFromOctetLength(int var1) throws EncodingAlgorithmException;

    public abstract int getOctetLengthFromPrimitiveLength(int var1);

    public abstract void encodeToBytes(Object var1, int var2, int var3, byte[] var4, int var5);

    public void matchWhiteSpaceDelimnatedWords(CharBuffer cb, WordListener wl) {
        Matcher m = SPACE_PATTERN.matcher(cb);
        int i = 0;
        while (m.find()) {
            int s = m.start();
            if (s != i) {
                wl.word(i, s);
            }
            i = m.end();
        }
    }

    public StringBuffer removeWhitespace(char[] ch, int start, int length) {
        int idx;
        StringBuffer buf = new StringBuffer();
        int firstNonWS = 0;
        for (idx = 0; idx < length; ++idx) {
            if (!Character.isWhitespace(ch[idx])) continue;
            if (firstNonWS < idx) {
                buf.append(ch, firstNonWS, idx - firstNonWS);
            }
            firstNonWS = idx + 1;
        }
        if (firstNonWS < idx) {
            buf.append(ch, firstNonWS, idx - firstNonWS);
        }
        return buf;
    }

    public static interface WordListener {
        public void word(int var1, int var2);
    }
}

