/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import com.sun.xml.fastinfoset.sax.AttributesHolder;
import java.io.IOException;
import java.io.Writer;
import org.web3d.vrml.lang.UnsupportedSpecVersionException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXPrinter
extends DefaultHandler {
    protected static final int BYTE_ALGORITHM_ID = 32;
    protected static final int DELTA_ZLIB_INT_ARRAY_ALGORITHM_ID = 33;
    protected static final int QUANTIZED_ZLIB_FLOAT_ARRAY_ALGORITHM_ID = 34;
    private Writer out;
    private StringBuffer textBuffer;
    protected int majorVersion;
    protected int minorVersion;
    private boolean printDocType;

    public SAXPrinter(Writer writer, int n, int n2, boolean bl) {
        this.out = writer;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.printDocType = bl;
    }

    public void startDocument() throws SAXException {
        this.print("<?xml version='1.0' encoding='UTF-8'?>");
        this.printNewLine();
        String string = this.getPublicId(this.majorVersion, this.minorVersion);
        String string2 = this.getSystemId(this.majorVersion, this.minorVersion);
        if (this.printDocType) {
            this.print("<!DOCTYPE X3D PUBLIC \"");
            this.print(string);
            this.print("\" \"");
            this.print(string2);
            this.print("\">\n");
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.printNewLine();
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("SAX error", iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(string);
        } else {
            this.textBuffer.append(string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flushText();
        String string4 = null;
        string4 = string2.equals("") ? string3 : string2;
        this.print("<" + string4);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5;
                String string6 = attributes.getLocalName(i);
                if ("".equals(string6)) {
                    string6 = attributes.getQName(i);
                }
                if ((string5 = attributes.getValue(i)) == null) {
                    AttributesHolder attributesHolder = (AttributesHolder)attributes;
                    Object object = attributesHolder.getAlgorithmData(i);
                    String string7 = "unknown";
                    switch (attributesHolder.getAlgorithmIndex(i)) {
                        case 32: {
                            byte[] byArray = (byte[])attributesHolder.getAlgorithmData(i);
                            break;
                        }
                        case 33: {
                            int[] nArray = (int[])attributesHolder.getAlgorithmData(i);
                            break;
                        }
                        case 34: {
                            float[] fArray = (float[])attributesHolder.getAlgorithmData(i);
                            break;
                        }
                        default: {
                            System.out.println("Unhandled algorithm in SAXPrinter: " + attributesHolder.getAlgorithmIndex(i));
                        }
                    }
                    this.print(" " + string6 + "='" + string7 + "'");
                    continue;
                }
                this.print(" " + string6 + "='" + string5 + "'");
            }
        }
        this.print(">");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushText();
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.print("</" + string4 + ">");
    }

    private void print(String string) throws SAXException {
        try {
            this.out.write(string);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void printNewLine() throws SAXException {
        try {
            this.out.write(System.getProperty("line.separator"));
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void flushText() throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        this.print(this.textBuffer.toString());
        this.textBuffer = null;
    }

    protected String getPublicId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "ISO//Web3D//DTD X3D 3.0//EN";
            }
            case 1: {
                return "ISO//Web3D//DTD X3D 3.1//EN";
            }
            case 2: {
                return "ISO//Web3D//DTD X3D 3.2//EN";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }

    protected String getSystemId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "http://www.web3d.org/specifications/x3d-3.0.dtd";
            }
            case 1: {
                return "http://www.web3d.org/specifications/x3d-3.1.dtd";
            }
            case 2: {
                return "http://www.web3d.org/specifications/x3d-3.2.dtd";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }
}

