//
// Copyright (c) ZeroC, Inc. All rights reserved.
//

package test.Ice.enums;

public class Server extends test.TestHelper
{
    public void run(String[] args)
    {
        Ice.Properties properties = createTestProperties(args);
        properties.setProperty("Ice.Package.Test", "test.Ice.enums");
        try(Ice.Communicator communicator = initialize(properties))
        {
            communicator.getProperties().setProperty("TestAdapter.Endpoints", getTestEndpoint(0));
            Ice.ObjectAdapter adapter = communicator.createObjectAdapter("TestAdapter");
            Ice.Object test = new TestIntfI();
            adapter.add(test, Ice.Util.stringToIdentity("test"));

            adapter.activate();

            serverReady();
            communicator.waitForShutdown();
        }
    }
}
