package ONVIF::Analytics::Types::IPv6NetworkInterface;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Enabled_of :ATTR(:get<Enabled>);
my %Config_of :ATTR(:get<Config>);

__PACKAGE__->_factory(
    [ qw(        Enabled
        Config

    ) ],
    {
        'Enabled' => \%Enabled_of,
        'Config' => \%Config_of,
    },
    {
        'Enabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Config' => 'ONVIF::Analytics::Types::IPv6Configuration',
    },
    {

        'Enabled' => 'Enabled',
        'Config' => 'Config',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::IPv6NetworkInterface

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
IPv6NetworkInterface from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Enabled


=item * Config




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::IPv6NetworkInterface
   Enabled =>  $some_value, # boolean
   Config =>  { # ONVIF::Analytics::Types::IPv6Configuration
     AcceptRouterAdvert =>  $some_value, # boolean
     DHCP => $some_value, # IPv6DHCPConfiguration
     Manual =>  { # ONVIF::Analytics::Types::PrefixedIPv6Address
       Address => $some_value, # IPv6Address
       PrefixLength =>  $some_value, # int
     },
     LinkLocal =>  { # ONVIF::Analytics::Types::PrefixedIPv6Address
       Address => $some_value, # IPv6Address
       PrefixLength =>  $some_value, # int
     },
     FromDHCP =>  { # ONVIF::Analytics::Types::PrefixedIPv6Address
       Address => $some_value, # IPv6Address
       PrefixLength =>  $some_value, # int
     },
     FromRA =>  { # ONVIF::Analytics::Types::PrefixedIPv6Address
       Address => $some_value, # IPv6Address
       PrefixLength =>  $some_value, # int
     },
     Extension =>  { # ONVIF::Analytics::Types::IPv6ConfigurationExtension
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

